/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import gate.DataStore;
import gate.Factory;
import gate.Gate;
import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.util.persistence.Persistence;

public class DSPersistence
implements Persistence {
    protected String className;
    protected String storageUrlString;
    static final long serialVersionUID = 5952924943977701708L;

    public void extractDataFromSource(Object object) throws PersistenceException {
        if (!(object instanceof DataStore)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " can only be used for " + DataStore.class.getName() + " objects!\n" + object.getClass().getName() + " is not a " + DataStore.class.getName());
        }
        DataStore dataStore = (DataStore)object;
        this.className = dataStore.getClass().getName();
        this.storageUrlString = dataStore.getStorageUrl();
    }

    public Object createObject() throws PersistenceException, ResourceInstantiationException {
        for (DataStore dataStore : Gate.getDataStoreRegister()) {
            if (!dataStore.getStorageUrl().equals(this.storageUrlString)) continue;
            return dataStore;
        }
        return Factory.openDataStore(this.className, this.storageUrlString);
    }
}

