/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.util.GateRuntimeException;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProcessManager {
    private static final boolean DEBUG = false;
    private StreamGobbler stdout = new StreamGobbler();
    private StreamGobbler stderr;

    public ProcessManager() {
        Thread thread = new Thread(this.stdout);
        thread.setDaemon(true);
        thread.start();
        this.stderr = new StreamGobbler();
        thread = new Thread(this.stderr);
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized int runProcess(String[] stringArray, boolean bl) throws IOException {
        return this.runProcess(stringArray, bl ? System.out : null, bl ? System.err : null);
    }

    public synchronized int runProcess(String[] stringArray, OutputStream outputStream, OutputStream outputStream2) throws IOException {
        Process process = Runtime.getRuntime().exec(stringArray);
        this.stdout.setInputStream(process.getInputStream());
        this.stdout.setOutputStream(outputStream);
        this.stderr.setInputStream(process.getErrorStream());
        this.stderr.setOutputStream(outputStream2);
        this.notifyAll();
        while (!this.stderr.isDone() || !this.stdout.isDone()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        Integer n = null;
        while (n == null) {
            try {
                n = new Integer(process.waitFor());
            }
            catch (InterruptedException interruptedException) {}
        }
        this.stdout.reset();
        this.stderr.reset();
        Exception exception = null;
        if (this.stdout.hasException()) {
            exception = this.stdout.getException();
            this.stderr.getException();
        } else if (this.stderr.hasException()) {
            exception = this.stderr.getException();
        }
        if (exception != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new GateRuntimeException(exception);
        }
        return n;
    }

    private class StreamGobbler
    implements Runnable {
        private InputStream inputStream = null;
        private OutputStream outputStream = null;
        private byte[] buf = new byte[4096];
        private boolean done = false;
        private Exception exception = null;

        private StreamGobbler() {
        }

        void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        void setOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        boolean hasException() {
            return this.exception != null;
        }

        Exception getException() {
            Exception exception = this.exception;
            this.exception = null;
            return exception;
        }

        boolean isDone() {
            return this.done;
        }

        void reset() {
            this.done = false;
            this.exception = null;
            this.inputStream = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = ProcessManager.this;
            synchronized (object) {
                while (this.inputStream == null) {
                    try {
                        ProcessManager.this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            while (true) {
                object = new BufferedInputStream(this.inputStream);
                int n = -1;
                try {
                    while ((n = ((FilterInputStream)object).read(this.buf)) != -1) {
                        if (this.outputStream == null) continue;
                        this.outputStream.write(this.buf, 0, n);
                    }
                }
                catch (Exception exception) {
                    this.exception = exception;
                }
                try {
                    ((BufferedInputStream)object).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.done = true;
                this.inputStream = null;
                this.outputStream = null;
                ProcessManager processManager = ProcessManager.this;
                synchronized (processManager) {
                    ProcessManager.this.notifyAll();
                    while (this.inputStream == null) {
                        try {
                            ProcessManager.this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }
}

