/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Annotation;
import gate.AnnotationSet;
import gate.util.Out;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassificationMeasures {
    private float[][] confusionMatrix;
    private float kappaCohen = 0.0f;
    private float kappaPi = 0.0f;
    private boolean isCalculatedKappas = false;
    private TreeSet<String> featureValues;

    public ClassificationMeasures() {
    }

    public ClassificationMeasures(AnnotationSet annotationSet, AnnotationSet annotationSet2, String string, String string2) {
        this.createConfusionMatrix(annotationSet, annotationSet2, string, string2);
    }

    public ClassificationMeasures(ArrayList<ClassificationMeasures> arrayList) {
        this.combineConfusionMatrices(arrayList);
    }

    public float getObservedAgreement() {
        float f = this.getAgreedTrials();
        float f2 = this.getTotalTrials();
        if (f2 > 0.0f) {
            return f / f2;
        }
        return 0.0f;
    }

    public float getKappaCohen() {
        if (!this.isCalculatedKappas) {
            this.computeKappaPairwise();
            this.isCalculatedKappas = true;
        }
        return this.kappaCohen;
    }

    public float getKappaPi() {
        if (!this.isCalculatedKappas) {
            this.computeKappaPairwise();
            this.isCalculatedKappas = true;
        }
        return this.kappaPi;
    }

    public float[][] getConfusionMatrix() {
        return (float[][])this.confusionMatrix.clone();
    }

    public SortedSet<String> getFeatureValues() {
        return Collections.unmodifiableSortedSet(this.featureValues);
    }

    public void createConfusionMatrix(AnnotationSet annotationSet, AnnotationSet annotationSet2, String string, String string2) {
        this.featureValues = new TreeSet();
        HashMap<String, HashMap<String, Float>> hashMap = new HashMap<String, HashMap<String, Float>>();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string2);
        AnnotationSet annotationSet3 = annotationSet.get(string, hashSet);
        AnnotationSet annotationSet4 = annotationSet2.get(string, hashSet);
        for (Annotation annotation : annotationSet3) {
            Object object2;
            int n = 0;
            for (Object object2 : annotationSet3) {
                if (!object2.getStartNode().getOffset().equals(annotation.getStartNode().getOffset()) || !object2.getEndNode().getOffset().equals(annotation.getEndNode().getOffset())) continue;
                ++n;
            }
            if (n > 1) {
                Out.prln("ClassificationMeasures: Same span annotations detected! Ignoring.");
                continue;
            }
            int n2 = 0;
            object2 = null;
            for (Object object3 : annotationSet4) {
                if (!object3.getStartNode().getOffset().equals(annotation.getStartNode().getOffset()) || !object3.getEndNode().getOffset().equals(annotation.getEndNode().getOffset())) continue;
                ++n2;
                object2 = object3;
            }
            if (n2 == 0) {
                Out.prln("ClassificationMeasures: Annotation with no counterpart detected!");
                continue;
            }
            if (n2 == 1) {
                Serializable serializable;
                Object object3;
                String string3 = (String)annotation.getFeatures().get(string2);
                object3 = (String)object2.getFeatures().get(string2);
                this.featureValues.add(string3);
                this.featureValues.add((String)object3);
                HashMap<String, Float> hashMap2 = hashMap.get(string3);
                if (hashMap2 == null) {
                    serializable = new HashMap<Object, Float>();
                    ((HashMap)serializable).put(object3, Float.valueOf(1.0f));
                    hashMap.put(string3, (HashMap<String, Float>)serializable);
                    continue;
                }
                serializable = hashMap2.get(object3);
                if (serializable == null) {
                    hashMap2.put((String)object3, Float.valueOf(1.0f));
                    continue;
                }
                hashMap2.put((String)object3, Float.valueOf((float)((Float)serializable).intValue() + 1.0f));
                continue;
            }
            if (n2 <= true) continue;
            Out.prln("ClassificationMeasures: Same span annotations detected! Ignoring.");
        }
        this.confusionMatrix = this.convert2DHashTo2DFloatArray(hashMap, this.featureValues);
    }

    public void combineConfusionMatrices(ArrayList<ClassificationMeasures> arrayList) {
        HashMap<String, HashMap<String, Float>> hashMap = new HashMap<String, HashMap<String, Float>>();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (ClassificationMeasures classificationMeasures : arrayList) {
            int n = 0;
            for (String string : classificationMeasures.featureValues) {
                treeSet.add(string);
                int n2 = 0;
                for (String string2 : classificationMeasures.featureValues) {
                    Serializable serializable;
                    Float f = Float.valueOf(classificationMeasures.confusionMatrix[n][n2]);
                    HashMap<String, Float> hashMap2 = hashMap.get(string);
                    if (hashMap2 == null) {
                        serializable = new HashMap<String, Float>();
                        ((HashMap)serializable).put(string2, f);
                        hashMap.put(string, (HashMap<String, Float>)serializable);
                    } else {
                        serializable = hashMap2.get(string2);
                        if (serializable == null) {
                            hashMap2.put(string2, f);
                        } else {
                            hashMap2.put(string2, Float.valueOf((float)((Float)serializable).intValue() + f.floatValue()));
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        }
        this.confusionMatrix = this.convert2DHashTo2DFloatArray(hashMap, treeSet);
        this.featureValues = treeSet;
        this.isCalculatedKappas = false;
    }

    public void computeKappaPairwise() {
        int n;
        float f;
        float f2 = this.getObservedAgreement();
        int n2 = this.featureValues.size();
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        float f3 = 0.0f;
        for (int i = 0; i < n2; ++i) {
            f = 0.0f;
            for (n = 0; n < n2; ++n) {
                f += this.confusionMatrix[i][n];
            }
            fArray[i] = f;
            f3 += f;
            f = 0.0f;
            for (n = 0; n < n2; ++n) {
                f += this.confusionMatrix[n][i];
            }
            fArray2[i] = f;
        }
        float f4 = 0.0f;
        if (f3 > 0.0f) {
            f = f3 * f3;
            for (n = 0; n < n2; ++n) {
                f4 += fArray[n] * fArray2[n] / f;
            }
        }
        this.kappaCohen = f3 > 0.0f ? (f2 - f4) / (1.0f - f4) : 0.0f;
        f4 = 0.0f;
        if (f3 > 0.0f) {
            f = 2.0f * f3;
            for (n = 0; n < n2; ++n) {
                float f5 = (fArray[n] + fArray2[n]) / f;
                f4 += f5 * f5;
            }
        }
        this.kappaPi = f3 > 0.0f ? (f2 - f4) / (1.0f - f4) : 0.0f;
        float[][] fArray3 = new float[n2][2];
        for (n = 0; n < n2; ++n) {
            fArray3[n][0] = fArray[n] + fArray2[n] > 0.0f ? 2.0f * this.confusionMatrix[n][n] / (fArray[n] + fArray2[n]) : 0.0f;
            fArray3[n][1] = 2.0f * f3 - fArray[n] - fArray2[n] > 0.0f ? 2.0f * (f3 - fArray[n] - fArray2[n] + this.confusionMatrix[n][n]) / (2.0f * f3 - fArray[n] - fArray2[n]) : 0.0f;
        }
    }

    public float getAgreedTrials() {
        float f = 0.0f;
        for (int i = 0; i < this.featureValues.size(); ++i) {
            f += this.confusionMatrix[i][i];
        }
        return f;
    }

    public float getTotalTrials() {
        float f = 0.0f;
        for (int i = 0; i < this.featureValues.size(); ++i) {
            for (int j = 0; j < this.featureValues.size(); ++j) {
                f += this.confusionMatrix[i][j];
            }
        }
        return f;
    }

    public void printConfusionMatrix() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.featureValues.size();
        int n3 = 0;
        for (String string : this.featureValues) {
            Out.prln(n3 + ": " + string);
            ++n3;
        }
        stringBuffer.append("\t|");
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("\t").append(n).append("\t|");
        }
        stringBuffer.append("\n");
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(n).append("\t|");
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append("\t").append(this.confusionMatrix[n][i]).append("\t|");
            }
            stringBuffer.append("\n");
        }
        Out.pr(stringBuffer);
    }

    private float[][] convert2DHashTo2DFloatArray(HashMap<String, HashMap<String, Float>> hashMap, TreeSet<String> treeSet) {
        int n = treeSet.size();
        float[][] fArray = new float[n][n];
        int n2 = 0;
        int n3 = 0;
        for (String string : treeSet) {
            HashMap<String, Float> hashMap2 = hashMap.get(string);
            n3 = 0;
            for (String string2 : treeSet) {
                Float f = null;
                if (hashMap2 != null) {
                    f = hashMap2.get(string2);
                }
                fArray[n2][n3] = f != null ? f.floatValue() : 0.0f;
                ++n3;
            }
            ++n2;
        }
        return fArray;
    }
}

