/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Executable;
import gate.creole.ExecutionException;
import gate.util.Benchmarkable;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class Benchmark {
    protected static boolean benchmarkingEnabled = false;
    public static final String CORPUS_NAME_FEATURE = "corpusName";
    public static final String APPLICATION_NAME_FEATURE = "applicationName";
    public static final String DOCUMENT_NAME_FEATURE = "documentName";
    public static final String PR_NAME_FEATURE = "prName";
    public static final String MESSAGE_FEATURE = "message";
    public static final String PR_PREFIX = "pr_";
    public static final String DOCUMENT_LOADED = "documentLoaded";
    public static final String DOCUMENT_SAVED = "documentSaved";
    public static final String WRITING_FVS_TO_DISK = "writingFVsToDisk";
    public static final String ANNOTS_TO_NLP_FEATURES = "annotsToNlpFeatures";
    public static final String NLP_FEATURES_TO_FVS = "nlpFeaturesToFVs";
    public static final String READING_LEARNING_INFO = "readingLearningInfo";
    public static final String MODEL_APPLICATION = "modelApplication";
    public static final String WRITING_NGRAM_MODEL = "writingNgramModel";
    public static final String TERM_DOC_STATS = "termDocStats";
    public static final String FILTERING = "filtering";
    public static final String MODEL_TRAINING = "modelTraining";
    public static final String EVALUATION = "evaluation";
    public static final String NLP_LABELS_TO_DATA_LABELS = "nlpLabelsToDataLabels";
    public static final String READING_NLP_FEATURES = "readingNlpFeatures";
    public static final String READING_FVS = "readingFVs";
    public static final String WEKA_MODEL_TRAINING = "wekaModelTraining";
    public static final String PAUM_MODEL_TRAINING = "paumModelTraining";
    public static final String READING_CHUNK_LEARNING_DATA = "readingChunkLearningData";
    public static final String WEKA_MODEL_APPLICATION = "wekaModelApplication";
    public static final String PAUM_MODEL_APPLICATION = "paumModelApplication";
    public static final String POST_PROCESSING = "postProcessing";
    public static Logger logger = Logger.getLogger(Benchmark.class);

    public static long startPoint() {
        return System.currentTimeMillis();
    }

    public static long startPoint(String string) {
        long l = Benchmark.startPoint();
        if (benchmarkingEnabled) {
            logger.info((Object)(l + " START " + string));
        }
        return l;
    }

    public static void checkPoint(long l, String string, Object object, Map map) {
        if (!benchmarkingEnabled) {
            return;
        }
        long l2 = System.currentTimeMillis() - l;
        Benchmark.logCheckPoint(String.valueOf(l2), string, object, map);
    }

    public static void checkPointWithDuration(long l, String string, Object object, Map map) {
        if (!benchmarkingEnabled) {
            return;
        }
        Benchmark.logCheckPoint(String.valueOf(l), string, object, map);
    }

    public static void checkPoint(String string, Object object, Map map) {
        if (!benchmarkingEnabled) {
            return;
        }
        Benchmark.logCheckPoint("END", string, object, map);
    }

    private static void logCheckPoint(String string, String string2, Object object, Map map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("" + System.currentTimeMillis() + " ");
        stringBuilder.append(string + " " + string2 + " " + object.getClass().getName() + " ");
        if (map == null) {
            stringBuilder.append("{}");
        } else {
            stringBuilder.append(map.toString().replaceAll("\n", "")).append("\n");
        }
        logger.info((Object)stringBuilder.toString());
    }

    public static String createBenchmarkId(String string, String string2) {
        if (string2 != null) {
            if (string != null) {
                return (string2 + "." + string.replaceAll("\\.", "_")).replaceAll("[ ]+", "_");
            }
            return (string2 + ".null").replaceAll("[ ]+", "_");
        }
        if (string != null) {
            return string.replaceAll("[ .]+", "_");
        }
        return "null";
    }

    public static boolean isBenchmarkingEnabled() {
        return benchmarkingEnabled;
    }

    public static void setBenchmarkingEnabled(boolean bl) {
        benchmarkingEnabled = bl;
    }

    public static void executeWithBenchmarking(Executable executable, String string, Object object, Map map) throws ExecutionException {
        if (!benchmarkingEnabled) {
            executable.execute();
        } else {
            long l = Benchmark.startPoint();
            String string2 = null;
            try {
                try {
                    if (executable instanceof Benchmarkable) {
                        string2 = ((Benchmarkable)((Object)executable)).getBenchmarkId();
                        ((Benchmarkable)((Object)executable)).setBenchmarkId(string);
                    }
                    executable.execute();
                }
                catch (Exception exception) {
                    HashMap<String, Exception> hashMap = new HashMap<String, Exception>();
                    if (map != null) {
                        hashMap.putAll(map);
                    }
                    hashMap.put("exceptionThrown", exception);
                    Benchmark.checkPoint(l, string, object, hashMap);
                    if (exception instanceof ExecutionException) {
                        throw (ExecutionException)exception;
                    }
                    throw (RuntimeException)exception;
                }
                Object var10_6 = null;
                if (string2 != null) {
                    ((Benchmarkable)((Object)executable)).setBenchmarkId(string2);
                }
            }
            catch (Throwable throwable) {
                Object var10_7 = null;
                if (string2 != null) {
                    ((Benchmarkable)((Object)executable)).setBenchmarkId(string2);
                }
                throw throwable;
            }
            Benchmark.checkPoint(l, string, object, map);
        }
    }
}

