/*
 * Decompiled with CFR 0.152.
 */
package gate.security;

import gate.event.GateEvent;
import gate.event.ObjectModificationEvent;
import gate.event.ObjectModificationListener;
import gate.persist.DBHelper;
import gate.persist.PersistenceException;
import gate.security.AccessController;
import gate.security.Group;
import gate.security.GroupImpl;
import gate.security.SecurityException;
import gate.security.SecurityInfo;
import gate.security.Session;
import gate.security.SessionImpl;
import gate.security.User;
import gate.security.UserImpl;
import gate.util.MethodNotImplementedException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import junit.framework.Assert;

public class AccessControllerImpl
implements AccessController,
ObjectModificationListener {
    public static final int DEFAULT_SESSION_TIMEOUT_MIN = 240;
    public static final int LOGIN_OK = 1;
    public static final int LOGIN_FAILED = 2;
    private static long MY_VERY_SECRET_CONSTANT;
    private static final int RANDOM_MAX = 1024;
    private HashMap sessions;
    private HashMap sessionLastUsed;
    private HashMap sessionTimeouts;
    private Connection jdbcConn;
    private String jdbcURL;
    private String jdbcSchema;
    protected int dbType;
    private HashMap usersByID;
    private HashMap usersByName;
    private HashMap groupsByID;
    private HashMap groupsByName;
    private static Random r;
    private boolean isPooled;
    private int refCnt;
    private Vector omModificationListeners;
    private Vector omCreationListeners;
    private Vector omDeletionListeners;

    public AccessControllerImpl(String string) {
        Assert.assertNotNull((Object)string);
        this.refCnt = 0;
        this.jdbcURL = string;
        this.jdbcSchema = DBHelper.getSchemaPrefix(this.jdbcURL);
        this.dbType = DBHelper.getDatabaseType(this.jdbcURL);
        Assert.assertNotNull((Object)this.jdbcSchema);
        Assert.assertTrue((this.dbType == 101 || this.dbType == 102 ? 1 : 0) != 0);
        this.sessions = new HashMap();
        this.sessionLastUsed = new HashMap();
        this.sessionTimeouts = new HashMap();
        this.usersByID = new HashMap();
        this.usersByName = new HashMap();
        this.groupsByID = new HashMap();
        this.groupsByName = new HashMap();
        this.omModificationListeners = new Vector();
        this.omCreationListeners = new Vector();
        this.omDeletionListeners = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws PersistenceException {
        AccessControllerImpl accessControllerImpl = this;
        synchronized (accessControllerImpl) {
            if (this.refCnt++ == 0) {
                try {
                    this.jdbcConn = DBHelper.connect(this.jdbcURL);
                    Assert.assertNotNull((Object)this.jdbcConn);
                    this.init();
                }
                catch (SQLException sQLException) {
                    throw new PersistenceException("could not get DB connection [" + sQLException.getMessage() + "]");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new PersistenceException("cannot locate JDBC driver [" + classNotFoundException.getMessage() + "]");
                }
            }
        }
    }

    public void close() throws PersistenceException {
        if (--this.refCnt == 0) {
            this.sessions.clear();
            this.sessionLastUsed.clear();
            this.sessionTimeouts.clear();
            Set set = this.groupsByName.entrySet();
            for (Map.Entry object22 : set) {
                GroupImpl groupImpl = (GroupImpl)object22.getValue();
                groupImpl.unregisterObjectModificationListener(this, 1001);
            }
            Set set2 = this.usersByName.entrySet();
            for (Map.Entry sQLException : set2) {
                UserImpl userImpl = (UserImpl)sQLException.getValue();
                userImpl.unregisterObjectModificationListener(this, 1001);
            }
            this.omCreationListeners.removeAllElements();
            this.omDeletionListeners.removeAllElements();
            this.omModificationListeners.removeAllElements();
            this.groupsByID.clear();
            this.groupsByName.clear();
            this.usersByID.clear();
            this.groupsByName.clear();
            try {
                if (!this.isPooled) {
                    this.jdbcConn.close();
                }
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("can't close connection to DB:[" + sQLException.getMessage() + "]");
            }
        }
    }

    public Group findGroup(String string) throws PersistenceException, SecurityException {
        Group group = (Group)this.groupsByName.get(string);
        if (null == group) {
            throw new SecurityException("No such group");
        }
        return group;
    }

    public Group findGroup(Long l) throws PersistenceException, SecurityException {
        Group group = (Group)this.groupsByID.get(l);
        if (null == group) {
            throw new SecurityException("No such group");
        }
        return group;
    }

    public User findUser(String string) throws PersistenceException, SecurityException {
        User user = (User)this.usersByName.get(string);
        if (null == user) {
            throw new SecurityException("No such user (" + string + ")");
        }
        return user;
    }

    public User findUser(Long l) throws PersistenceException, SecurityException {
        User user = (User)this.usersByID.get(l);
        if (null == user) {
            throw new SecurityException("No such user");
        }
        return user;
    }

    public Session findSession(Long l) throws SecurityException {
        Session session = (Session)this.sessions.get(l);
        if (null == session) {
            throw new SecurityException("No such session ID!");
        }
        return session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Group createGroup(String string, Session session) throws PersistenceException, SecurityException {
        Object object;
        Long l;
        Assert.assertNotNull((Object)string);
        if (!this.isValidSession(session)) {
            throw new SecurityException("invalid session supplied");
        }
        if (!session.isPrivilegedSession()) {
            throw new SecurityException("insufficient privileges");
        }
        CallableStatement callableStatement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (this.dbType == 101) {
            try {
                try {
                    callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.security.create_group(?,?)} ");
                    callableStatement.setString(1, string);
                    callableStatement.registerOutParameter(2, -5);
                    callableStatement.execute();
                    l = new Long(callableStatement.getLong(2));
                }
                catch (SQLException sQLException) {
                    switch (sQLException.getErrorCode()) {
                        case 20101: {
                            throw new PersistenceException("can't create a group in DB, name is not unique: [" + sQLException.getMessage() + "]");
                        }
                    }
                    throw new PersistenceException("can't create a group in DB: [" + sQLException.getMessage() + "]");
                }
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                DBHelper.cleanup(callableStatement);
                throw throwable;
            }
            DBHelper.cleanup(callableStatement);
        } else {
            if (this.dbType != 102) {
                throw new IllegalArgumentException();
            }
            try {
                try {
                    object = "select security_create_group(?) ";
                    preparedStatement = this.jdbcConn.prepareStatement((String)object);
                    preparedStatement.setString(1, string);
                    preparedStatement.execute();
                    resultSet = preparedStatement.getResultSet();
                    if (!resultSet.next()) {
                        throw new PersistenceException("empty resultset");
                    }
                    l = new Long(resultSet.getLong(1));
                }
                catch (SQLException sQLException) {
                    switch (sQLException.getErrorCode()) {
                        case 20101: {
                            throw new PersistenceException("can't create a group in DB, name is not unique: [" + sQLException.getMessage() + "]");
                        }
                    }
                    throw new PersistenceException("can't create a group in DB: [" + sQLException.getMessage() + "]");
                }
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(preparedStatement);
        }
        object = new GroupImpl(l, string, new Vector(), this, this.jdbcConn);
        ((GroupImpl)object).registerObjectModificationListener(this, 1001);
        this.groupsByID.put(l, object);
        this.groupsByName.put(string, object);
        return object;
    }

    public void deleteGroup(Long l, Session session) throws PersistenceException, SecurityException {
        Group group = (Group)this.groupsByID.get(l);
        if (null == group) {
            throw new SecurityException("incorrect group id supplied ( id = [" + l + "])");
        }
        this.deleteGroup(group, session);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteGroup(Group group, Session session) throws PersistenceException, SecurityException {
        Session session2;
        Map.Entry entry;
        Object object;
        Iterator iterator;
        if (!this.isValidSession(session)) {
            throw new SecurityException("invalid session supplied");
        }
        if (!session.isPrivilegedSession()) {
            throw new SecurityException("insufficient privileges");
        }
        CallableStatement callableStatement = null;
        PreparedStatement preparedStatement = null;
        if (this.dbType == 101) {
            try {
                try {
                    callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.security.delete_group(?) } ");
                    callableStatement.setLong(1, (long)group.getID());
                    callableStatement.execute();
                }
                catch (SQLException sQLException) {
                    switch (sQLException.getErrorCode()) {
                        case 20110: {
                            throw new PersistenceException("can't delete a group from DB, the group owns LR(s): [" + sQLException.getMessage() + "]");
                        }
                    }
                    throw new PersistenceException("can't delete a group from DB: [" + sQLException.getMessage() + "]");
                }
                iterator = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                DBHelper.cleanup(callableStatement);
                throw throwable;
            }
            DBHelper.cleanup(callableStatement);
        } else {
            if (this.dbType != 102) {
                throw new IllegalArgumentException();
            }
            try {
                try {
                    object = "select security_delete_group(?)";
                    preparedStatement = this.jdbcConn.prepareStatement((String)object);
                    preparedStatement.setLong(1, group.getID());
                    preparedStatement.execute();
                }
                catch (SQLException sQLException) {
                    switch (sQLException.getErrorCode()) {
                        case 20110: {
                            throw new PersistenceException("can't delete a group from DB, the group owns LR(s): [" + sQLException.getMessage() + "]");
                        }
                    }
                    throw new PersistenceException("can't delete a group from DB: [" + sQLException.getMessage() + "]");
                }
                entry = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
            DBHelper.cleanup(preparedStatement);
        }
        this.groupsByID.remove(group.getID());
        this.groupsByName.remove(group.getName());
        object = new ObjectModificationEvent(group, 1002, 0);
        this.fireObjectDeletedEvent((ObjectModificationEvent)object);
        Set set = this.sessions.entrySet();
        iterator = set.iterator();
        Vector<SessionImpl> vector = new Vector<SessionImpl>();
        while (iterator.hasNext()) {
            entry = iterator.next();
            session2 = (SessionImpl)entry.getValue();
            if (!session2.getGroup().equals(group)) continue;
            vector.add((SessionImpl)session2);
        }
        int i = 0;
        while (i < vector.size()) {
            session2 = (Session)vector.elementAt(i);
            this.logout(session2);
            ++i;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User createUser(String string, String string2, Session session) throws PersistenceException, SecurityException {
        Object object;
        Long l;
        Assert.assertNotNull((Object)string);
        if (!this.isValidSession(session)) {
            throw new SecurityException("invalid session supplied");
        }
        if (!session.isPrivilegedSession()) {
            throw new SecurityException("insufficient privileges");
        }
        CallableStatement callableStatement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (this.dbType == 101) {
            try {
                try {
                    callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.security.create_user(?,?,?)} ");
                    callableStatement.setString(1, string);
                    callableStatement.setString(2, string2);
                    callableStatement.registerOutParameter(3, -5);
                    callableStatement.execute();
                    l = new Long(callableStatement.getLong(3));
                }
                catch (SQLException sQLException) {
                    switch (sQLException.getErrorCode()) {
                        case 20102: {
                            throw new PersistenceException("can't create a user in DB, name is not unique: [" + sQLException.getMessage() + "]");
                        }
                    }
                    throw new PersistenceException("can't create a user in DB: [" + sQLException.getMessage() + "]");
                }
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                DBHelper.cleanup(callableStatement);
                throw throwable;
            }
            DBHelper.cleanup(callableStatement);
        } else {
            if (this.dbType != 102) {
                throw new IllegalArgumentException();
            }
            try {
                try {
                    object = "select security_create_user(?,?) ";
                    preparedStatement = this.jdbcConn.prepareStatement((String)object);
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string2);
                    preparedStatement.execute();
                    resultSet = preparedStatement.getResultSet();
                    if (!resultSet.next()) {
                        throw new PersistenceException("empty resultset");
                    }
                    l = new Long(resultSet.getLong(1));
                }
                catch (SQLException sQLException) {
                    switch (sQLException.getErrorCode()) {
                        case 20102: {
                            throw new PersistenceException("can't create a user in DB, name is not unique: [" + sQLException.getMessage() + "]");
                        }
                    }
                    throw new PersistenceException("can't create a user in DB: [" + sQLException.getMessage() + "]");
                }
                Object var12_14 = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(preparedStatement);
        }
        object = new UserImpl(l, string, new Vector(), this, this.jdbcConn);
        ((UserImpl)object).registerObjectModificationListener(this, 1001);
        this.usersByID.put(l, object);
        this.usersByName.put(string, object);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteUser(User user, Session session) throws PersistenceException, SecurityException {
        Session session2;
        Map.Entry entry;
        Object object;
        Iterator iterator;
        if (!this.isValidSession(session)) {
            throw new SecurityException("invalid session supplied");
        }
        if (!session.isPrivilegedSession()) {
            throw new SecurityException("insufficient privileges");
        }
        CallableStatement callableStatement = null;
        PreparedStatement preparedStatement = null;
        if (this.dbType == 101) {
            try {
                try {
                    callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.security.delete_user(?) } ");
                    callableStatement.setLong(1, (long)user.getID());
                    callableStatement.execute();
                }
                catch (SQLException sQLException) {
                    switch (sQLException.getErrorCode()) {
                        case 20111: {
                            throw new PersistenceException("can't delete user from DB, the user owns LR(s): [" + sQLException.getMessage() + "]");
                        }
                    }
                    throw new PersistenceException("can't delete user from DB: [" + sQLException.getMessage() + "]");
                }
                iterator = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                DBHelper.cleanup(callableStatement);
                throw throwable;
            }
            DBHelper.cleanup(callableStatement);
        } else {
            if (this.dbType != 102) {
                throw new IllegalArgumentException();
            }
            try {
                try {
                    object = "select security_delete_user(?) ";
                    preparedStatement = this.jdbcConn.prepareStatement((String)object);
                    preparedStatement.setLong(1, user.getID());
                    preparedStatement.execute();
                }
                catch (SQLException sQLException) {
                    switch (sQLException.getErrorCode()) {
                        case 20111: {
                            throw new PersistenceException("can't delete user from DB, the user owns LR(s): [" + sQLException.getMessage() + "]");
                        }
                    }
                    throw new PersistenceException("can't delete user from DB: [" + sQLException.getMessage() + "]");
                }
                entry = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
            DBHelper.cleanup(preparedStatement);
        }
        this.usersByID.remove(user.getID());
        this.usersByName.remove(user.getName());
        object = new ObjectModificationEvent(user, 1002, 0);
        this.fireObjectDeletedEvent((ObjectModificationEvent)object);
        Set set = this.sessions.entrySet();
        iterator = set.iterator();
        Vector<SessionImpl> vector = new Vector<SessionImpl>();
        while (iterator.hasNext()) {
            entry = iterator.next();
            session2 = (SessionImpl)entry.getValue();
            if (!session2.getUser().equals(user)) continue;
            vector.add((SessionImpl)session2);
        }
        int i = 0;
        while (i < vector.size()) {
            session2 = (Session)vector.elementAt(i);
            this.logout(session2);
            ++i;
        }
        return;
    }

    public void deleteUser(Long l, Session session) throws PersistenceException, SecurityException {
        User user = (User)this.usersByID.get(l);
        if (null == user) {
            throw new SecurityException("incorrect user id supplied ( id = [" + l + "])");
        }
        this.deleteUser(user, session);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Session login(String string, String string2, Long l) throws PersistenceException, SecurityException {
        Object object;
        User user = (User)this.usersByName.get(string);
        if (null == user) {
            throw new SecurityException("no such user (username=[" + string + "])");
        }
        Group group = (Group)this.groupsByID.get(l);
        if (null == group) {
            throw new SecurityException("no such group (id=[" + l + "])");
        }
        CallableStatement callableStatement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        if (this.dbType == 101) {
            try {
                try {
                    callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.security.login(?,?,?,?)} ");
                    callableStatement.setString(1, string);
                    callableStatement.setString(2, string2);
                    callableStatement.setLong(3, (long)l);
                    callableStatement.registerOutParameter(4, 2);
                    callableStatement.execute();
                    bl = callableStatement.getInt(4) != 0;
                }
                catch (SQLException sQLException) {
                    switch (sQLException.getErrorCode()) {
                        case 20103: {
                            throw new SecurityException("Login failed: incorrect user");
                        }
                        case 20104: {
                            throw new SecurityException("Login failed: incorrect password");
                        }
                        case 20105: {
                            throw new SecurityException("Login failed: incorrect group");
                        }
                    }
                    throw new PersistenceException("can't login user, DB error is: [" + sQLException.getMessage() + "]");
                }
                Object var12_10 = null;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                DBHelper.cleanup(callableStatement);
                throw throwable;
            }
            DBHelper.cleanup(callableStatement);
        } else {
            if (this.dbType != 102) {
                throw new IllegalArgumentException();
            }
            try {
                try {
                    object = "select security_login(?,?,?) ";
                    preparedStatement = this.jdbcConn.prepareStatement((String)object);
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string2);
                    preparedStatement.setLong(3, l);
                    preparedStatement.execute();
                    resultSet = preparedStatement.getResultSet();
                    if (!resultSet.next()) {
                        throw new PersistenceException("empty resultset");
                    }
                    bl = resultSet.getBoolean(1);
                }
                catch (SQLException sQLException) {
                    switch (sQLException.getErrorCode()) {
                        case 20103: {
                            throw new SecurityException("Login failed: incorrect user");
                        }
                        case 20104: {
                            throw new SecurityException("Login failed: incorrect password");
                        }
                        case 20105: {
                            throw new SecurityException("Login failed: incorrect group");
                        }
                    }
                    throw new PersistenceException("can't login user, DB error is: [" + sQLException.getMessage() + "]");
                }
                Object var14_17 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(preparedStatement);
        }
        object = this.createSessionID();
        while (true) {
            if (!this.sessions.containsKey(object)) {
                SessionImpl sessionImpl = new SessionImpl((Long)object, user, group, 240, bl);
                this.sessions.put(sessionImpl.getID(), sessionImpl);
                this.sessionTimeouts.put(object, new Long(240L));
                this.touchSession(sessionImpl);
                return sessionImpl;
            }
            object = this.createSessionID();
        }
    }

    public void logout(Session session) throws SecurityException {
        Assert.assertNotNull((Object)session);
        Long l = session.getID();
        Session session2 = (Session)this.sessions.remove(l);
        Assert.assertNotNull((Object)session2);
        Object v = this.sessionLastUsed.remove(l);
        Assert.assertNotNull(v);
        Object v2 = this.sessionTimeouts.remove(l);
        Assert.assertNotNull(v2);
    }

    public void setSessionTimeout(Session session, int n) throws SecurityException {
        this.sessionTimeouts.put(session.getID(), new Long(n));
    }

    public boolean isValidSession(Session session) {
        if (!this.sessions.containsKey(session.getID())) {
            return false;
        }
        Assert.assertNotNull(this.sessionLastUsed.get(session.getID()));
        long l = (Long)this.sessionLastUsed.get(session.getID());
        long l2 = (Long)this.sessionTimeouts.get(session.getID());
        long l3 = System.currentTimeMillis();
        long l4 = (l3 - l) / 60000L;
        if (l4 > l2) {
            try {
                this.logout(session);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return false;
        }
        this.touchSession(session);
        return true;
    }

    public List listGroups() throws PersistenceException {
        Object object;
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<Object> vector = new Vector<Object>();
        try {
            statement = this.jdbcConn.createStatement();
            String string = " SELECT grp_name  FROM   " + this.jdbcSchema + "t_group " + " ORDER BY grp_name ASC";
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                object = resultSet.getString(1);
                vector.add(object);
            }
            object = vector;
            Object var7_7 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("cannot read groups from DB :[" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(statement);
                throw throwable;
            }
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(statement);
        return object;
    }

    public List listUsers() throws PersistenceException {
        Object object;
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<Object> vector = new Vector<Object>();
        try {
            statement = this.jdbcConn.createStatement();
            String string = " SELECT usr_login  FROM   " + this.jdbcSchema + "t_user " + " ORDER BY usr_login DESC";
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                object = resultSet.getString(1);
                vector.add(object);
            }
            object = vector;
            Object var7_7 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("cannot read groups from DB :[" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(statement);
                throw throwable;
            }
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(statement);
        return object;
    }

    private void touchSession(Session session) {
        this.sessionLastUsed.put(session.getID(), new Long(System.currentTimeMillis()));
    }

    private Long createSessionID() {
        return new Long((System.currentTimeMillis() << 16 >> 16) * (long)r.nextInt(1024) * Runtime.getRuntime().freeMemory() * MY_VERY_SECRET_CONSTANT);
    }

    private boolean canDeleteGroup(Group group) throws PersistenceException, SecurityException {
        if (!this.groupsByID.containsValue(group)) {
            throw new SecurityException("no such group (id=[" + group.getID() + "])");
        }
        CallableStatement callableStatement = null;
        CallableStatement callableStatement2 = null;
        ResultSet resultSet = null;
        if (this.dbType == 101) {
            boolean bl;
            try {
                boolean bl2;
                callableStatement = this.jdbcConn.prepareCall("{ ? = call gateadmin.security.can_delete_group(?) }");
                callableStatement.registerOutParameter(1, 4);
                callableStatement.setLong(2, (long)group.getID());
                callableStatement.execute();
                bl = bl2 = callableStatement.getBoolean(1);
                Object var8_11 = null;
            }
            catch (SQLException sQLException) {
                try {
                    throw new PersistenceException("can't perform document checks, DB error is: [" + sQLException.getMessage() + "]");
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    DBHelper.cleanup(callableStatement);
                    throw throwable;
                }
            }
            DBHelper.cleanup(callableStatement);
            return bl;
        }
        if (this.dbType == 102) {
            boolean bl;
            try {
                boolean bl3;
                String string = "select security_can_delete_group(?)";
                callableStatement2 = this.jdbcConn.prepareCall(string);
                callableStatement2.setLong(1, (long)group.getID());
                callableStatement2.execute();
                resultSet = callableStatement2.getResultSet();
                if (!resultSet.next()) {
                    throw new PersistenceException("empty resultset");
                }
                bl = bl3 = resultSet.getBoolean(1);
                Object var10_15 = null;
            }
            catch (SQLException sQLException) {
                try {
                    throw new PersistenceException("can't perform document checks, DB error is: [" + sQLException.getMessage() + "]");
                }
                catch (Throwable throwable) {
                    Object var10_16 = null;
                    DBHelper.cleanup(resultSet);
                    DBHelper.cleanup(callableStatement2);
                    throw throwable;
                }
            }
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(callableStatement2);
            return bl;
        }
        throw new IllegalArgumentException();
    }

    private boolean canDeleteUser(User user) throws PersistenceException, SecurityException {
        if (!this.usersByID.containsValue(user)) {
            throw new SecurityException("no such user (id=[" + user.getID() + "])");
        }
        CallableStatement callableStatement = null;
        CallableStatement callableStatement2 = null;
        ResultSet resultSet = null;
        if (this.dbType == 101) {
            boolean bl;
            try {
                boolean bl2;
                callableStatement = this.jdbcConn.prepareCall("{ ? = call gateadmin.security.can_delete_user(?) }");
                callableStatement.registerOutParameter(1, 4);
                callableStatement.setLong(2, (long)user.getID());
                callableStatement.execute();
                bl = bl2 = callableStatement.getBoolean(1);
                Object var8_11 = null;
            }
            catch (SQLException sQLException) {
                try {
                    throw new PersistenceException("can't perform document checks, DB error is: [" + sQLException.getMessage() + "]");
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    DBHelper.cleanup(callableStatement);
                    throw throwable;
                }
            }
            DBHelper.cleanup(callableStatement);
            return bl;
        }
        if (this.dbType == 102) {
            boolean bl;
            try {
                boolean bl3;
                String string = "select security_can_delete_user(?) ";
                callableStatement2 = this.jdbcConn.prepareCall(string);
                callableStatement2.setLong(1, (long)user.getID());
                callableStatement2.execute();
                bl = bl3 = resultSet.getBoolean(1);
                Object var10_15 = null;
            }
            catch (SQLException sQLException) {
                try {
                    throw new PersistenceException("can't perform document checks, DB error is: [" + sQLException.getMessage() + "]");
                }
                catch (Throwable throwable) {
                    Object var10_16 = null;
                    DBHelper.cleanup(resultSet);
                    DBHelper.cleanup(callableStatement2);
                    throw throwable;
                }
            }
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(callableStatement2);
            return bl;
        }
        throw new IllegalArgumentException();
    }

    private void init() throws PersistenceException {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Vector<Object> vector;
        Statement statement = null;
        ResultSet resultSet = null;
        Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
        Hashtable hashtable2 = new Hashtable();
        Hashtable<Long, String> hashtable3 = new Hashtable<Long, String>();
        Hashtable hashtable4 = new Hashtable();
        try {
            try {
                long l;
                statement = this.jdbcConn.createStatement();
                String string = " SELECT grp_id,         grp_name  FROM   " + this.jdbcSchema + "t_group";
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    l = resultSet.getLong(1);
                    vector = resultSet.getString(2);
                    hashtable.put(new Long(l), (String)((Object)vector));
                    hashtable2.put(new Long(l), new Vector());
                }
                DBHelper.cleanup(resultSet);
                string = " SELECT usr_id,         usr_login  FROM   " + this.jdbcSchema + "t_user";
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    l = resultSet.getLong(1);
                    vector = resultSet.getString(2);
                    hashtable3.put(new Long(l), (String)((Object)vector));
                    hashtable4.put(new Long(l), new Vector());
                }
                DBHelper.cleanup(resultSet);
                string = " SELECT    UGRP_GROUP_ID,            UGRP_USER_ID  FROM      " + this.jdbcSchema + "t_user_group " + " ORDER BY  UGRP_GROUP_ID asc";
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    Long l2 = new Long(resultSet.getLong(1));
                    object4 = new Long(resultSet.getLong(2));
                    vector = (Vector)hashtable2.get(l2);
                    vector.add(object4);
                    object3 = (Vector)hashtable4.get(object4);
                    ((Vector)object3).add(l2);
                }
                DBHelper.cleanup(resultSet);
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("DB error is: [" + sQLException.getMessage() + "]");
            }
            object2 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(statement);
            throw throwable;
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(statement);
        Vector<Object> vector2 = new Vector<Object>();
        object4 = hashtable.keys();
        while (object4.hasMoreElements()) {
            vector = (Long)object4.nextElement();
            object3 = (String)hashtable.get(vector);
            object = new GroupImpl((Long)((Object)vector), (String)object3, new Vector(), this, this.jdbcConn);
            ((GroupImpl)object).registerObjectModificationListener(this, 1001);
            this.groupsByID.put(((GroupImpl)object).getID(), object);
            this.groupsByName.put(((GroupImpl)object).getName(), object);
            vector2.add(object);
        }
        vector = new Vector<Object>();
        object3 = hashtable3.keys();
        while (object3.hasMoreElements()) {
            object = (Long)object3.nextElement();
            object2 = (String)hashtable3.get(object);
            UserImpl userImpl = new UserImpl((Long)object, (String)object2, new Vector(), this, this.jdbcConn);
            userImpl.registerObjectModificationListener(this, 1001);
            this.usersByID.put(userImpl.getID(), userImpl);
            this.usersByName.put(userImpl.getName(), userImpl);
            vector.add(userImpl);
        }
        for (n = 0; n < vector2.size(); ++n) {
            object2 = (GroupImpl)vector2.elementAt(n);
            ((GroupImpl)object2).setUsers((Vector)hashtable2.get(((GroupImpl)object2).getID()));
        }
        for (n = 0; n < vector.size(); ++n) {
            object2 = (UserImpl)vector.elementAt(n);
            ((UserImpl)object2).setGroups((Vector)hashtable4.get(((UserImpl)object2).getID()));
        }
    }

    private void fireObjectCreatedEvent(ObjectModificationEvent objectModificationEvent) {
        if (objectModificationEvent.getType() != 1000) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.omCreationListeners.size(); ++i) {
            ((ObjectModificationListener)this.omCreationListeners.elementAt(i)).objectCreated(objectModificationEvent);
        }
    }

    private void fireObjectDeletedEvent(ObjectModificationEvent objectModificationEvent) {
        if (objectModificationEvent.getType() != 1002) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.omDeletionListeners.size(); ++i) {
            ((ObjectModificationListener)this.omDeletionListeners.elementAt(i)).objectDeleted(objectModificationEvent);
        }
    }

    private void fireObjectModifiedEvent(ObjectModificationEvent objectModificationEvent) {
        if (objectModificationEvent.getType() != 1001) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.omModificationListeners.size(); ++i) {
            ((ObjectModificationListener)this.omModificationListeners.elementAt(i)).objectModified(objectModificationEvent);
        }
    }

    public void registerObjectModificationListener(ObjectModificationListener objectModificationListener, int n) {
        if (n != 1000 && n != 1002 && n != 1001) {
            throw new IllegalArgumentException();
        }
        switch (n) {
            case 1000: {
                this.omCreationListeners.add(objectModificationListener);
                break;
            }
            case 1002: {
                this.omDeletionListeners.add(objectModificationListener);
                break;
            }
            case 1001: {
                this.omModificationListeners.add(objectModificationListener);
                break;
            }
            default: {
                Assert.fail();
            }
        }
    }

    public void unregisterObjectModificationListener(ObjectModificationListener objectModificationListener, int n) {
        if (n != 1000 && n != 1002 && n != 1001) {
            throw new IllegalArgumentException();
        }
        switch (n) {
            case 1000: {
                this.omCreationListeners.remove(objectModificationListener);
                break;
            }
            case 1002: {
                this.omDeletionListeners.remove(objectModificationListener);
                break;
            }
            case 1001: {
                this.omModificationListeners.remove(objectModificationListener);
                break;
            }
            default: {
                Assert.fail();
            }
        }
    }

    public void objectCreated(ObjectModificationEvent objectModificationEvent) {
        Assert.fail();
    }

    public void objectModified(ObjectModificationEvent objectModificationEvent) {
        Object object = objectModificationEvent.getSource();
        int n = objectModificationEvent.getType();
        int n2 = objectModificationEvent.getSubType();
        if (n != 1001) {
            throw new IllegalArgumentException();
        }
        if (!(object instanceof Group) && !(object instanceof User)) {
            throw new IllegalArgumentException();
        }
        if (object instanceof Group) {
            Assert.assertTrue((n2 == 1002 || n2 == 1001 || n2 == 1003 ? 1 : 0) != 0);
            if (n2 == 1001) {
                Set set = this.groupsByName.entrySet();
                Iterator iterator = set.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    Group group;
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    if (string.equals((group = (Group)entry.getValue()).getName())) continue;
                    this.groupsByName.remove(string);
                    this.groupsByName.put(group.getName(), group);
                    bl = true;
                    break;
                }
                Assert.assertTrue((boolean)bl);
            }
        } else {
            Assert.assertTrue((boolean)(object instanceof User));
            Assert.assertTrue((n2 == 1001 ? 1 : 0) != 0);
            if (n2 == 1001) {
                Set set = this.usersByName.entrySet();
                Iterator iterator = set.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    User user;
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    if (string.equals((user = (User)entry.getValue()).getName())) continue;
                    this.usersByName.remove(string);
                    this.usersByName.put(user.getName(), user);
                    bl = true;
                    break;
                }
                Assert.assertTrue((boolean)bl);
            }
        }
    }

    public void objectDeleted(ObjectModificationEvent objectModificationEvent) {
        Assert.fail();
    }

    public void processGateEvent(GateEvent gateEvent) {
        throw new MethodNotImplementedException();
    }

    public boolean isValidSecurityInfo(SecurityInfo securityInfo) {
        switch (securityInfo.getAccessMode()) {
            case 1: 
            case 2: {
                return null != securityInfo.getGroup();
            }
            case 3: {
                return null != securityInfo.getGroup() && null != securityInfo.getUser();
            }
            case 4: {
                return null != securityInfo.getUser();
            }
        }
        throw new IllegalArgumentException();
    }

    public void finalize() {
        try {
            this.jdbcConn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static {
        r = new Random();
        MY_VERY_SECRET_CONSTANT = (long)(r.nextInt(1024) * r.nextInt(1024)) + Math.round(8.539734222673566);
    }
}

