/*
 * Decompiled with CFR 0.152.
 */
package gate.print;

import gate.event.StatusListener;
import gate.gui.MainFrame;
import gate.util.Err;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class JComponentPrinter
implements Pageable {
    JComponent component;
    PageFormat pageFormat;
    int pageCount;
    double scaleFactor;

    public JComponentPrinter(JComponent jComponent, PageFormat pageFormat) {
        this.component = jComponent;
        this.pageFormat = pageFormat;
        Rectangle rectangle = jComponent.getBounds(null);
        this.scaleFactor = Math.min(pageFormat.getImageableWidth() / (double)rectangle.width, 1.0);
        this.pageCount = (int)(((double)rectangle.height * this.scaleFactor + this.pageFormat.getImageableHeight() - 1.0) / this.pageFormat.getImageableHeight());
    }

    public int getNumberOfPages() {
        return this.pageCount;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        if (n >= this.pageCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.pageFormat;
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        if (n >= this.pageCount) {
            throw new IndexOutOfBoundsException();
        }
        double d = (double)n * this.pageFormat.getImageableHeight() / this.scaleFactor;
        if (this.component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)this.component;
            int n2 = jTextComponent.viewToModel(new Point(0, (int)d));
            try {
                Rectangle rectangle = jTextComponent.modelToView(n2);
                d = rectangle.y + rectangle.height - 1;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace(Err.getPrintWriter());
            }
        }
        return new TranslatedPrintable(d);
    }

    public class TranslatedPrintable
    implements Printable {
        double originY;

        public TranslatedPrintable(double d) {
            this.originY = d;
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            Rectangle rectangle = JComponentPrinter.this.component.getBounds(null);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX() - (double)rectangle.x, pageFormat.getImageableY() - this.originY - (double)rectangle.y);
            graphics2D.scale(JComponentPrinter.this.scaleFactor, JComponentPrinter.this.scaleFactor);
            if (JComponentPrinter.this.component instanceof JTextComponent) {
                Rectangle rectangle2;
                JTextComponent jTextComponent = (JTextComponent)JComponentPrinter.this.component;
                double d = (double)(n + 1) * pageFormat.getImageableHeight() / JComponentPrinter.this.scaleFactor;
                int n2 = jTextComponent.viewToModel(new Point(0, (int)d));
                try {
                    rectangle2 = jTextComponent.modelToView(n2);
                    d = rectangle2.y;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace(Err.getPrintWriter());
                }
                rectangle2 = graphics2D.getClip().getBounds();
                rectangle2.setSize((int)rectangle2.getWidth(), (int)(d - this.originY) - 1);
                graphics2D.setClip(rectangle2);
            }
            boolean bl = JComponentPrinter.this.component.isDoubleBuffered();
            JComponentPrinter.this.component.paint(graphics2D);
            JComponentPrinter.this.component.setDoubleBuffered(bl);
            StatusListener statusListener = (StatusListener)((Object)MainFrame.getListeners().get("gate.event.StatusListener"));
            if (statusListener != null) {
                statusListener.statusChanged("Printing page " + (n + 1) + "/" + JComponentPrinter.this.pageCount);
            }
            return 0;
        }
    }
}

