/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.jape.Batch;
import gate.jape.JapeException;
import gate.jape.MultiPhaseTransducer;
import gate.jape.Transducer;
import gate.jape.parser.ParseCpsl;
import gate.util.Err;
import gate.util.Files;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseJapeTests
extends TestCase {
    protected static final String DEFAULT_DATA_FILE = "jape/InputTexts/AveShort";

    public BaseJapeTests(String string) {
        super(string);
    }

    protected Set<Annotation> doTest(String string, String string2, AnnotationCreator annotationCreator) throws ResourceInstantiationException, JapeException, ExecutionException {
        Corpus corpus = this.createCorpus(string);
        Document document = (Document)corpus.get(0);
        annotationCreator.createAnnots(document);
        Set<Annotation> set = this.runTransducer(corpus, string2);
        return set;
    }

    protected Set<Annotation> doTest(Document document, String string, AnnotationCreator annotationCreator) throws ResourceInstantiationException, JapeException, ExecutionException {
        Corpus corpus = this.createCorpus(document);
        annotationCreator.createAnnots(document);
        Set<Annotation> set = this.runTransducer(corpus, string);
        return set;
    }

    protected void compareResults(String[] stringArray, Set<Annotation> set) {
        int n = 0;
        BaseJapeTests.assertEquals((String)"Different number of results expected", (int)stringArray.length, (int)set.size());
        for (Annotation annotation : set) {
            String string = (String)annotation.getFeatures().get("rule");
            BaseJapeTests.assertEquals((String)("Rule " + stringArray[n] + " did not match as expected"), (String)stringArray[n], (String)string);
            ++n;
        }
    }

    protected Corpus createCorpus(String string) throws ResourceInstantiationException {
        try {
            Document document = Factory.newDocument(Files.getGateResourceAsString(string));
            return this.createCorpus(document);
        }
        catch (Exception exception) {
            exception.printStackTrace(Err.getPrintWriter());
            BaseJapeTests.assertTrue((String)"Error creating corpus", (boolean)false);
            return null;
        }
    }

    protected Corpus createCorpus(Document document) throws ResourceInstantiationException {
        Corpus corpus = Factory.newCorpus("TestJape corpus");
        corpus.add(document);
        return corpus;
    }

    protected Document createDoc(String string) {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("stringContent", string);
        featureMap.put("markupAware", "true");
        featureMap.put("mimeType", "text/plain");
        Document document = null;
        try {
            document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new RuntimeException(resourceInstantiationException);
        }
        return document;
    }

    protected Set<Annotation> runTransducer(Corpus corpus, String string) throws JapeException, ExecutionException {
        Batch batch = new Batch(Files.getGateResource(string), "UTF-8");
        batch.transduce(corpus);
        Document document = (Document)corpus.get(0);
        TreeSet<Annotation> treeSet = new TreeSet<Annotation>(new OffsetComparator());
        treeSet.addAll(document.getAnnotations().get("Result"));
        return treeSet;
    }

    protected void parseJapeString(String string) throws Exception {
        StringReader stringReader = new StringReader(string);
        ParseCpsl parseCpsl = Factory.newJapeParser(stringReader, new HashMap());
        MultiPhaseTransducer multiPhaseTransducer = parseCpsl.MultiPhaseTransducer();
        ((Transducer)multiPhaseTransducer).finish();
    }

    public static abstract class BaseAnnotationCreator
    implements AnnotationCreator {
        protected AnnotationSet as;
        protected int curOffset = 0;
        protected int annotLength = 2;
        protected static FeatureMap emptyFeat = Factory.newFeatureMap();

        public void setDoc(Document document) {
            this.as = document.getAnnotations();
        }

        public AnnotationCreator add(int n, int n2, String string) {
            return this.add(n, n2, string, emptyFeat);
        }

        public AnnotationCreator add(int n, int n2, String string, FeatureMap featureMap) {
            try {
                this.as.add(new Long(n), new Long(n2), string, featureMap);
            }
            catch (InvalidOffsetException invalidOffsetException) {
                invalidOffsetException.printStackTrace(Err.getPrintWriter());
            }
            return this;
        }

        public AnnotationCreator addInc(String string) {
            this.add(string);
            this.curOffset += this.annotLength;
            return this;
        }

        public AnnotationCreator add(String string) {
            try {
                this.as.add(new Long(this.curOffset), new Long(this.curOffset + this.annotLength), string, emptyFeat);
            }
            catch (InvalidOffsetException invalidOffsetException) {
                invalidOffsetException.printStackTrace(Err.getPrintWriter());
            }
            return this;
        }
    }

    public static interface AnnotationCreator {
        public void setDoc(Document var1);

        public AnnotationSet createAnnots(Document var1);

        public AnnotationCreator addInc(String var1);

        public AnnotationCreator add(int var1, int var2, String var3);

        public AnnotationCreator add(int var1, int var2, String var3, FeatureMap var4);

        public AnnotationCreator add(String var1);
    }
}

