/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Gate;
import gate.LanguageResource;
import gate.Resource;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OConstants;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.OResource;
import gate.creole.ontology.Ontology;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.gui.annedit.AnnotationDataImpl;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.AnnotationSetsView;
import gate.gui.docview.DocumentView;
import gate.gui.docview.OntologyInstanceView;
import gate.gui.docview.TextualDocumentView;
import gate.gui.ontology.OResourceNode;
import gate.gui.ontology.OntologyItemComparator;
import gate.util.LuckyException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyClassView
extends AbstractDocumentView
implements CreoleListener {
    protected Ontology selectedOntology;
    protected TextualDocumentView textView;
    protected JTextArea textArea;
    protected OntologyInstanceView instanceView;
    protected JPanel mainPanel;
    protected JLabel messageLabel;
    protected JScrollPane scrollPane;
    protected JTree tree;
    protected DefaultTreeModel treeModel;
    protected DefaultMutableTreeNode rootNode;
    protected JComboBox setComboBox;
    protected OClass selectedClass;
    protected Set<OClass> selectedClasses;
    protected Map<OClass, Color> classColorMap = new HashMap<OClass, Color>();
    protected Map<OClass, List> classHighlightsDataMap;
    protected String selectedSet;
    protected OntologyItemComparator itemComparator;
    protected MouseStoppedMovingAction mouseStoppedMovingAction;
    protected TextMouseListener textMouseListener;
    protected Timer mouseMovementTimer;
    protected static final int MOUSE_MOVEMENT_TIMER_DELAY = 500;

    public OntologyClassView() {
        this.selectedClasses = new HashSet<OClass>();
        this.classHighlightsDataMap = new HashMap<OClass, List>();
        this.itemComparator = new OntologyItemComparator();
    }

    @Override
    protected void initGUI() {
        Object object;
        Object object2;
        Object object3;
        Iterator<DocumentView> iterator = this.owner.getCentralViews().iterator();
        while (this.textView == null && iterator.hasNext()) {
            object3 = iterator.next();
            if (!(object3 instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)object3;
        }
        this.textArea = this.textView.getTextView();
        object3 = this.owner.getHorizontalViews().iterator();
        while (this.instanceView == null && object3.hasNext()) {
            object2 = (DocumentView)object3.next();
            if (!(object2 instanceof OntologyInstanceView)) continue;
            this.instanceView = (OntologyInstanceView)object2;
        }
        this.instanceView.setOwner(this.owner);
        object2 = Gate.getCreoleRegister().getPublicLrInstances();
        Object object4 = object2.iterator();
        while (object4.hasNext()) {
            object = (LanguageResource)object4.next();
            if (!(object instanceof Ontology)) continue;
            this.selectedOntology = (Ontology)object;
            break;
        }
        this.mainPanel = new JPanel(new BorderLayout());
        this.rootNode = new DefaultMutableTreeNode(null, true);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new ClassTreeCellRenderer());
        this.tree.setCellEditor(new ClassTreeCellEditor(this.tree));
        this.tree.setEditable(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.scrollPane = new JScrollPane(this.tree);
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.setComboBox = new JComboBox();
        this.setComboBox.setEditable(true);
        this.setComboBox.setToolTipText("Annotation set where to load/save the annotations");
        this.mainPanel.add((Component)this.setComboBox, "South");
        this.initListeners();
        this.instanceView.setClassView(this);
        this.instanceView.setActive(true);
        this.textView.getOwner().setBottomView(this.instanceView);
        if (this.selectedOntology == null) {
            this.messageLabel = new JLabel("<html><p><font color=red>Load at least one ontology.");
            this.messageLabel.setBackground(UIManager.getColor("Tree.selectionBackground"));
            this.mainPanel.add((Component)this.messageLabel, "North");
        } else {
            this.selectedSet = "";
            object4 = new ArrayList();
            object4.add("");
            object4.addAll(this.document.getAnnotationSetNames());
            Collections.sort(object4);
            object = object4.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (!this.setColorTreeNodesWhenInstancesFound(string)) continue;
                this.selectedSet = string;
                break;
            }
            this.setComboBox.setModel(new DefaultComboBoxModel(new Vector(object4)));
            this.setComboBox.setSelectedItem(this.selectedSet);
            this.updateClassTree();
        }
    }

    protected void initListeners() {
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (treeSelectionEvent.getNewLeadSelectionPath() == null) {
                    OntologyClassView.this.selectedClass = null;
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getNewLeadSelectionPath().getLastPathComponent();
                    OntologyClassView.this.selectedClass = (OClass)((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource();
                }
                OntologyClassView.this.instanceView.updateInstanceTable(OntologyClassView.this.selectedClass);
            }
        });
        this.setComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                OntologyClassView.this.selectedSet = (String)OntologyClassView.this.setComboBox.getSelectedItem();
                OntologyClassView.this.classHighlightsDataMap.clear();
                OntologyClassView.this.selectedClasses.clear();
                OntologyClassView.this.setColorTreeNodesWhenInstancesFound(OntologyClassView.this.selectedSet);
                OntologyClassView.this.updateClassTree();
            }
        });
        this.mouseStoppedMovingAction = new MouseStoppedMovingAction();
        this.mouseMovementTimer = new Timer(500, this.mouseStoppedMovingAction);
        this.mouseMovementTimer.setRepeats(false);
        this.textMouseListener = new TextMouseListener();
    }

    @Override
    protected void registerHooks() {
        this.textArea.addMouseListener(this.textMouseListener);
        this.textArea.addMouseMotionListener(this.textMouseListener);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (OClass oClass : new HashSet<OClass>(OntologyClassView.this.selectedClasses)) {
                    if (!OntologyClassView.this.classHighlightsDataMap.containsKey(oClass)) continue;
                    OntologyClassView.this.textView.addHighlights(OntologyClassView.this.classHighlightsDataMap.get(oClass));
                }
            }
        });
    }

    @Override
    protected void unregisterHooks() {
        this.textArea.removeMouseListener(this.textMouseListener);
        this.textArea.removeMouseMotionListener(this.textMouseListener);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (OClass oClass : OntologyClassView.this.selectedClasses) {
                    if (!OntologyClassView.this.classHighlightsDataMap.containsKey(oClass)) continue;
                    OntologyClassView.this.textView.removeHighlights(OntologyClassView.this.classHighlightsDataMap.get(oClass));
                }
            }
        });
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.document = null;
    }

    @Override
    public Component getGUI() {
        return this.mainPanel;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void resourceLoaded(CreoleEvent creoleEvent) {
        if (creoleEvent.getResource() instanceof Ontology) {
            this.mainPanel.remove(this.messageLabel);
            this.selectedOntology = (Ontology)creoleEvent.getResource();
            this.selectedSet = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("");
            arrayList.addAll(this.document.getAnnotationSetNames());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                if (!this.setColorTreeNodesWhenInstancesFound(string)) continue;
                this.selectedSet = string;
                break;
            }
            this.setComboBox.setModel(new DefaultComboBoxModel(new Vector(arrayList)));
            this.setComboBox.setSelectedItem(this.selectedSet);
            this.updateClassTree();
        }
    }

    @Override
    public void resourceUnloaded(CreoleEvent creoleEvent) {
    }

    @Override
    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    @Override
    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    @Override
    public void datastoreClosed(CreoleEvent creoleEvent) {
    }

    @Override
    public void resourceRenamed(Resource resource, String string, String string2) {
    }

    protected boolean setColorTreeNodesWhenInstancesFound(String string) {
        boolean bl = false;
        for (Annotation annotation : this.document.getAnnotations(string).get("Mention")) {
            OClass oClass;
            if (!annotation.getFeatures().containsKey("ontology") || !annotation.getFeatures().containsKey("class") || !annotation.getFeatures().containsKey("inst") || (oClass = this.selectedOntology.getOClass(this.selectedOntology.createOURI((String)annotation.getFeatures().get("class")))) == null) continue;
            this.classColorMap.put(oClass, AnnotationSetsView.getColor(string, oClass.getName()));
            bl = true;
        }
        return bl;
    }

    protected void updateClassTree() {
        this.rootNode.removeAllChildren();
        ArrayList<OResource> arrayList = new ArrayList<OResource>(this.selectedOntology.getOClasses(true));
        Collections.sort(arrayList, this.itemComparator);
        this.addChildrenRec(this.rootNode, arrayList, this.itemComparator);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OntologyClassView.this.treeModel.nodeStructureChanged(OntologyClassView.this.rootNode);
                OntologyClassView.this.tree.expandPath(new TreePath(OntologyClassView.this.rootNode));
                for (int i = 0; i < OntologyClassView.this.tree.getRowCount(); ++i) {
                    OntologyClassView.this.tree.expandRow(i);
                }
            }
        });
    }

    protected void addChildrenRec(DefaultMutableTreeNode defaultMutableTreeNode, List<OResource> list, Comparator<OResource> comparator) {
        for (OResource oResource : list) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new OResourceNode(oResource));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (oResource instanceof OClass) {
                defaultMutableTreeNode2.setAllowsChildren(true);
                OClass oClass = (OClass)oResource;
                ArrayList<OResource> arrayList = new ArrayList<OResource>(oClass.getSubClasses(OConstants.Closure.DIRECT_CLOSURE));
                Collections.sort(arrayList, comparator);
                this.addChildrenRec(defaultMutableTreeNode2, arrayList, comparator);
            } else if (oResource instanceof OInstance) {
                defaultMutableTreeNode2.setAllowsChildren(false);
            }
            this.tree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
        }
    }

    public void setClassSelected(final OClass oClass, boolean bl) {
        if (bl) {
            final ArrayList<AnnotationDataImpl> arrayList = new ArrayList<AnnotationDataImpl>();
            AnnotationSet annotationSet = this.document.getAnnotations(this.selectedSet);
            for (Annotation annotation : annotationSet.get("Mention")) {
                if (!annotation.getFeatures().containsKey("ontology") || !annotation.getFeatures().get("ontology").equals(this.selectedOntology.getOntologyURI()) || !annotation.getFeatures().containsKey("class") || !annotation.getFeatures().get("class").equals(((Object)this.selectedClass.getONodeID()).toString()) || !annotation.getFeatures().containsKey("inst")) continue;
                arrayList.add(new AnnotationDataImpl(annotationSet, annotation));
            }
            this.selectedClasses.add(oClass);
            if (arrayList.isEmpty()) {
                this.classColorMap.remove(oClass);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (OntologyClassView.this.classHighlightsDataMap.containsKey(oClass)) {
                            OntologyClassView.this.textView.removeHighlights(OntologyClassView.this.classHighlightsDataMap.get(oClass));
                        }
                        OntologyClassView.this.classHighlightsDataMap.remove(oClass);
                        OntologyClassView.this.tree.repaint();
                    }
                });
            } else {
                Object object;
                if (this.classColorMap.containsKey(oClass)) {
                    object = this.classColorMap.get(oClass);
                } else {
                    object = AnnotationSetsView.getColor(this.selectedSet, oClass.getName());
                    this.classColorMap.put(oClass, (Color)object);
                }
                SwingUtilities.invokeLater(new Runnable((Color)object){
                    final /* synthetic */ Color val$color;
                    {
                        this.val$color = color;
                    }

                    public void run() {
                        OntologyClassView.this.classHighlightsDataMap.put(oClass, OntologyClassView.this.textView.addHighlights(arrayList, this.val$color));
                        OntologyClassView.this.tree.repaint();
                    }
                });
            }
        } else {
            this.selectedClasses.remove(oClass);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (OntologyClassView.this.classHighlightsDataMap.containsKey(oClass)) {
                        OntologyClassView.this.textView.removeHighlights(OntologyClassView.this.classHighlightsDataMap.get(oClass));
                    }
                    OntologyClassView.this.tree.repaint();
                }
            });
        }
    }

    public void selectInstance(AnnotationSet annotationSet, Annotation annotation, final OClass oClass) {
        Color color;
        final AnnotationDataImpl annotationDataImpl = new AnnotationDataImpl(annotationSet, annotation);
        final ArrayList arrayList = this.classHighlightsDataMap.containsKey(oClass) ? this.classHighlightsDataMap.get(oClass) : new ArrayList();
        this.selectedClasses.add(oClass);
        if (this.classColorMap.containsKey(oClass)) {
            color = this.classColorMap.get(oClass);
        } else {
            color = AnnotationSetsView.getColor(annotationSet.getName(), oClass.getName());
            this.classColorMap.put(oClass, color);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                arrayList.add(OntologyClassView.this.textView.addHighlight(annotationDataImpl, color));
                OntologyClassView.this.classHighlightsDataMap.put(oClass, arrayList);
                OntologyClassView.this.tree.repaint();
            }
        });
    }

    public String getSelectedSet() {
        return this.selectedSet;
    }

    protected class ClassTreeCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        ClassTreeCellRenderer renderer;
        JTree tree;

        public ClassTreeCellEditor(JTree jTree) {
            this.renderer = new ClassTreeCellRenderer();
            this.tree = jTree;
        }

        public Object getCellEditorValue() {
            boolean bl = this.renderer.getCheckBox().isSelected();
            Object object = this.renderer.getUserObject();
            OClass oClass = (OClass)((OResourceNode)object).getResource();
            OntologyClassView.this.setClassSelected(oClass, bl);
            return object;
        }

        public boolean isCellEditable(EventObject eventObject) {
            Object object;
            MouseEvent mouseEvent;
            TreePath treePath;
            boolean bl = false;
            if (eventObject instanceof MouseEvent && (treePath = this.tree.getPathForLocation((mouseEvent = (MouseEvent)eventObject).getX(), mouseEvent.getY())) != null && (object = treePath.getLastPathComponent()) != null && object instanceof DefaultMutableTreeNode) {
                Rectangle rectangle = this.tree.getPathBounds(treePath);
                int n = mouseEvent.getX() - rectangle.x;
                JCheckBox jCheckBox = this.renderer.getCheckBox();
                bl = n > 0 && n < jCheckBox.getPreferredSize().width;
            }
            return bl;
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            Component component = this.renderer.getTreeCellRendererComponent(jTree, object, true, bl2, bl3, n, true);
            this.renderer.getCheckBox().addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    ClassTreeCellEditor.this.stopCellEditing();
                }
            });
            return component;
        }
    }

    protected class ClassTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected Object userObject;
        protected JCheckBox checkBox;
        protected JLabel label;
        private Color selectionColor = UIManager.getColor("Tree.selectionBackground");
        private Color backgroundColor = UIManager.getColor("Tree.textBackground");
        private Border normalBorder = BorderFactory.createLineBorder(this.backgroundColor, 1);
        private Border selectionBorder = BorderFactory.createLineBorder(this.selectionColor, 1);

        protected Object getUserObject() {
            return this.userObject;
        }

        protected JCheckBox getCheckBox() {
            return this.checkBox;
        }

        public ClassTreeCellRenderer() {
            this.setLayout(new FlowLayout(0, 2, 0));
            this.setBorder(this.normalBorder);
            this.setOpaque(true);
            this.setBackground(this.backgroundColor);
            this.checkBox = new JCheckBox();
            this.checkBox.setMargin(new Insets(0, 0, 0, 0));
            this.checkBox.setOpaque(true);
            this.checkBox.setBackground(this.backgroundColor);
            this.add(this.checkBox);
            this.label = new JLabel();
            this.label.setOpaque(true);
            this.label.setBackground(this.backgroundColor);
            this.add(this.label);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            this.userObject = defaultMutableTreeNode.getUserObject();
            if (defaultMutableTreeNode.getUserObject() == null) {
                return this;
            }
            OClass oClass = (OClass)((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource();
            this.checkBox.setSelected(OntologyClassView.this.selectedClasses.contains(oClass));
            this.checkBox.setBackground(bl ? this.selectionColor : this.backgroundColor);
            this.label.setText(oClass.getName());
            this.label.setBackground(OntologyClassView.this.classColorMap.containsKey(oClass) ? OntologyClassView.this.classColorMap.get(oClass) : (bl ? this.selectionColor : this.backgroundColor));
            this.setBackground(bl ? this.selectionColor : this.backgroundColor);
            this.setBorder(bl ? this.selectionBorder : this.normalBorder);
            return this;
        }
    }

    protected class MouseStoppedMovingAction
    extends AbstractAction {
        int textLocation;

        protected MouseStoppedMovingAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = OntologyClassView.this.textArea.getSelectionStart();
            int n2 = OntologyClassView.this.textArea.getSelectionEnd();
            String string = OntologyClassView.this.textArea.getSelectedText();
            if (this.textLocation == -1 || OntologyClassView.this.selectedClass == null || string == null || n > this.textLocation || n2 < this.textLocation || n == n2) {
                return;
            }
            OntologyClassView.this.textArea.setSelectionStart(n);
            OntologyClassView.this.textArea.setSelectionEnd(n);
            OntologyClassView.this.instanceView.addSelectionToFilter(OntologyClassView.this.selectedSet, string, n, n2);
        }

        public void setTextLocation(int n) {
            this.textLocation = n;
        }
    }

    protected class TextMouseListener
    extends MouseInputAdapter {
        protected TextMouseListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            OntologyClassView.this.mouseMovementTimer.stop();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiersEx();
            if ((n & 0x80) != 0) {
                OntologyClassView.this.mouseMovementTimer.stop();
                return;
            }
            if ((n & 0x400) != 0) {
                OntologyClassView.this.mouseMovementTimer.stop();
                return;
            }
            int n2 = OntologyClassView.this.textArea.viewToModel(mouseEvent.getPoint());
            try {
                block7: {
                    try {
                        Rectangle rectangle = OntologyClassView.this.textArea.modelToView(n2);
                        int n3 = 10;
                        rectangle = new Rectangle(rectangle.x - n3, rectangle.y - n3, rectangle.width + 2 * n3, rectangle.height + 2 * n3);
                        if (rectangle.contains(mouseEvent.getPoint())) {
                            OntologyClassView.this.mouseStoppedMovingAction.setTextLocation(n2);
                            break block7;
                        }
                        OntologyClassView.this.mouseStoppedMovingAction.setTextLocation(-1);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new LuckyException(badLocationException);
                    }
                }
                Object var7_7 = null;
                OntologyClassView.this.mouseMovementTimer.restart();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OntologyClassView.this.mouseMovementTimer.restart();
                throw throwable;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            OntologyClassView.this.mouseMovementTimer.stop();
        }
    }
}

