/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.AnnotationVisualResource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.AnnotationEvent;
import gate.event.AnnotationListener;
import gate.gui.annedit.AnnotationData;
import gate.gui.annedit.AnnotationDataImpl;
import gate.gui.annedit.AnnotationEditorOwner;
import gate.gui.annedit.OwnedAnnotationEditor;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.AnnotationList;
import gate.gui.docview.DocumentView;
import gate.gui.docview.TextualDocumentView;
import gate.swing.XJTable;
import gate.util.Err;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationListView
extends AbstractDocumentView
implements AnnotationListener,
AnnotationList,
AnnotationEditorOwner {
    protected XJTable table;
    protected AnnotationTableModel tableModel;
    protected JScrollPane scroller;
    protected List<AnnotationData> annDataList = new ArrayList<AnnotationData>();
    protected volatile boolean localSelectionUpdating = false;
    protected JPanel mainPanel;
    protected JLabel statusLabel;
    protected JTextField filterTextField;
    protected TextualDocumentView textView;
    protected Map<String, AnnotationVisualResource> editorsCache = new HashMap<String, AnnotationVisualResource>();
    private static final int TYPE_COL = 0;
    private static final int SET_COL = 1;
    private static final int START_COL = 2;
    private static final int END_COL = 3;
    private static final int ID_COL = 4;
    private static final int FEATURES_COL = 5;

    @Override
    public AnnotationData getAnnotationAtRow(int n) {
        return this.annDataList == null ? null : this.annDataList.get(this.table.rowViewToModel(n));
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.table == null ? null : this.table.getSelectionModel();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        for (AnnotationData annotationData : this.annDataList) {
            annotationData.getAnnotation().removeAnnotationListener(this);
        }
        this.annDataList.clear();
        this.textView = null;
    }

    @Override
    protected void initGUI() {
        this.tableModel = new AnnotationTableModel();
        this.table = new XJTable(this.tableModel);
        this.table.setAutoResizeMode(3);
        this.table.setSortable(true);
        this.table.setSortedColumn(2);
        this.table.setIntercellSpacing(new Dimension(2, 0));
        this.table.setEnableHidingColumns(true);
        this.scroller = new JScrollPane(this.table);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)this.scroller, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.statusLabel = new JLabel();
        this.mainPanel.add((Component)this.statusLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add(Box.createHorizontalStrut(10), gridBagConstraints);
        this.mainPanel.add((Component)new JLabel("Select: "), gridBagConstraints);
        this.filterTextField = new JTextField(20);
        this.filterTextField.setToolTipText("Select the rows containing this text.");
        this.mainPanel.add((Component)this.filterTextField, gridBagConstraints);
        Iterator<DocumentView> iterator = this.owner.getCentralViews().iterator();
        while (this.textView == null && iterator.hasNext()) {
            DocumentView documentView = iterator.next();
            if (!(documentView instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)documentView;
        }
        this.initListeners();
    }

    @Override
    public Component getGUI() {
        return this.mainPanel;
    }

    protected void initListeners() {
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                AnnotationListView.this.statusLabel.setText(Integer.toString(AnnotationListView.this.tableModel.getRowCount()) + " Annotations (" + Integer.toString(AnnotationListView.this.table.getSelectedRowCount()) + " selected)");
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                int n2;
                if (!AnnotationListView.this.isActive()) {
                    return;
                }
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                AnnotationListView.this.statusLabel.setText(Integer.toString(AnnotationListView.this.tableModel.getRowCount()) + " Annotations (" + Integer.toString(AnnotationListView.this.table.getSelectedRowCount()) + " selected)");
                if (AnnotationListView.this.localSelectionUpdating) {
                    return;
                }
                int[] nArray = AnnotationListView.this.table.getSelectedRows();
                ArrayList<AnnotationData> arrayList = new ArrayList<AnnotationData>();
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    n = AnnotationListView.this.table.rowViewToModel(nArray[n2]);
                    if (n < 0) continue;
                    arrayList.add(AnnotationListView.this.annDataList.get(n));
                }
                AnnotationListView.this.owner.setSelectedAnnotations(arrayList);
                if (AnnotationListView.this.table.getSelectedRowCount() >= 1) {
                    AnnotationData annotationData;
                    n2 = AnnotationListView.this.table.getSelectionModel().getLeadSelectionIndex();
                    if (AnnotationListView.this.table.getSelectionModel().isSelectedIndex(n2) && (annotationData = AnnotationListView.this.annDataList.get(n = AnnotationListView.this.table.rowViewToModel(n2))) != null && annotationData.getAnnotation() != null) {
                        AnnotationListView.this.textView.scrollAnnotationToVisible(annotationData.getAnnotation());
                    }
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                int n = AnnotationListView.this.table.rowAtPoint(mouseEvent.getPoint());
                if (mouseEvent.isPopupTrigger() && !AnnotationListView.this.table.isRowSelected(n)) {
                    AnnotationListView.this.table.getSelectionModel().setSelectionInterval(n, n);
                }
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                int n;
                int n2 = AnnotationListView.this.table.rowAtPoint(mouseEvent.getPoint());
                int n3 = n = n2 == -1 ? n2 : AnnotationListView.this.table.rowViewToModel(n2);
                if (mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    jPopupMenu.add(new DeleteAction());
                    if (n != -1) {
                        AnnotationData annotationData = AnnotationListView.this.annDataList.get(n);
                        jPopupMenu.addSeparator();
                        List<Action> list = AnnotationListView.this.getSpecificEditorActions(annotationData.getAnnotationSet(), annotationData.getAnnotation());
                        for (Action action : list) {
                            jPopupMenu.add(action);
                        }
                        if (!(jPopupMenu.getComponent(jPopupMenu.getComponentCount() - 1) instanceof JSeparator)) {
                            jPopupMenu.addSeparator();
                        }
                        for (Action action : AnnotationListView.this.getGenericEditorActions(annotationData.getAnnotationSet(), annotationData.getAnnotation())) {
                            if (list.contains(action)) continue;
                            jPopupMenu.add(action);
                        }
                        if (jPopupMenu.getComponent(jPopupMenu.getComponentCount() - 1) instanceof JSeparator) {
                            jPopupMenu.remove(jPopupMenu.getComponentCount() - 1);
                        }
                    }
                    jPopupMenu.show(AnnotationListView.this.table, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.table.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                AnnotationListView.this.tableModel.fireTableDataChanged();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){
            private Timer timer = new Timer("Annotation list selection timer", true);
            private TimerTask timerTask;

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            private void update() {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                }
                Date date = new Date(System.currentTimeMillis() + 1000L);
                this.timerTask = new TimerTask(){

                    public void run() {
                        this.selectRows();
                    }
                };
                this.timer.schedule(this.timerTask, date);
            }

            private void selectRows() {
                AnnotationListView.this.table.clearSelection();
                if (AnnotationListView.this.filterTextField.getText().trim().length() < 2 || AnnotationListView.this.table.getRowCount() == 0) {
                    return;
                }
                AnnotationListView.this.localSelectionUpdating = true;
                block0: for (int i = 0; i < AnnotationListView.this.table.getRowCount(); ++i) {
                    for (int j = 0; j < AnnotationListView.this.table.getColumnCount(); ++j) {
                        if (AnnotationListView.this.table.getValueAt(i, j) == null || !AnnotationListView.this.table.getValueAt(i, j).toString().contains(AnnotationListView.this.filterTextField.getText().trim())) continue;
                        AnnotationListView.this.table.addRowSelectionInterval(i, i);
                        continue block0;
                    }
                }
                AnnotationListView.this.localSelectionUpdating = false;
                if (AnnotationListView.this.table.isCellSelected(0, 0)) {
                    AnnotationListView.this.table.addRowSelectionInterval(0, 0);
                } else {
                    AnnotationListView.this.table.removeRowSelectionInterval(0, 0);
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    new DeleteAction().actionPerformed(null);
                }
            }
        });
    }

    public List<Action> getSpecificEditorActions(AnnotationSet annotationSet, Annotation annotation) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        List<String> list = Gate.getCreoleRegister().getAnnotationVRs(annotation.getType());
        if (list != null && list.size() > 0) {
            for (String string : list) {
                AnnotationVisualResource annotationVisualResource = this.editorsCache.get(string);
                if (annotationVisualResource == null) {
                    try {
                        annotationVisualResource = (AnnotationVisualResource)Factory.createResource(string);
                        this.editorsCache.put(string, annotationVisualResource);
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                    }
                }
                arrayList.add(new EditAnnotationAction(annotationSet, annotation, annotationVisualResource));
            }
        }
        return arrayList;
    }

    public List<Action> getGenericEditorActions(AnnotationSet annotationSet, Annotation annotation) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        List<String> list = Gate.getCreoleRegister().getAnnotationVRs();
        if (list != null && list.size() > 0) {
            for (String string : list) {
                AnnotationVisualResource annotationVisualResource = this.editorsCache.get(string);
                if (annotationVisualResource == null) {
                    try {
                        ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(string);
                        Class<? extends Resource> clazz = resourceData.getResourceClass();
                        if (OwnedAnnotationEditor.class.isAssignableFrom(clazz)) {
                            OwnedAnnotationEditor ownedAnnotationEditor = (OwnedAnnotationEditor)clazz.newInstance();
                            ownedAnnotationEditor.setOwner(this);
                            ownedAnnotationEditor.init();
                            annotationVisualResource = ownedAnnotationEditor;
                        } else {
                            annotationVisualResource = (AnnotationVisualResource)Factory.createResource(string);
                        }
                        this.editorsCache.put(string, annotationVisualResource);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(Err.getPrintWriter());
                    }
                }
                arrayList.add(new EditAnnotationAction(annotationSet, annotation, annotationVisualResource));
            }
        }
        return arrayList;
    }

    @Override
    protected void registerHooks() {
    }

    @Override
    protected void unregisterHooks() {
    }

    @Override
    public int getType() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationDataImpl addAnnotation(Annotation annotation, AnnotationSet annotationSet) {
        AnnotationDataImpl annotationDataImpl = new AnnotationDataImpl(annotationSet, annotation);
        this.annDataList.add(annotationDataImpl);
        int n = this.annDataList.size() - 1;
        try {
            this.localSelectionUpdating = true;
            if (this.tableModel != null) {
                this.tableModel.fireTableRowsInserted(n, n);
            }
            Object var6_5 = null;
            this.localSelectionUpdating = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.localSelectionUpdating = false;
            throw throwable;
        }
        annotationDataImpl.getAnnotation().addAnnotationListener(this);
        return annotationDataImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotation(AnnotationData annotationData) {
        int n = this.annDataList.indexOf(annotationData);
        if (n >= 0) {
            AnnotationData annotationData2 = this.annDataList.get(n);
            List<AnnotationData> list = this.owner.getSelectedAnnotations();
            if (list.remove(annotationData)) {
                this.owner.setSelectedAnnotations(list);
            }
            annotationData2.getAnnotation().removeAnnotationListener(this);
            this.annDataList.remove(n);
            try {
                this.localSelectionUpdating = true;
                if (this.tableModel != null) {
                    this.tableModel.fireTableRowsDeleted(n, n);
                }
                Object var6_5 = null;
                this.localSelectionUpdating = false;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.localSelectionUpdating = false;
                throw throwable;
            }
        }
    }

    public void removeAnnotations(Collection<AnnotationData> collection) {
        if (this.table != null) {
            this.table.getSelectionModel().clearSelection();
        }
        final List<AnnotationData> list = this.owner.getSelectedAnnotations();
        boolean bl = false;
        for (AnnotationData annotationData : collection) {
            this.annDataList.remove(annotationData);
            if (list.remove(annotationData)) {
                bl = true;
            }
            annotationData.getAnnotation().removeAnnotationListener(this);
        }
        if (this.tableModel != null) {
            this.tableModel.fireTableDataChanged();
        }
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AnnotationListView.this.owner.setSelectedAnnotations(list);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AnnotationData> addAnnotations(List<Annotation> list, AnnotationSet annotationSet) {
        ArrayList<AnnotationData> arrayList = new ArrayList<AnnotationData>();
        for (Annotation annotation : list) {
            AnnotationDataImpl annotationDataImpl = new AnnotationDataImpl(annotationSet, annotation);
            arrayList.add(annotationDataImpl);
            this.annDataList.add(annotationDataImpl);
            annotation.addAnnotationListener(this);
        }
        try {
            this.localSelectionUpdating = true;
            if (this.tableModel != null) {
                this.tableModel.fireTableDataChanged();
            }
            Object var8_7 = null;
            this.localSelectionUpdating = false;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.localSelectionUpdating = false;
            throw throwable;
        }
        return arrayList;
    }

    public List<AnnotationData> getAllAnnotations() {
        return this.annDataList;
    }

    @Override
    public void annotationUpdated(AnnotationEvent annotationEvent) {
        int n;
        if (this.table == null) {
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        Annotation annotation = (Annotation)annotationEvent.getSource();
        if (this.tableModel != null) {
            for (n = 0; n < this.annDataList.size(); ++n) {
                AnnotationData annotationData = this.annDataList.get(n);
                if (annotationData.getAnnotation() != annotation) continue;
                this.tableModel.fireTableRowsUpdated(n, n);
            }
        }
        this.table.clearSelection();
        if (nArray != null) {
            for (n = 0; n < nArray.length; ++n) {
                this.table.addRowSelectionInterval(nArray[n], nArray[n]);
            }
        }
    }

    @Override
    public void setSelectedAnnotations(final List<AnnotationData> list) {
        int[] nArray = this.table.getSelectedRows();
        Object var3_3 = null;
        ArrayList<AnnotationData> arrayList = new ArrayList<AnnotationData>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.table.rowViewToModel(nArray[i]);
            if (n < 0) continue;
            arrayList.add(this.annDataList.get(n));
        }
        if (arrayList.size() == list.size()) {
            arrayList.removeAll(list);
            if (arrayList.isEmpty()) {
                return;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    AnnotationListView.this.localSelectionUpdating = true;
                    AnnotationListView.this.table.getSelectionModel().clearSelection();
                    int n = -1;
                    for (AnnotationData annotationData : list) {
                        int n2 = AnnotationListView.this.annDataList.indexOf(annotationData);
                        if (n2 == -1) continue;
                        int n3 = AnnotationListView.this.table.rowModelToView(n2);
                        AnnotationListView.this.table.getSelectionModel().addSelectionInterval(n3, n3);
                        n = n3;
                    }
                    if (n >= 0) {
                        AnnotationListView.this.table.scrollRectToVisible(AnnotationListView.this.table.getCellRect(n, 0, true));
                    }
                    Object var7_6 = null;
                    AnnotationListView.this.localSelectionUpdating = false;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    AnnotationListView.this.localSelectionUpdating = false;
                    throw throwable;
                }
            }
        });
    }

    public void selectAnnotationForTag(Object object) {
        int n = this.annDataList.indexOf(object);
        this.table.getSelectionModel().clearSelection();
        if (n != -1) {
            int n2 = this.table.rowModelToView(n);
            this.table.getSelectionModel().setSelectionInterval(n2, n2);
            this.table.scrollRectToVisible(this.table.getCellRect(n2, 0, false));
        }
    }

    @Override
    public void annotationChanged(Annotation annotation, AnnotationSet annotationSet, String string) {
    }

    @Override
    public Annotation getNextAnnotation() {
        return null;
    }

    @Override
    public Annotation getPreviousAnnotation() {
        return null;
    }

    @Override
    public JTextComponent getTextComponent() {
        Iterator<DocumentView> iterator = this.owner.getCentralViews().iterator();
        while (this.textView == null && iterator.hasNext()) {
            DocumentView documentView = iterator.next();
            if (!(documentView instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)documentView;
        }
        return (JTextArea)((JScrollPane)this.textView.getGUI()).getViewport().getView();
    }

    @Override
    public void selectAnnotation(AnnotationData annotationData) {
    }

    @Override
    public int getRowForAnnotation(AnnotationData annotationData) {
        return this.annDataList.indexOf(annotationData);
    }

    protected class EditAnnotationAction
    extends AbstractAction {
        String title;
        Annotation ann;
        AnnotationSet set;
        AnnotationVisualResource editor;

        public EditAnnotationAction(AnnotationSet annotationSet, Annotation annotation, AnnotationVisualResource annotationVisualResource) {
            this.set = annotationSet;
            this.ann = annotation;
            this.editor = annotationVisualResource;
            ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(annotationVisualResource.getClass().getName());
            if (resourceData != null) {
                this.title = resourceData.getName();
                this.putValue("Name", "Edit with " + this.title);
                this.putValue("ShortDescription", resourceData.getComment());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.editor instanceof OwnedAnnotationEditor) {
                ((OwnedAnnotationEditor)this.editor).setPinnedMode(false);
                ((OwnedAnnotationEditor)this.editor).placeDialog(this.ann.getStartNode().getOffset().intValue(), this.ann.getEndNode().getOffset().intValue());
                ((OwnedAnnotationEditor)this.editor).setPinnedMode(true);
                this.editor.editAnnotation(this.ann, this.set);
            } else {
                this.editor.editAnnotation(this.ann, this.set);
                JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.editor));
                JOptionPane jOptionPane = new JOptionPane(jScrollPane, 3, 2, null, new String[]{"OK", "Cancel"});
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                jScrollPane.setMaximumSize(new Dimension((int)((double)dimension.width * 0.75), (int)((double)dimension.height * 0.75)));
                JDialog jDialog = jOptionPane.createDialog(AnnotationListView.this.getGUI(), this.title);
                jDialog.setModal(true);
                jDialog.setResizable(true);
                jDialog.setVisible(true);
                try {
                    if (jOptionPane.getValue().equals("OK")) {
                        this.editor.okAction();
                    } else {
                        this.editor.cancelAction();
                    }
                }
                catch (GateException gateException) {
                    throw new GateRuntimeException(gateException);
                }
            }
        }
    }

    class AnnotationTableModel
    extends AbstractTableModel {
        AnnotationTableModel() {
        }

        public int getRowCount() {
            return AnnotationListView.this.annDataList.size();
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Type";
                }
                case 1: {
                    return "Set";
                }
                case 2: {
                    return "Start";
                }
                case 3: {
                    return "End";
                }
                case 4: {
                    return "Id";
                }
                case 5: {
                    return "Features";
                }
            }
            return "?";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Long.class;
                }
                case 3: {
                    return Long.class;
                }
                case 4: {
                    return Integer.class;
                }
                case 5: {
                    return String.class;
                }
            }
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            if (n >= AnnotationListView.this.annDataList.size()) {
                return null;
            }
            AnnotationData annotationData = AnnotationListView.this.annDataList.get(n);
            switch (n2) {
                case 0: {
                    return annotationData.getAnnotation().getType();
                }
                case 1: {
                    return annotationData.getAnnotationSet().getName();
                }
                case 2: {
                    return annotationData.getAnnotation().getStartNode().getOffset();
                }
                case 3: {
                    return annotationData.getAnnotation().getEndNode().getOffset();
                }
                case 4: {
                    return annotationData.getAnnotation().getId();
                }
                case 5: {
                    FeatureMap featureMap = annotationData.getAnnotation().getFeatures();
                    ArrayList arrayList = new ArrayList(featureMap.keySet());
                    Collections.sort(arrayList);
                    StringBuffer stringBuffer = new StringBuffer("{");
                    Iterator iterator = arrayList.iterator();
                    boolean bl = true;
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        Object v = featureMap.get(e);
                        if (bl) {
                            bl = false;
                        } else {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(e.toString());
                        stringBuffer.append("=");
                        stringBuffer.append(v == null ? "[null]" : v.toString());
                    }
                    stringBuffer.append("}");
                    return stringBuffer.toString();
                }
            }
            return "?";
        }
    }

    protected class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super("Delete");
            this.putValue("ShortDescription", "Delete selected annotations");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ArrayList<AnnotationData> arrayList = new ArrayList<AnnotationData>();
            for (int n : AnnotationListView.this.table.getSelectedRows()) {
                arrayList.add(AnnotationListView.this.annDataList.get(AnnotationListView.this.table.rowViewToModel(n)));
            }
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                AnnotationData annotationData = (AnnotationData)object.next();
                annotationData.getAnnotationSet().remove(annotationData.getAnnotation());
            }
        }
    }
}

