/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.annedit;

import gate.Annotation;
import gate.Factory;
import gate.FeatureMap;
import gate.event.AnnotationSetListener;
import gate.gui.MainFrame;
import gate.gui.annedit.AnnotationDataImpl;
import gate.gui.annedit.AnnotationEditorOwner;
import gate.gui.annedit.OwnedAnnotationEditor;
import gate.gui.annedit.SearchExpressionsAction;
import gate.util.InvalidOffsetException;
import gate.util.LuckyException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Highlighter;

public class SearchAndAnnotatePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private OwnedAnnotationEditor annotationEditor;
    private Window annotationEditorWindow;
    protected AnnotationSetListener annotationSetListener;
    protected Box searchBox;
    protected JPanel searchPane;
    protected JTextField searchTextField;
    protected JCheckBox searchRegExpChk;
    protected JButton helpRegExpButton;
    protected JCheckBox searchCaseSensChk;
    protected JCheckBox searchWholeWordsChk;
    protected JCheckBox searchHighlightsChk;
    protected JCheckBox searchEnabledCheck;
    protected Matcher matcher;
    protected FindFirstAction findFirstAction;
    protected FindPreviousAction findPreviousAction;
    protected FindNextAction findNextAction;
    protected AnnotateMatchAction annotateMatchAction;
    protected AnnotateAllMatchesAction annotateAllMatchesAction;
    protected UndoAnnotateAllMatchesAction undoAnnotateAllMatchesAction;
    protected int nextMatchStartsFrom;
    protected String content;
    protected LinkedList<Vector<Integer>> matchedIndexes;
    protected LinkedList<Annotation> annotateAllAnnotationsID;
    protected SmallButton firstSmallButton;
    protected SmallButton annotateAllMatchesSmallButton;

    public SearchAndAnnotatePanel(Color color, OwnedAnnotationEditor ownedAnnotationEditor, Window window) {
        this.annotationEditor = ownedAnnotationEditor;
        this.annotationEditorWindow = window;
        this.initGui(color);
        this.searchBox.remove(this.searchPane);
        this.searchCaseSensChk.setVisible(false);
        this.searchRegExpChk.setVisible(false);
        this.searchWholeWordsChk.setVisible(false);
        this.searchHighlightsChk.setVisible(false);
        this.getOwner().getTextComponent().requestFocusInWindow();
        this.initListeners();
        this.content = this.getOwner().getDocument().getContent().toString();
    }

    protected void initGui(Color color) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(color);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.searchBox = Box.createVerticalBox();
        String string = "Open Search & Annotate tool";
        JLabel jLabel = new JLabel(string);
        this.searchBox.setMinimumSize(new Dimension(jLabel.getPreferredSize().width, 0));
        this.searchBox.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBackground(color);
        Box box = Box.createHorizontalBox();
        this.searchEnabledCheck = new JCheckBox(string, MainFrame.getIcon("closed"), false);
        this.searchEnabledCheck.setSelectedIcon(MainFrame.getIcon("expanded"));
        this.searchEnabledCheck.setBackground(color);
        this.searchEnabledCheck.setToolTipText("<html>Allows to search for an expression and<br>annotate one or all the matches.</html>");
        box.add(this.searchEnabledCheck);
        box.add(Box.createHorizontalStrut(5));
        this.searchCaseSensChk = new JCheckBox("Case", true);
        this.searchCaseSensChk.setToolTipText("Case sensitive search.");
        this.searchCaseSensChk.setBackground(color);
        box.add(this.searchCaseSensChk);
        box.add(Box.createHorizontalStrut(5));
        this.searchRegExpChk = new JCheckBox("Regexp", false);
        this.searchRegExpChk.setToolTipText("Regular expression search.");
        this.searchRegExpChk.setBackground(color);
        box.add(this.searchRegExpChk);
        box.add(Box.createHorizontalStrut(5));
        this.searchWholeWordsChk = new JCheckBox("Whole", false);
        this.searchWholeWordsChk.setBackground(color);
        this.searchWholeWordsChk.setToolTipText("Whole word search.");
        box.add(this.searchWholeWordsChk);
        box.add(Box.createHorizontalStrut(5));
        this.searchHighlightsChk = new JCheckBox("Highlights", false);
        this.searchHighlightsChk.setToolTipText("Restrict the search on the highlighted annotations.");
        this.searchHighlightsChk.setBackground(color);
        box.add(this.searchHighlightsChk);
        box.add(Box.createHorizontalGlue());
        jPanel2.add(box);
        this.searchBox.add(jPanel2);
        this.searchPane = new JPanel();
        this.searchPane.setAlignmentX(0.0f);
        this.searchPane.setAlignmentY(0.0f);
        this.searchPane.setLayout(new BoxLayout(this.searchPane, 1));
        this.searchPane.setBackground(color);
        box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(3, 0, 5, 0));
        box.add(Box.createHorizontalStrut(5));
        this.searchTextField = new JTextField(10);
        this.searchTextField.setToolTipText("Enter an expression to search for.");
        this.searchTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.searchTextField.getPreferredSize().height));
        this.searchTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchAndAnnotatePanel.this.findFirstAction.actionPerformed(null);
            }
        });
        box.add(this.searchTextField);
        box.add(Box.createHorizontalStrut(2));
        this.helpRegExpButton = new JButton("?");
        this.helpRegExpButton.setMargin(new Insets(0, 2, 0, 2));
        this.helpRegExpButton.setToolTipText("GATE search expression builder.");
        this.helpRegExpButton.addActionListener(new SearchExpressionsAction(this.searchTextField, this.annotationEditorWindow, this.searchRegExpChk));
        box.add(this.helpRegExpButton);
        box.add(Box.createHorizontalGlue());
        this.searchPane.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        this.findFirstAction = new FindFirstAction();
        this.firstSmallButton = new SmallButton(this.findFirstAction);
        box.add(this.firstSmallButton);
        box.add(Box.createHorizontalStrut(5));
        this.findPreviousAction = new FindPreviousAction();
        this.findPreviousAction.setEnabled(false);
        box.add(new SmallButton(this.findPreviousAction));
        box.add(Box.createHorizontalStrut(5));
        this.findNextAction = new FindNextAction();
        this.findNextAction.setEnabled(false);
        box.add(new SmallButton(this.findNextAction));
        box.add(Box.createHorizontalStrut(5));
        this.annotateMatchAction = new AnnotateMatchAction();
        this.annotateMatchAction.setEnabled(false);
        box.add(new SmallButton(this.annotateMatchAction));
        box.add(Box.createHorizontalStrut(5));
        this.annotateAllMatchesAction = new AnnotateAllMatchesAction();
        this.undoAnnotateAllMatchesAction = new UndoAnnotateAllMatchesAction();
        this.annotateAllMatchesSmallButton = new SmallButton(this.annotateAllMatchesAction);
        this.annotateAllMatchesAction.setEnabled(false);
        this.undoAnnotateAllMatchesAction.setEnabled(false);
        box.add(this.annotateAllMatchesSmallButton);
        box.add(Box.createHorizontalStrut(5));
        this.searchPane.add(box);
        this.searchBox.add(this.searchPane);
        jPanel.add(this.searchBox);
    }

    protected void initListeners() {
        this.searchEnabledCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SearchAndAnnotatePanel.this.searchEnabledCheck.isSelected()) {
                    if (!SearchAndAnnotatePanel.this.searchBox.isAncestorOf(SearchAndAnnotatePanel.this.searchPane)) {
                        String string = SearchAndAnnotatePanel.this.searchTextField.getText();
                        if ((string == null || string.trim().length() == 0) && SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited() != null && SearchAndAnnotatePanel.this.getOwner() != null) {
                            String string2 = SearchAndAnnotatePanel.this.getOwner().getDocument().getContent().toString().substring(SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getStartNode().getOffset().intValue(), SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getEndNode().getOffset().intValue());
                            SearchAndAnnotatePanel.this.searchTextField.setText(string2);
                        }
                        SearchAndAnnotatePanel.this.searchBox.add(SearchAndAnnotatePanel.this.searchPane);
                    }
                    SearchAndAnnotatePanel.this.searchEnabledCheck.setText("");
                    SearchAndAnnotatePanel.this.searchCaseSensChk.setVisible(true);
                    SearchAndAnnotatePanel.this.searchRegExpChk.setVisible(true);
                    SearchAndAnnotatePanel.this.searchWholeWordsChk.setVisible(true);
                    SearchAndAnnotatePanel.this.searchHighlightsChk.setVisible(true);
                    SearchAndAnnotatePanel.this.searchTextField.requestFocusInWindow();
                    SearchAndAnnotatePanel.this.searchTextField.selectAll();
                    SearchAndAnnotatePanel.this.annotationEditorWindow.pack();
                    SearchAndAnnotatePanel.this.annotationEditor.setPinnedMode(true);
                } else if (SearchAndAnnotatePanel.this.searchBox.isAncestorOf(SearchAndAnnotatePanel.this.searchPane)) {
                    SearchAndAnnotatePanel.this.searchEnabledCheck.setText("Open Search & Annotate tool");
                    SearchAndAnnotatePanel.this.searchBox.remove(SearchAndAnnotatePanel.this.searchPane);
                    SearchAndAnnotatePanel.this.searchCaseSensChk.setVisible(false);
                    SearchAndAnnotatePanel.this.searchRegExpChk.setVisible(false);
                    SearchAndAnnotatePanel.this.searchWholeWordsChk.setVisible(false);
                    SearchAndAnnotatePanel.this.searchHighlightsChk.setVisible(false);
                    if (SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited() != null) {
                        SearchAndAnnotatePanel.this.annotationEditor.setEditingEnabled(true);
                    }
                    SearchAndAnnotatePanel.this.annotationEditorWindow.pack();
                }
            }
        });
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (SearchAndAnnotatePanel.this.searchTextField.getText().trim().length() == 0 && SearchAndAnnotatePanel.this.getOwner().getTextComponent().getSelectedText() != null) {
                    SearchAndAnnotatePanel.this.searchTextField.setText(SearchAndAnnotatePanel.this.getOwner().getTextComponent().getSelectedText());
                }
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        this.searchTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }
        });
        this.searchCaseSensChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }
        });
        this.searchRegExpChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }
        });
        this.searchWholeWordsChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }
        });
        this.searchHighlightsChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }
        });
    }

    private void enableActions(boolean bl) {
        this.findPreviousAction.setEnabled(bl);
        this.findNextAction.setEnabled(bl);
        this.annotateMatchAction.setEnabled(bl);
        this.annotateAllMatchesAction.setEnabled(bl);
        if (this.annotateAllMatchesSmallButton.getAction().equals(this.undoAnnotateAllMatchesAction)) {
            this.annotateAllMatchesSmallButton.setAction(this.annotateAllMatchesAction);
        }
    }

    private boolean isAnnotationEditorReady() {
        if (!this.annotationEditor.editingFinished() || this.getOwner() == null || this.annotationEditor.getAnnotationCurrentlyEdited() == null || this.annotationEditor.getAnnotationSetCurrentlyEdited() == null) {
            this.annotationEditorWindow.setVisible(false);
            JOptionPane.showMessageDialog(this.annotationEditorWindow, this.annotationEditor.getAnnotationCurrentlyEdited() == null ? "Please select an existing annotation\nor create a new one then select it." : "Please set all required features in the feature table.", "GATE", 1);
            this.annotationEditorWindow.setVisible(true);
            return false;
        }
        return true;
    }

    public AnnotationEditorOwner getOwner() {
        return this.annotationEditor.getOwner();
    }

    protected class SmallButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        public SmallButton(Action action) {
            super(action);
            this.setMargin(new Insets(0, 2, 0, 2));
        }
    }

    protected class UndoAnnotateAllMatchesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public UndoAnnotateAllMatchesAction() {
            super("Undo");
            super.putValue("ShortDescription", "Undo previous annotate all action.");
            super.putValue("MnemonicKey", 85);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (Annotation annotation : SearchAndAnnotatePanel.this.annotateAllAnnotationsID) {
                SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited().remove(annotation);
            }
            if (SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited() == null) {
                SearchAndAnnotatePanel.this.annotationEditor.setEditingEnabled(false);
            }
            SearchAndAnnotatePanel.this.annotateAllMatchesSmallButton.setAction(SearchAndAnnotatePanel.this.annotateAllMatchesAction);
            SearchAndAnnotatePanel.this.annotateAllMatchesAction.setEnabled(false);
        }
    }

    protected class AnnotateAllMatchesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AnnotateAllMatchesAction() {
            super("Ann. all next");
            super.putValue("ShortDescription", "Annotates all the following matches.");
            super.putValue("MnemonicKey", 76);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!SearchAndAnnotatePanel.this.isAnnotationEditorReady()) {
                return;
            }
            SearchAndAnnotatePanel.this.annotateAllAnnotationsID = new LinkedList();
            boolean bl = false;
            int n = -1;
            int n2 = -1;
            SearchAndAnnotatePanel.this.nextMatchStartsFrom = SearchAndAnnotatePanel.this.getOwner().getTextComponent().getCaretPosition();
            do {
                bl = false;
                while (SearchAndAnnotatePanel.this.matcher.find(SearchAndAnnotatePanel.this.nextMatchStartsFrom) && !bl) {
                    n = SearchAndAnnotatePanel.this.matcher.groupCount() > 0 ? SearchAndAnnotatePanel.this.matcher.start(1) : SearchAndAnnotatePanel.this.matcher.start();
                    int n3 = n2 = SearchAndAnnotatePanel.this.matcher.groupCount() > 0 ? SearchAndAnnotatePanel.this.matcher.end(1) : SearchAndAnnotatePanel.this.matcher.end();
                    if (SearchAndAnnotatePanel.this.searchHighlightsChk.isSelected()) {
                        Highlighter.Highlight[] highlightArray;
                        for (Highlighter.Highlight highlight : highlightArray = SearchAndAnnotatePanel.this.getOwner().getTextComponent().getHighlighter().getHighlights()) {
                            if (highlight.getStartOffset() > n || highlight.getEndOffset() < n2) continue;
                            bl = true;
                            break;
                        }
                    } else {
                        bl = true;
                    }
                    SearchAndAnnotatePanel.this.nextMatchStartsFrom = n2;
                }
                if (!bl) continue;
                this.annotateCurrentMatch(n, n2);
            } while (bl && !SearchAndAnnotatePanel.this.matcher.hitEnd());
            SearchAndAnnotatePanel.this.annotateAllMatchesSmallButton.setAction(SearchAndAnnotatePanel.this.undoAnnotateAllMatchesAction);
            SearchAndAnnotatePanel.this.undoAnnotateAllMatchesAction.setEnabled(true);
        }

        private void annotateCurrentMatch(int n, int n2) {
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("safe.regex", "true");
            if (SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getFeatures() != null) {
                featureMap.putAll(SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getFeatures());
            }
            try {
                Integer n3 = SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited().add(new Long(n), new Long(n2), SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getType(), featureMap);
                Annotation annotation = SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited().get(n3);
                SearchAndAnnotatePanel.this.annotateAllAnnotationsID.add(annotation);
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new LuckyException(invalidOffsetException);
            }
        }
    }

    protected class AnnotateMatchAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AnnotateMatchAction() {
            super("Annotate");
            super.putValue("ShortDescription", "Annotates the current match.");
            super.putValue("MnemonicKey", 65);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!SearchAndAnnotatePanel.this.isAnnotationEditorReady()) {
                return;
            }
            int n = SearchAndAnnotatePanel.this.getOwner().getTextComponent().getSelectionStart();
            int n2 = SearchAndAnnotatePanel.this.getOwner().getTextComponent().getSelectionEnd();
            FeatureMap featureMap = Factory.newFeatureMap();
            if (SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getFeatures() != null) {
                featureMap.putAll(SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getFeatures());
            }
            try {
                Integer n3 = SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited().add(new Long(n), new Long(n2), SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getType(), featureMap);
                Annotation annotation = SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited().get(n3);
                SearchAndAnnotatePanel.this.getOwner().getTextComponent().select(n2, n2);
                SearchAndAnnotatePanel.this.getOwner().selectAnnotation(new AnnotationDataImpl(SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited(), annotation));
                SearchAndAnnotatePanel.this.annotationEditor.editAnnotation(annotation, SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited());
                SearchAndAnnotatePanel.this.annotateAllMatchesAction.setEnabled(true);
                if (SearchAndAnnotatePanel.this.annotateAllMatchesSmallButton.getAction().equals(SearchAndAnnotatePanel.this.undoAnnotateAllMatchesAction)) {
                    SearchAndAnnotatePanel.this.annotateAllMatchesSmallButton.setAction(SearchAndAnnotatePanel.this.annotateAllMatchesAction);
                }
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new LuckyException(invalidOffsetException);
            }
        }
    }

    protected class FindNextAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public FindNextAction() {
            super("Next");
            super.putValue("ShortDescription", "Finds the next occurrence.");
            super.putValue("MnemonicKey", 78);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Highlighter.Highlight[] highlightArray;
            if (!SearchAndAnnotatePanel.this.isAnnotationEditorReady()) {
                return;
            }
            SearchAndAnnotatePanel.this.annotationEditor.setEditingEnabled(false);
            boolean bl = false;
            int n = -1;
            int n2 = -1;
            SearchAndAnnotatePanel.this.nextMatchStartsFrom = SearchAndAnnotatePanel.this.getOwner().getTextComponent().getCaretPosition();
            while (SearchAndAnnotatePanel.this.matcher.find(SearchAndAnnotatePanel.this.nextMatchStartsFrom) && !bl) {
                n = SearchAndAnnotatePanel.this.matcher.groupCount() > 0 ? SearchAndAnnotatePanel.this.matcher.start(1) : SearchAndAnnotatePanel.this.matcher.start();
                n2 = SearchAndAnnotatePanel.this.matcher.groupCount() > 0 ? SearchAndAnnotatePanel.this.matcher.end(1) : SearchAndAnnotatePanel.this.matcher.end();
                bl = false;
                if (SearchAndAnnotatePanel.this.searchHighlightsChk.isSelected()) {
                    for (Highlighter.Highlight highlight : highlightArray = SearchAndAnnotatePanel.this.getOwner().getTextComponent().getHighlighter().getHighlights()) {
                        if (highlight.getStartOffset() > n || highlight.getEndOffset() < n2) continue;
                        bl = true;
                        break;
                    }
                } else {
                    bl = true;
                }
                SearchAndAnnotatePanel.this.nextMatchStartsFrom = n2;
            }
            if (bl) {
                highlightArray = new Vector(2);
                highlightArray.add(n);
                highlightArray.add(n2);
                SearchAndAnnotatePanel.this.matchedIndexes.add((Vector<Integer>)highlightArray);
                SearchAndAnnotatePanel.this.getOwner().getTextComponent().select(n, n2);
                SearchAndAnnotatePanel.this.annotationEditor.placeDialog(n, n2);
                SearchAndAnnotatePanel.this.findPreviousAction.setEnabled(true);
            } else {
                SearchAndAnnotatePanel.this.findNextAction.setEnabled(false);
                SearchAndAnnotatePanel.this.annotateMatchAction.setEnabled(false);
            }
        }
    }

    protected class FindPreviousAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public FindPreviousAction() {
            super("Prev.");
            super.putValue("ShortDescription", "Finds the previous occurrence.");
            super.putValue("MnemonicKey", 80);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!SearchAndAnnotatePanel.this.isAnnotationEditorReady()) {
                return;
            }
            SearchAndAnnotatePanel.this.annotationEditor.setEditingEnabled(false);
            SearchAndAnnotatePanel.this.matchedIndexes.removeLast();
            if (SearchAndAnnotatePanel.this.matchedIndexes.size() == 1) {
                SearchAndAnnotatePanel.this.findPreviousAction.setEnabled(false);
            }
            Vector<Integer> vector = SearchAndAnnotatePanel.this.matchedIndexes.getLast();
            int n = vector.firstElement();
            int n2 = vector.lastElement();
            SearchAndAnnotatePanel.this.getOwner().getTextComponent().select(n, n2);
            SearchAndAnnotatePanel.this.annotationEditor.placeDialog(n, n2);
            SearchAndAnnotatePanel.this.nextMatchStartsFrom = n;
            SearchAndAnnotatePanel.this.findNextAction.setEnabled(true);
            SearchAndAnnotatePanel.this.annotateMatchAction.setEnabled(true);
        }
    }

    protected class FindFirstAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public FindFirstAction() {
            super("First");
            super.putValue("ShortDescription", "Finds the first occurrence.");
            super.putValue("MnemonicKey", 70);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Highlighter.Highlight[] highlightArray;
            Pattern pattern;
            if (!SearchAndAnnotatePanel.this.isAnnotationEditorReady()) {
                return;
            }
            SearchAndAnnotatePanel.this.annotationEditor.setPinnedMode(true);
            SearchAndAnnotatePanel.this.annotationEditor.setEditingEnabled(false);
            String string = SearchAndAnnotatePanel.this.searchTextField.getText();
            try {
                String string2 = SearchAndAnnotatePanel.this.searchWholeWordsChk.isSelected() ? "\\b" : "";
                string2 = string2 + (SearchAndAnnotatePanel.this.searchRegExpChk.isSelected() ? "" : "\\Q");
                String string3 = SearchAndAnnotatePanel.this.searchRegExpChk.isSelected() ? "" : "\\E";
                string3 = string3 + (SearchAndAnnotatePanel.this.searchWholeWordsChk.isSelected() ? "\\b" : "");
                string = string2 + string + string3;
                pattern = SearchAndAnnotatePanel.this.searchCaseSensChk.isSelected() ? Pattern.compile(string) : Pattern.compile(string, 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                SearchAndAnnotatePanel.this.annotationEditorWindow.setVisible(false);
                JOptionPane.showMessageDialog(SearchAndAnnotatePanel.this.annotationEditorWindow, "Invalid regular expression.\n\n" + patternSyntaxException.toString().replaceFirst("^.+PatternSyntaxException: ", ""), "GATE", 1);
                SearchAndAnnotatePanel.this.annotationEditorWindow.setVisible(true);
                return;
            }
            SearchAndAnnotatePanel.this.matcher = pattern.matcher(SearchAndAnnotatePanel.this.content);
            boolean bl = false;
            int n = -1;
            int n2 = -1;
            SearchAndAnnotatePanel.this.nextMatchStartsFrom = 0;
            while (SearchAndAnnotatePanel.this.matcher.find(SearchAndAnnotatePanel.this.nextMatchStartsFrom) && !bl) {
                n = SearchAndAnnotatePanel.this.matcher.groupCount() > 0 ? SearchAndAnnotatePanel.this.matcher.start(1) : SearchAndAnnotatePanel.this.matcher.start();
                n2 = SearchAndAnnotatePanel.this.matcher.groupCount() > 0 ? SearchAndAnnotatePanel.this.matcher.end(1) : SearchAndAnnotatePanel.this.matcher.end();
                bl = false;
                if (SearchAndAnnotatePanel.this.searchHighlightsChk.isSelected()) {
                    for (Highlighter.Highlight highlight : highlightArray = SearchAndAnnotatePanel.this.getOwner().getTextComponent().getHighlighter().getHighlights()) {
                        if (highlight.getStartOffset() > n || highlight.getEndOffset() < n2) continue;
                        bl = true;
                        break;
                    }
                } else {
                    bl = true;
                }
                SearchAndAnnotatePanel.this.nextMatchStartsFrom = n2;
            }
            if (bl) {
                SearchAndAnnotatePanel.this.findNextAction.setEnabled(true);
                SearchAndAnnotatePanel.this.annotateMatchAction.setEnabled(true);
                SearchAndAnnotatePanel.this.annotateAllMatchesAction.setEnabled(false);
                SearchAndAnnotatePanel.this.matchedIndexes = new LinkedList();
                highlightArray = new Vector(2);
                highlightArray.add(n);
                highlightArray.add(n2);
                SearchAndAnnotatePanel.this.matchedIndexes.add((Vector<Integer>)highlightArray);
                SearchAndAnnotatePanel.this.getOwner().getTextComponent().select(n, n2);
                SearchAndAnnotatePanel.this.annotationEditor.placeDialog(n, n2);
            } else {
                SearchAndAnnotatePanel.this.findNextAction.setEnabled(false);
                SearchAndAnnotatePanel.this.annotateMatchAction.setEnabled(false);
            }
            SearchAndAnnotatePanel.this.findPreviousAction.setEnabled(false);
        }
    }
}

