/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.Resource;
import gate.creole.ResourceData;
import gate.gui.MainFrame;
import gate.gui.ResourceRenderer;
import gate.util.Err;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListEditorDialog
extends JDialog {
    String itemType;
    Class itemTypeClass;
    JList listComponent;
    JComboBox combo;
    JTextField textField;
    JButton removeBtn;
    JButton addBtn;
    JButton moveUpBtn;
    JButton moveDownBtn;
    DefaultListModel listModel;
    boolean finiteType;
    Action addAction;
    Action removeAction;
    JButton okButton;
    JButton cancelButton;
    boolean userCancelled;
    boolean allowDuplicates;
    Comparator comparator;

    public ListEditorDialog(Component component, Collection collection, String string) {
        this(component, collection, null, string);
    }

    public ListEditorDialog(Component component, Collection collection, Class<? extends Collection> clazz, String string) {
        super(MainFrame.getInstance());
        if (clazz == null) {
            clazz = collection != null ? collection.getClass() : List.class;
        }
        this.itemType = string == null ? "java.lang.String" : string;
        this.setLocationRelativeTo(component);
        this.initLocalData(collection, clazz);
        this.initGuiComponents();
        this.initListeners();
    }

    protected void initLocalData(Collection collection, Class<? extends Collection> clazz) {
        ResourceData resourceData;
        try {
            resourceData = (ResourceData)Gate.getCreoleRegister().get(this.itemType);
            this.itemTypeClass = resourceData == null ? Class.forName(this.itemType, true, Gate.getClassLoader()) : resourceData.getResourceClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GateRuntimeException(classNotFoundException.toString());
        }
        this.finiteType = Gate.isGateType(this.itemType);
        resourceData = (ResourceData)Gate.getCreoleRegister().get(this.itemType);
        String string = null;
        if (List.class.isAssignableFrom(clazz)) {
            string = "List";
            this.allowDuplicates = true;
        } else {
            if (Set.class.isAssignableFrom(clazz)) {
                string = "Set";
                this.allowDuplicates = false;
            } else {
                string = "Collection";
                this.allowDuplicates = true;
            }
            if (SortedSet.class.isAssignableFrom(clazz) && collection != null) {
                this.comparator = ((SortedSet)collection).comparator();
            }
            if (this.comparator == null) {
                this.comparator = new NaturalComparator();
            }
        }
        this.listModel = new DefaultListModel();
        if (collection != null) {
            if (this.comparator == null) {
                for (Object e : collection) {
                    this.listModel.addElement(e);
                }
            } else {
                Object[] objectArray = collection.toArray();
                Arrays.sort(objectArray, this.comparator);
                for (Object object : objectArray) {
                    this.listModel.addElement(object);
                }
            }
        }
        this.setTitle(string + " of " + (resourceData == null ? this.itemType : resourceData.getName()));
        this.addAction = new AddAction();
        this.removeAction = new RemoveAction();
    }

    protected void initGuiComponents() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JComponent jComponent = null;
        if (this.finiteType) {
            this.combo = new JComboBox(new ResourceComboModel());
            jComponent = this.combo;
            this.combo.setRenderer(new ResourceRenderer());
            if (this.combo.getModel().getSize() > 0) {
                this.combo.getModel().setSelectedItem(this.combo.getModel().getElementAt(0));
            }
        } else {
            jComponent = this.textField = new JTextField(20);
        }
        this.getContentPane().add(jComponent);
        this.getContentPane().add(Box.createVerticalStrut(5));
        Box box = Box.createHorizontalBox();
        this.addBtn = new JButton(this.addAction);
        this.removeBtn = new JButton(this.removeAction);
        box.add(Box.createHorizontalGlue());
        box.add(this.addBtn);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.removeBtn);
        box.add(Box.createHorizontalGlue());
        this.getContentPane().add(box);
        this.getContentPane().add(Box.createVerticalStrut(5));
        Box box2 = Box.createHorizontalBox();
        this.listComponent = new JList(this.listModel);
        this.listComponent.setSelectionMode(2);
        this.listComponent.setCellRenderer(new ResourceRenderer());
        box2.add(new JScrollPane(this.listComponent));
        if (this.comparator == null) {
            Box box3 = Box.createVerticalBox();
            box3.add(Box.createVerticalGlue());
            this.moveUpBtn = new JButton(MainFrame.getIcon("up"));
            box3.add(this.moveUpBtn);
            box3.add(Box.createVerticalStrut(5));
            this.moveDownBtn = new JButton(MainFrame.getIcon("down"));
            box3.add(this.moveDownBtn);
            box3.add(Box.createVerticalGlue());
            box2.add(Box.createHorizontalStrut(3));
            box2.add(box3);
        }
        box2.add(Box.createHorizontalStrut(3));
        this.getContentPane().add(box2);
        this.getContentPane().add(Box.createVerticalStrut(5));
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        this.okButton = new JButton("OK");
        box.add(this.okButton);
        box.add(Box.createHorizontalStrut(5));
        this.cancelButton = new JButton("Cancel");
        box.add(this.cancelButton);
        box.add(Box.createHorizontalGlue());
        this.getContentPane().add(box);
    }

    protected void initListeners() {
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListEditorDialog.this.userCancelled = false;
                ListEditorDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListEditorDialog.this.userCancelled = true;
                ListEditorDialog.this.setVisible(false);
            }
        });
        if (this.moveUpBtn != null) {
            this.moveUpBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = ListEditorDialog.this.listComponent.getSelectedIndices();
                    if (nArray == null || nArray.length == 0) {
                        JOptionPane.showMessageDialog(ListEditorDialog.this, "Please select some items to be moved ", "GATE", 0);
                    } else {
                        int n;
                        int n2;
                        Arrays.sort(nArray);
                        for (n2 = 0; n2 < nArray.length; ++n2) {
                            n = nArray[n2];
                            if (n <= 0) continue;
                            Object e = ListEditorDialog.this.listModel.remove(n);
                            ListEditorDialog.this.listModel.add(n - 1, e);
                        }
                        for (n2 = 0; n2 < nArray.length; ++n2) {
                            n = -1;
                            n = nArray[n2] > 0 ? nArray[n2] - 1 : nArray[n2];
                            ListEditorDialog.this.listComponent.addSelectionInterval(n, n);
                        }
                    }
                }
            });
        }
        if (this.moveDownBtn != null) {
            this.moveDownBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = ListEditorDialog.this.listComponent.getSelectedIndices();
                    if (nArray == null || nArray.length == 0) {
                        JOptionPane.showMessageDialog(ListEditorDialog.this, "Please select some items to be moved ", "GATE", 0);
                    } else {
                        int n;
                        int n2;
                        Arrays.sort(nArray);
                        for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                            n = nArray[n2];
                            if (n >= ListEditorDialog.this.listModel.size() - 1) continue;
                            Object e = ListEditorDialog.this.listModel.remove(n);
                            ListEditorDialog.this.listModel.add(n + 1, e);
                        }
                        for (n2 = 0; n2 < nArray.length; ++n2) {
                            n = -1;
                            n = nArray[n2] < ListEditorDialog.this.listModel.size() - 1 ? nArray[n2] + 1 : nArray[n2];
                            ListEditorDialog.this.listComponent.addSelectionInterval(n, n);
                        }
                    }
                }
            });
        }
    }

    public List showDialog() {
        this.pack();
        this.userCancelled = true;
        this.setModal(true);
        super.setVisible(true);
        return this.userCancelled ? null : Arrays.asList(this.listModel.toArray());
    }

    public static void main(String[] stringArray) {
        try {
            Gate.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFrame jFrame = new JFrame("Foo frame");
        ListEditorDialog listEditorDialog = new ListEditorDialog((Component)jFrame, new ArrayList(), "java.lang.Integer");
        jFrame.setSize(300, 300);
        jFrame.setVisible(true);
        System.out.println(listEditorDialog.showDialog());
    }

    protected class NaturalComparator
    implements Comparator {
        protected NaturalComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == null) {
                if (object2 == null) {
                    return 0;
                }
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (Comparable.class.isAssignableFrom(ListEditorDialog.this.itemTypeClass)) {
                return ((Comparable)object).compareTo(object2);
            }
            return object.toString().compareTo(object2.toString());
        }
    }

    protected class ResourceComboModel
    extends AbstractListModel
    implements ComboBoxModel {
        Object selectedItem = null;

        protected ResourceComboModel() {
        }

        public int getSize() {
            List<Resource> list = null;
            try {
                list = Gate.getCreoleRegister().getAllInstances(ListEditorDialog.this.itemType);
            }
            catch (GateException gateException) {
                gateException.printStackTrace(Err.getPrintWriter());
            }
            return list == null ? 0 : list.size();
        }

        public Object getElementAt(int n) {
            List<Resource> list = null;
            try {
                list = Gate.getCreoleRegister().getAllInstances(ListEditorDialog.this.itemType);
            }
            catch (GateException gateException) {
                gateException.printStackTrace(Err.getPrintWriter());
            }
            return list == null ? null : list.get(n);
        }

        public void setSelectedItem(Object object) {
            this.selectedItem = object == null ? null : object;
        }

        public Object getSelectedItem() {
            return this.selectedItem;
        }

        void fireDataChanged() {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    protected class RemoveAction
    extends AbstractAction {
        RemoveAction() {
            super("Remove");
            this.putValue("ShortDescription", "Remove the selected value(s) from the list");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListEditorDialog.this.listComponent.getSelectedIndices();
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                ListEditorDialog.this.listModel.remove(nArray[i]);
            }
        }
    }

    protected class AddAction
    extends AbstractAction {
        AddAction() {
            super("Add");
            this.putValue("ShortDescription", "Add the edited value to the list");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ListEditorDialog.this.finiteType) {
                ListEditorDialog.this.listModel.addElement(ListEditorDialog.this.combo.getSelectedItem());
            } else {
                String string = null;
                String string2 = ListEditorDialog.this.textField.getText();
                if (string2 == null || string2.length() == 0) {
                    string2 = null;
                }
                if (ListEditorDialog.this.itemTypeClass.isAssignableFrom(String.class)) {
                    string = string2;
                } else {
                    try {
                        string = ListEditorDialog.this.itemTypeClass.getConstructor(String.class).newInstance(string2);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(ListEditorDialog.this, "Invalid value!\nIs it the right type?", "GATE", 0);
                        return;
                    }
                }
                if (ListEditorDialog.this.comparator == null) {
                    ListEditorDialog.this.listModel.addElement(string);
                } else {
                    int n;
                    for (n = 0; n < ListEditorDialog.this.listModel.size() && ListEditorDialog.this.comparator.compare(string, ListEditorDialog.this.listModel.get(n)) > 0; ++n) {
                    }
                    if (n == ListEditorDialog.this.listModel.size()) {
                        ListEditorDialog.this.listModel.addElement(string);
                    } else if (ListEditorDialog.this.allowDuplicates || ListEditorDialog.this.comparator.compare(string, ListEditorDialog.this.listModel.get(n)) < 0) {
                        ListEditorDialog.this.listModel.add(n, string);
                    }
                }
                ListEditorDialog.this.textField.setText("");
                ListEditorDialog.this.textField.requestFocus();
            }
        }
    }
}

