/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class CollectionSelectionDialog
extends JDialog {
    DefaultListModel sourceListModel = null;
    DefaultListModel targetListModel = null;
    int buttonPressed = 1;
    JButton removeButton = null;
    JButton addButton = null;
    JList sourceList = null;
    JList targetList = null;
    JButton okButton = null;
    JButton cancelButton = null;
    JLabel sourceLabel = null;
    JLabel targetLabel = null;
    Frame mainFrame = null;

    public CollectionSelectionDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.setLocationRelativeTo(frame);
        this.mainFrame = frame;
    }

    public CollectionSelectionDialog() {
        this((Frame)null, true);
    }

    protected void initLocalData(Collection collection) {
        this.targetListModel = new DefaultListModel();
        this.sourceListModel = new DefaultListModel();
        if (collection == null) {
            return;
        }
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.sourceListModel.addElement(iterator.next());
        }
    }

    protected void initGuiComponents() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.sourceLabel = new JLabel("Source");
        this.sourceLabel.setAlignmentX(0.0f);
        this.sourceList = new JList(this.sourceListModel);
        this.sourceList.setSelectionMode(2);
        this.sourceList.setVisibleRowCount(10);
        this.sourceList.setAlignmentX(0.0f);
        this.targetLabel = new JLabel("Target");
        this.targetLabel.setAlignmentX(0.0f);
        this.targetList = new JList(this.targetListModel);
        this.targetList.setSelectionMode(2);
        this.targetList.setVisibleRowCount(10);
        this.targetList.setAlignmentX(0.0f);
        this.targetList.setPreferredSize(this.sourceList.getPreferredSize());
        this.addButton = new JButton(">>>");
        this.removeButton = new JButton("<<<");
        this.okButton = new JButton("Ok");
        this.cancelButton = new JButton("Cancel");
        Box box = Box.createVerticalBox();
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createRigidArea(new Dimension(10, 0)));
        Box box3 = Box.createVerticalBox();
        box3.add(this.sourceLabel);
        box3.add(new JScrollPane(this.sourceList));
        box2.add(box3);
        box2.add(Box.createRigidArea(new Dimension(10, 0)));
        box3 = Box.createVerticalBox();
        box3.add(this.addButton);
        box3.add(Box.createRigidArea(new Dimension(0, 10)));
        box3.add(this.removeButton);
        box2.add(box3);
        box2.add(Box.createRigidArea(new Dimension(10, 0)));
        box3 = Box.createVerticalBox();
        box3.add(this.targetLabel);
        box3.add(new JScrollPane(this.targetList));
        box2.add(box3);
        box2.add(Box.createRigidArea(new Dimension(20, 0)));
        box3 = Box.createHorizontalBox();
        box3.add(Box.createHorizontalGlue());
        box3.add(this.okButton);
        box3.add(Box.createRigidArea(new Dimension(25, 0)));
        box3.add(this.cancelButton);
        box3.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        box.add(box3);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        this.getContentPane().add(box);
        this.pack();
    }

    protected void initListeners() {
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CollectionSelectionDialog.this.doOk();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CollectionSelectionDialog.this.doCancel();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CollectionSelectionDialog.this.doAdd();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CollectionSelectionDialog.this.doRemove();
            }
        });
    }

    private void doOk() {
        this.buttonPressed = 0;
        this.setVisible(false);
    }

    private void doCancel() {
        this.buttonPressed = 1;
        this.setVisible(false);
    }

    private void doRemove() {
        Object[] objectArray = this.targetList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            this.sourceListModel.addElement(objectArray[i]);
            this.targetListModel.removeElement(objectArray[i]);
        }
    }

    private void doAdd() {
        Object[] objectArray = this.sourceList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            this.targetListModel.addElement(objectArray[i]);
            this.sourceListModel.removeElement(objectArray[i]);
        }
    }

    public Collection getSelectedCollection() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.targetListModel.getSize(); ++i) {
            arrayList.add(this.targetListModel.getElementAt(i));
        }
        return arrayList;
    }

    public int show(String string, Collection collection) {
        if (string == null) {
            JOptionPane.showMessageDialog(this.mainFrame, "Feature selection dialog coud not been created because title was null!", "GATE", 0);
            return this.buttonPressed;
        }
        if (collection == null) {
            JOptionPane.showMessageDialog(this.mainFrame, "Feature selection dialog coud not been created because data source null!", "GATE", 0);
            return this.buttonPressed;
        }
        this.setTitle(string);
        this.initLocalData(collection);
        this.initGuiComponents();
        this.initListeners();
        super.setVisible(true);
        return this.buttonPressed;
    }
}

