/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.creole.BootStrap;
import gate.gui.MainFrame;
import gate.util.Err;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class BootStrapDialog
extends JDialog {
    MainFrame mainFrame = null;
    BootStrapDialog thisBootStrapDialog = null;
    BootStrap bootStrapWizard = null;
    String resourceName = null;
    String packageName = null;
    String resourceType = null;
    Map resourceTypes = null;
    String className = null;
    Set resourceInterfaces = null;
    String possibleInterfaces = null;
    String pathNewProject = null;
    JLabel resourceNameLabel = null;
    JTextField resourceNameTextField = null;
    JLabel packageNameLabel = null;
    JTextField packageNameTextField = null;
    JLabel resourceTypesLabel = null;
    JComboBox resourceTypesComboBox = null;
    JLabel classNameLabel = null;
    JTextField classNameTextField = null;
    JLabel interfacesLabel = null;
    JTextField interfacesTextField = null;
    JLabel chooseFolderLabel = null;
    JTextField chooseFolderTextField = null;
    JButton chooseFolderButton = null;
    JButton createResourceButton = null;
    JButton cancelButton = null;
    JButton helpButton = null;
    JFileChooser fileChooser = null;

    public BootStrapDialog(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.thisBootStrapDialog = this;
        this.setTitle("BootStrap Wizard");
        this.setDefaultCloseOperation(2);
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
    }

    private void doCreateResource() {
        this.resourceName = this.resourceNameTextField.getText();
        if (this.resourceName == null || "".equals(this.resourceName)) {
            this.thisBootStrapDialog.setModal(false);
            JOptionPane.showMessageDialog(this.mainFrame, "A name for the resource must be provided", "ERROR !", 0);
            this.thisBootStrapDialog.setModal(true);
            return;
        }
        this.packageName = this.packageNameTextField.getText();
        if (this.packageName == null || "".equals(this.packageName)) {
            this.thisBootStrapDialog.setModal(false);
            JOptionPane.showMessageDialog(this.mainFrame, "A package name must be provided", "ERROR !", 0);
            this.thisBootStrapDialog.setModal(true);
            return;
        }
        this.className = this.classNameTextField.getText();
        if (this.className == null || "".equals(this.className)) {
            this.thisBootStrapDialog.setModal(false);
            JOptionPane.showMessageDialog(this.mainFrame, "A name for the implementing class must be provided", "ERROR !", 0);
            this.thisBootStrapDialog.setModal(true);
            return;
        }
        this.pathNewProject = this.chooseFolderTextField.getText();
        if (this.pathNewProject == null || "".equals(this.pathNewProject)) {
            this.thisBootStrapDialog.setModal(false);
            JOptionPane.showMessageDialog(this.mainFrame, "A path to the creation folder must be provided", "ERROR !", 0);
            this.thisBootStrapDialog.setModal(true);
            return;
        }
        this.resourceType = (String)this.resourceTypesComboBox.getSelectedItem();
        this.resourceInterfaces = this.getSelectedInterfaces();
        Thread thread = new Thread(Thread.currentThread().getThreadGroup(), new CreateResourceRunner(), "BootstrapDialog1");
        thread.setPriority(1);
        thread.start();
    }

    public void initLocalData() {
        this.pathNewProject = new String(".");
        this.resourceTypes = new HashMap();
        this.resourceTypes.put("LanguageResource", "gate.LanguageResource");
        this.resourceTypes.put("VisualResource", "gate.VisualResource");
        this.resourceTypes.put("ProcessingResource", "gate.ProcessingResource");
        this.possibleInterfaces = (String)this.resourceTypes.get("LanguageResource");
        if (this.possibleInterfaces == null) {
            this.possibleInterfaces = new String();
        }
    }

    public void initGuiComponents() {
        Point point;
        Dimension dimension;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setModal(true);
        this.resourceNameLabel = new JLabel("Resource name, e.g. myMorph");
        this.resourceNameLabel.setToolTipText("The name of the resource you want to create");
        this.resourceNameLabel.setOpaque(true);
        this.resourceNameLabel.setAlignmentX(0.0f);
        this.resourceNameTextField = new JTextField();
        this.resourceNameTextField.setAlignmentX(0.0f);
        this.resourceNameTextField.setColumns(40);
        Dimension dimension2 = new Dimension(this.resourceNameTextField.getPreferredSize().width, this.resourceNameTextField.getPreferredSize().height);
        this.resourceNameTextField.setPreferredSize(dimension2);
        this.resourceNameTextField.setMinimumSize(dimension2);
        this.packageNameLabel = new JLabel("Resource package, e.g. sheffield.creole.morph");
        this.packageNameLabel.setToolTipText("The Java package of the resource you want to create");
        this.packageNameLabel.setOpaque(true);
        this.packageNameLabel.setAlignmentX(0.0f);
        this.packageNameTextField = new JTextField();
        this.packageNameTextField.setAlignmentX(0.0f);
        this.packageNameTextField.setColumns(40);
        dimension2 = new Dimension(this.packageNameTextField.getPreferredSize().width, this.packageNameTextField.getPreferredSize().height);
        this.packageNameTextField.setPreferredSize(dimension2);
        this.packageNameTextField.setMinimumSize(dimension2);
        this.resourceTypesLabel = new JLabel("Resource type");
        this.resourceTypesLabel.setToolTipText("Resources must be LRs, PRs or VRs");
        this.resourceTypesLabel.setOpaque(true);
        this.resourceTypesLabel.setAlignmentX(0.0f);
        Vector vector = new Vector(this.resourceTypes.keySet());
        Collections.sort(vector);
        this.resourceTypesComboBox = new JComboBox(vector);
        this.resourceTypesComboBox.setEditable(false);
        this.resourceTypesComboBox.setAlignmentX(0.0f);
        this.classNameLabel = new JLabel("Implementing class name, e.g. Morpher");
        this.classNameLabel.setToolTipText("The name of the class that impements this resource");
        this.classNameLabel.setOpaque(true);
        this.classNameLabel.setAlignmentX(0.0f);
        this.classNameTextField = new JTextField();
        this.classNameTextField.setAlignmentX(0.0f);
        this.classNameTextField.setColumns(40);
        dimension2 = new Dimension(this.classNameTextField.getPreferredSize().width, this.classNameTextField.getPreferredSize().height);
        this.classNameTextField.setPreferredSize(dimension2);
        this.classNameTextField.setMinimumSize(dimension2);
        this.interfacesLabel = new JLabel("Interfaces implemented");
        this.interfacesLabel.setToolTipText("Any additional interfaces implemented, separated by comma");
        this.interfacesLabel.setOpaque(true);
        this.interfacesLabel.setAlignmentX(0.0f);
        this.interfacesTextField = new JTextField(this.possibleInterfaces);
        this.interfacesTextField.setAlignmentX(0.0f);
        this.interfacesTextField.setColumns(40);
        dimension2 = new Dimension(this.interfacesTextField.getPreferredSize().width, this.interfacesTextField.getPreferredSize().height);
        this.interfacesTextField.setPreferredSize(dimension2);
        this.interfacesTextField.setMinimumSize(dimension2);
        this.chooseFolderLabel = new JLabel("Create in folder ...");
        this.chooseFolderLabel.setOpaque(true);
        this.chooseFolderLabel.setAlignmentX(0.0f);
        this.chooseFolderLabel.setToolTipText("Select the name of the folder where you want the resource to be created.");
        this.chooseFolderButton = new JButton("Browse");
        this.chooseFolderButton.setAlignmentX(0.0f);
        this.chooseFolderTextField = new JTextField();
        this.chooseFolderTextField.setAlignmentX(0.0f);
        this.chooseFolderTextField.setColumns(35);
        dimension2 = new Dimension(this.chooseFolderTextField.getPreferredSize().width, this.chooseFolderTextField.getPreferredSize().height);
        this.chooseFolderTextField.setPreferredSize(dimension2);
        this.chooseFolderTextField.setMinimumSize(dimension2);
        this.createResourceButton = new JButton("Finish");
        this.getRootPane().setDefaultButton(this.createResourceButton);
        this.cancelButton = new JButton("Cancel");
        this.helpButton = new JButton("Help");
        this.fileChooser = new JFileChooser();
        Box box = new Box(1);
        Box box2 = new Box(1);
        box2.add(this.resourceNameLabel);
        box2.add(this.resourceNameTextField);
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        box2 = new Box(1);
        box2.add(this.packageNameLabel);
        box2.add(this.packageNameTextField);
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        box2 = new Box(1);
        box2.add(this.resourceTypesLabel);
        box2.add(this.resourceTypesComboBox);
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        box2 = new Box(1);
        box2.add(this.classNameLabel);
        box2.add(this.classNameTextField);
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        box2 = new Box(1);
        box2.add(this.interfacesLabel);
        box2.add(this.interfacesTextField);
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        box2 = new Box(1);
        box2.add(this.chooseFolderLabel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(this.chooseFolderTextField);
        jPanel.add(this.chooseFolderButton);
        box2.add(jPanel);
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(0, 20)));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.createResourceButton);
        jPanel.add(Box.createRigidArea(new Dimension(25, 0)));
        jPanel.add(this.cancelButton);
        jPanel.add(Box.createRigidArea(new Dimension(25, 0)));
        jPanel.add(this.helpButton);
        jPanel.add(Box.createHorizontalGlue());
        box.add(jPanel);
        this.getContentPane().add(Box.createVerticalGlue());
        this.getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
        this.getContentPane().add(box);
        this.getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
        this.getContentPane().add(Box.createVerticalGlue());
        this.pack();
        if (this.getOwner() == null) {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
            point = new Point(0, 0);
        } else {
            dimension = this.getOwner().getSize();
            point = this.getOwner().getLocation();
            if (dimension.height == 0 || dimension.width == 0 || !this.getOwner().isVisible()) {
                dimension = Toolkit.getDefaultToolkit().getScreenSize();
                point = new Point(0, 0);
            }
        }
        Dimension dimension3 = this.getSize();
        if (dimension3.height > dimension.height) {
            dimension3.height = dimension.height;
        }
        if (dimension3.width > dimension.width) {
            dimension3.width = dimension.width;
        }
        this.setLocation(point.x + (dimension.width - dimension3.width) / 2, point.y + (dimension.height - dimension3.height) / 2);
    }

    public void initListeners() {
        this.createResourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BootStrapDialog.this.doCreateResource();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BootStrapDialog.this.thisBootStrapDialog.setVisible(false);
                BootStrapDialog.this.dispose();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.getInstance().showHelpFrame("http://gate.ac.uk/userguide/sec:api:bootstrap", "gate.gui.BootStrapDialog");
            }
        });
        this.resourceTypesComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)BootStrapDialog.this.resourceTypesComboBox.getSelectedItem();
                BootStrapDialog.this.possibleInterfaces = (String)BootStrapDialog.this.resourceTypes.get(string);
                BootStrapDialog.this.interfacesTextField.setText(BootStrapDialog.this.possibleInterfaces);
            }
        });
        this.chooseFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BootStrapDialog.this.fileChooser.setDialogTitle("Select the path for this resource");
                BootStrapDialog.this.fileChooser.setFileSelectionMode(1);
                if (BootStrapDialog.this.fileChooser.showOpenDialog(BootStrapDialog.this.mainFrame) == 0) {
                    BootStrapDialog.this.pathNewProject = BootStrapDialog.this.fileChooser.getSelectedFile().toString();
                    BootStrapDialog.this.fileChooser.setCurrentDirectory(BootStrapDialog.this.fileChooser.getCurrentDirectory());
                }
                BootStrapDialog.this.chooseFolderTextField.setText(BootStrapDialog.this.pathNewProject);
            }
        });
        InputMap inputMap = ((JComponent)this.getContentPane()).getInputMap(2);
        ActionMap actionMap = ((JComponent)this.getContentPane()).getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "Apply");
        actionMap.put("Apply", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BootStrapDialog.this.createResourceButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "Cancel");
        actionMap.put("Cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BootStrapDialog.this.cancelButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("F1"), "Help");
        actionMap.put("Help", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BootStrapDialog.this.helpButton.doClick();
            }
        });
    }

    public Set getSelectedInterfaces() {
        String string = this.interfacesTextField.getText();
        this.resourceInterfaces = new HashSet();
        if (string == null || "".equals(string)) {
            return this.resourceInterfaces;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            this.resourceInterfaces.add(string2);
        }
        return this.resourceInterfaces;
    }

    class CreateResourceRunner
    implements Runnable {
        public void run() {
            try {
                BootStrapDialog.this.bootStrapWizard = new BootStrap();
                BootStrapDialog.this.bootStrapWizard.createResource(BootStrapDialog.this.resourceName, BootStrapDialog.this.packageName, BootStrapDialog.this.resourceType, BootStrapDialog.this.className, BootStrapDialog.this.resourceInterfaces, BootStrapDialog.this.pathNewProject);
                BootStrapDialog.this.thisBootStrapDialog.setVisible(false);
                BootStrapDialog.this.thisBootStrapDialog.dispose();
                JOptionPane.showMessageDialog(BootStrapDialog.this.mainFrame, BootStrapDialog.this.resourceName + " creation succeeded !\n" + "Look for it in " + BootStrapDialog.this.pathNewProject, "DONE !", -1);
            }
            catch (Exception exception) {
                BootStrapDialog.this.thisBootStrapDialog.setModal(false);
                exception.printStackTrace(Err.getPrintWriter());
                JOptionPane.showMessageDialog(BootStrapDialog.this.mainFrame, exception.getMessage() + "\n Resource creation stopped !", "BootStrap error !", 0);
                BootStrapDialog.this.thisBootStrapDialog.setModal(true);
            }
        }
    }
}

