/*
 * Decompiled with CFR 0.152.
 */
package gate.fsm;

import gate.fsm.RuleTime;
import gate.fsm.State;
import gate.fsm.Transition;
import gate.jape.BasicPatternElement;
import gate.jape.ComplexPatternElement;
import gate.jape.Constraint;
import gate.jape.ConstraintGroup;
import gate.jape.JapeConstants;
import gate.jape.KleeneOperator;
import gate.jape.LeftHandSide;
import gate.jape.PatternElement;
import gate.jape.PrioritisedRuleList;
import gate.jape.RightHandSide;
import gate.jape.Rule;
import gate.jape.SinglePhaseTransducer;
import gate.util.Benchmark;
import gate.util.SimpleArraySet;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSM
implements JapeConstants {
    private ArrayList<RuleTime> ruleTimes = new ArrayList();
    private static final boolean DEBUG = false;
    protected State currentState;
    protected Transition currentTransition;
    private State initialState;
    protected State finalState;
    private transient Collection allStates = new HashSet();
    private transient Map<AbstractSet, State> newStates = new HashMap<AbstractSet, State>();
    private transient Set<AbstractSet> dStates = new HashSet<AbstractSet>();
    int bpeId = 0;
    public HashMap<String, String> ruleHash = new HashMap();

    public ArrayList<RuleTime> getRuleTimes() {
        return this.ruleTimes;
    }

    private void decorateStates() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        this.ruleTimes.add(new RuleTime(0L, "_____Initial_State_for_all_rules"));
        this.ruleTimes.add(new RuleTime(0L, "___UNKNOWN_RULES_TYPE_1"));
        this.ruleTimes.add(new RuleTime(0L, "___UNKNOWN_RULES_TYPE_2"));
        int n = 0;
        for (Transition transition : this.getInitialState().getTransitions()) {
            n = transition.getTarget().getRuleForState(hashMap, this.ruleTimes);
            assert (n != 2 && n != 1);
        }
        this.getInitialState().setIndexInRuleList(0);
    }

    protected FSM() {
        this.initialState = new State();
    }

    public FSM(SinglePhaseTransducer singlePhaseTransducer) {
        this();
        this.addRules(singlePhaseTransducer.getRules());
        if (Benchmark.isBenchmarkingEnabled()) {
            this.decorateStates();
        }
    }

    protected void addRules(PrioritisedRuleList prioritisedRuleList) {
        Iterator iterator = prioritisedRuleList.iterator();
        while (iterator.hasNext()) {
            FSM fSM = this.spawn((Rule)iterator.next());
            this.ruleHash.putAll(fSM.ruleHash);
            this.initialState.addTransition(new Transition(null, fSM.getInitialState()));
        }
        this.eliminateVoidTransitions();
    }

    public FSM(Rule rule) {
        this();
        this.setRule(rule);
    }

    protected void setRule(Rule rule) {
        LeftHandSide leftHandSide = rule.getLHS();
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = this.currentLHSBinding(leftHandSide);
        linkedList.add(string);
        this.ruleHash.put(rule.getName(), string);
        PatternElement[][] patternElementArray = leftHandSide.getConstraintGroup().getPatternElementDisjunction();
        State state = new State();
        for (int i = 0; i < patternElementArray.length; ++i) {
            State state2 = this.initialState;
            for (int j = 0; j < patternElementArray[i].length; ++j) {
                PatternElement patternElement = patternElementArray[i][j];
                State state3 = new State();
                state2.addTransition(new Transition(null, state3));
                state2 = state3;
                if (patternElement instanceof BasicPatternElement) {
                    State state4 = new State();
                    LinkedList<String> linkedList2 = new LinkedList<String>();
                    linkedList2.add(this.currentBasicBinding((BasicPatternElement)patternElement));
                    state2.addTransition(new Transition((BasicPatternElement)patternElement, state4, linkedList2));
                    state2 = state4;
                    continue;
                }
                if (patternElement instanceof ComplexPatternElement) {
                    state2 = this.convertComplexPE(state2, (ComplexPatternElement)patternElement, linkedList);
                    continue;
                }
                throw new RuntimeException("Strange looking pattern: " + patternElement);
            }
            state2.addTransition(new Transition(null, state));
            state.setAction(rule.getRHS());
            state.setFileIndex(rule.getPosition());
            state.setPriority(rule.getPriority());
        }
    }

    protected FSM(ComplexPatternElement complexPatternElement) {
        this();
        this.finalState = this.convertComplexPE(this.initialState, complexPatternElement, new LinkedList<String>());
        this.finalState.isFinal = true;
    }

    protected FSM spawn(Rule rule) {
        return new FSM(rule);
    }

    protected FSM spawn(ComplexPatternElement complexPatternElement) {
        return new FSM(complexPatternElement);
    }

    public State getInitialState() {
        return this.initialState;
    }

    private State convertComplexPE(State state, ComplexPatternElement complexPatternElement, LinkedList<String> linkedList) {
        State state2 = this.generateStates(state, complexPatternElement, linkedList);
        KleeneOperator kleeneOperator = complexPatternElement.getKleeneOp();
        KleeneOperator.Type type = kleeneOperator.getType();
        if (type == KleeneOperator.Type.OPTIONAL) {
            state.addTransition(new Transition(null, state2));
        } else if (type == KleeneOperator.Type.PLUS) {
            state2.addTransition(new Transition(null, state));
        } else if (type == KleeneOperator.Type.STAR) {
            state.addTransition(new Transition(null, state2));
            state2.addTransition(new Transition(null, state));
        } else if (type == KleeneOperator.Type.RANGE) {
            int n;
            int n2;
            Integer n3 = kleeneOperator.getMin();
            Integer n4 = kleeneOperator.getMax();
            ArrayList<State> arrayList = new ArrayList<State>();
            if (n3 == null || n3 == 0) {
                arrayList.add(state);
            } else if (n3 > 1) {
                n2 = n3 - 1;
                for (n = 1; n <= n2; ++n) {
                    state = state2;
                    state2 = this.generateStates(state, complexPatternElement, linkedList);
                }
            }
            if (n4 == null) {
                state2.addTransition(new Transition(null, state));
            } else if (n4 > n3) {
                n2 = n4 - n3;
                if (n3 == 0) {
                    --n2;
                }
                for (n = 1; n <= n2; ++n) {
                    state = state2;
                    arrayList.add(state);
                    state2 = this.generateStates(state, complexPatternElement, linkedList);
                }
            }
            for (State state3 : arrayList) {
                state3.addTransition(new Transition(null, state2));
            }
        }
        return state2;
    }

    private State generateStates(State state, ComplexPatternElement complexPatternElement, LinkedList<String> linkedList) {
        LinkedList linkedList2 = (LinkedList)linkedList.clone();
        String string = complexPatternElement.getBindingName();
        if (string != null) {
            linkedList2.add(string);
        }
        ConstraintGroup constraintGroup = complexPatternElement.getConstraintGroup();
        PatternElement[][] patternElementArray = constraintGroup.getPatternElementDisjunction();
        State state2 = new State();
        for (int i = 0; i < patternElementArray.length; ++i) {
            State state3 = state;
            for (int j = 0; j < patternElementArray[i].length; ++j) {
                State state4 = new State();
                state3.addTransition(new Transition(null, state4));
                state3 = state4;
                PatternElement patternElement = patternElementArray[i][j];
                if (patternElement instanceof BasicPatternElement) {
                    State state5 = new State();
                    linkedList2.add(this.currentBasicBinding((BasicPatternElement)patternElement));
                    state3.addTransition(new Transition((BasicPatternElement)patternElement, state5, linkedList2));
                    state3 = state5;
                    continue;
                }
                if (patternElement instanceof ComplexPatternElement) {
                    state3 = this.convertComplexPE(state3, (ComplexPatternElement)patternElement, linkedList2);
                    continue;
                }
                throw new RuntimeException("Strange looking pattern:" + patternElement);
            }
            state3.addTransition(new Transition(null, state2));
        }
        return state2;
    }

    public void eliminateVoidTransitions() {
        this.dStates.clear();
        LinkedList<AbstractSet> linkedList = new LinkedList<AbstractSet>();
        AbstractSet abstractSet = new HashSet<State>();
        this.newStates.clear();
        abstractSet.add(this.initialState);
        abstractSet = this.lambdaClosure(abstractSet);
        this.dStates.add(abstractSet);
        linkedList.add(abstractSet);
        this.initialState = new State();
        this.newStates.put(abstractSet, this.initialState);
        Iterator iterator = abstractSet.iterator();
        RightHandSide rightHandSide = null;
        while (iterator.hasNext()) {
            State state = (State)iterator.next();
            if (!state.isFinal()) continue;
            rightHandSide = state.getAction();
            this.initialState.setAction(rightHandSide);
            this.initialState.setFileIndex(state.getFileIndex());
            this.initialState.setPriority(state.getPriority());
            break;
        }
        while (!linkedList.isEmpty()) {
            abstractSet = (AbstractSet)linkedList.removeFirst();
            for (State state : abstractSet) {
                for (Transition transition : state.getTransitions()) {
                    State state22;
                    State state3;
                    if (transition.getConstraints() == null) continue;
                    State state4 = transition.getTarget();
                    AbstractSet abstractSet2 = new HashSet<State>();
                    abstractSet2.add(state4);
                    abstractSet2 = this.lambdaClosure(abstractSet2);
                    if (!this.dStates.contains(abstractSet2)) {
                        this.dStates.add(abstractSet2);
                        linkedList.add(abstractSet2);
                        state3 = new State();
                        this.newStates.put(abstractSet2, state3);
                        for (State state22 : abstractSet2) {
                            if (!state22.isFinal()) continue;
                            state3.setAction(state22.getAction());
                            state3.setFileIndex(state22.getFileIndex());
                            state3.setPriority(state22.getPriority());
                            break;
                        }
                    }
                    state3 = this.newStates.get(abstractSet);
                    state22 = this.newStates.get(abstractSet2);
                    state3.addTransition(new Transition(transition.getConstraints(), state22, transition.getBindings()));
                }
            }
        }
        this.allStates = this.newStates.values();
    }

    private AbstractSet<State> lambdaClosure(AbstractSet<State> abstractSet) {
        LinkedList<State> linkedList = new LinkedList<State>(abstractSet);
        HashSet<State> hashSet = new HashSet<State>(abstractSet);
        while (!linkedList.isEmpty()) {
            State state = linkedList.removeFirst();
            for (Transition transition : state.getTransitions()) {
                State state2;
                if (transition.getConstraints() != null || ((AbstractCollection)hashSet).contains(state2 = transition.getTarget())) continue;
                ((AbstractCollection)hashSet).add(state2);
                linkedList.addFirst(state2);
            }
        }
        return hashSet;
    }

    protected void forEachState(Runnable runnable) {
        HashSet<State> hashSet = new HashSet<State>();
        HashSet<State> hashSet2 = new HashSet<State>();
        hashSet.add(this.initialState);
        while (!hashSet.isEmpty()) {
            this.currentState = (State)hashSet.iterator().next();
            hashSet.remove(this.currentState);
            hashSet2.add(this.currentState);
            Iterator<Transition> iterator = this.currentState.getTransitions().iterator();
            while (iterator.hasNext()) {
                Transition transition;
                this.currentTransition = transition = iterator.next();
                State state = this.currentTransition.getTarget();
                if (hashSet2.contains(state) || hashSet.contains(state)) continue;
                hashSet.add(state);
                runnable.run();
            }
        }
    }

    public Map<State, SimpleArraySet<Transition>> getAllStates() {
        HashMap<State, SimpleArraySet<Transition>> hashMap = new HashMap<State, SimpleArraySet<Transition>>();
        HashSet<State> hashSet = new HashSet<State>();
        HashSet<State> hashSet2 = new HashSet<State>();
        hashSet.add(this.initialState);
        while (!hashSet.isEmpty()) {
            this.currentState = (State)hashSet.iterator().next();
            hashSet.remove(this.currentState);
            hashSet2.add(this.currentState);
            SimpleArraySet<Transition> simpleArraySet = this.currentState.getTransitions();
            hashMap.put(this.currentState, simpleArraySet);
            for (Transition this.currentTransition : simpleArraySet) {
                State state = this.currentTransition.getTarget();
                if (hashSet2.contains(state) || hashSet.contains(state)) continue;
                hashSet.add(state);
            }
        }
        return hashMap;
    }

    public String asGraphViz(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digraph G {\n");
        for (State state : this.getAllStates().keySet()) {
            int n = state.getIndex();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("shape", state == this.initialState ? "diamond" : "circle");
            hashMap.put("color", state == this.initialState ? "green" : (state.isFinal() ? "red" : "black"));
            if (state.isFinal()) {
                hashMap.put("peripheries", "2");
            }
            stringBuffer.append("  " + n + " [" + this.encodeForGraphViz(hashMap) + "]" + ";\n");
            for (Transition transition : state.getTransitions()) {
                String string = bl ? " [label=\"" + transition.toString(false) + "\"]" : "";
                stringBuffer.append("  " + n + " -> " + transition.getTarget().getIndex() + string + ";\n");
            }
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    String encodeForGraphViz(Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.size());
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            string2 = string2.replaceAll("\r\n", "\\\\l");
            string2 = string2.replaceAll("\"", "\\\\\"");
            arrayList.add(string + "=\"" + string2 + "\"");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append((String)arrayList.get(i));
        }
        return stringBuffer.toString();
    }

    public String getGML() {
        String string = "graph[ \ndirected 1\n";
        StringBuffer stringBuffer = new StringBuffer(1024);
        StringBuffer stringBuffer2 = new StringBuffer(1024);
        for (State state : this.allStates) {
            int n = state.getIndex();
            stringBuffer.append("node[ id ");
            stringBuffer.append(n);
            stringBuffer.append(" label \"");
            stringBuffer.append(n);
            if (state.isFinal()) {
                stringBuffer.append(",F\\n" + state.getAction().shortDesc());
            }
            stringBuffer.append("\"  ]\n");
            stringBuffer2.append(state.getEdgesGML());
        }
        string = string + stringBuffer.toString() + stringBuffer2.toString() + "]\n";
        return string;
    }

    public String toString() {
        String string = "Starting from:" + this.initialState.getIndex() + "\n";
        Iterator iterator = this.allStates.iterator();
        while (iterator.hasNext()) {
            string = string + "\n\n" + iterator.next();
        }
        return string;
    }

    private String currentBinding(ComplexPatternElement complexPatternElement, int n) {
        if (n == 0) {
            this.bpeId = 0;
        }
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "   ";
        }
        String string2 = string + "(\n";
        PatternElement[][] patternElementArray = complexPatternElement.getConstraintGroup().getPatternElementDisjunction();
        for (int i = 0; i < patternElementArray.length; ++i) {
            PatternElement[] patternElementArray2 = patternElementArray[i];
            for (int j = 0; j < patternElementArray2.length; ++j) {
                PatternElement patternElement = patternElementArray2[j];
                if (patternElement instanceof ComplexPatternElement) {
                    ComplexPatternElement complexPatternElement2 = (ComplexPatternElement)patternElement;
                    string2 = string2 + this.currentBinding(complexPatternElement2, n + 1);
                    continue;
                }
                string2 = string2 + string + "   ";
                string2 = string2 + this.currentBasicBinding((BasicPatternElement)patternElement);
                string2 = string2 + "\n";
            }
            string2 = string2 + string + "   |\n";
        }
        string2 = string2.substring(0, string2.length() - 5);
        string2 = string2 + ")" + complexPatternElement.getKleeneOp().toString() + "\n";
        if (n == 0) {
            this.bpeId = 0;
        }
        return string2;
    }

    private String currentBasicBinding(BasicPatternElement basicPatternElement) {
        StringBuilder stringBuilder = new StringBuilder("{");
        Constraint[] constraintArray = basicPatternElement.getConstraints();
        for (int i = 0; i < constraintArray.length; ++i) {
            stringBuilder.append(constraintArray[i].getDisplayString(""));
            if (i >= constraintArray.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("}").append(" *").append(this.bpeId++).append("*");
        return stringBuilder.toString();
    }

    private String currentLHSBinding(LeftHandSide leftHandSide) {
        String string = "(\n";
        PatternElement[][] patternElementArray = leftHandSide.getConstraintGroup().getPatternElementDisjunction();
        for (int i = 0; i < patternElementArray.length; ++i) {
            PatternElement[] patternElementArray2 = patternElementArray[i];
            for (int j = 0; j < patternElementArray2.length; ++j) {
                PatternElement patternElement = patternElementArray2[j];
                if (patternElement instanceof ComplexPatternElement) {
                    ComplexPatternElement complexPatternElement = (ComplexPatternElement)patternElement;
                    string = string + this.currentBinding(complexPatternElement, 1);
                    continue;
                }
                string = string + "   ";
                string = string + this.currentBasicBinding((BasicPatternElement)patternElement);
                string = string + "\n";
            }
            string = string + "   |\n";
        }
        string = string.substring(0, string.length() - 5);
        string = string + ")\n";
        this.bpeId = 0;
        return string;
    }
}

