/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.tokeniser;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.AbstractProcessingResource;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.ResourceInstantiationException;
import gate.creole.Transducer;
import gate.creole.tokeniser.SimpleTokeniser;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.util.Benchmark;
import gate.util.Benchmarkable;
import java.net.URL;

public class DefaultTokeniser
extends AbstractLanguageAnalyser
implements Benchmarkable {
    public static final String DEF_TOK_DOCUMENT_PARAMETER_NAME = "document";
    public static final String DEF_TOK_ANNOT_SET_PARAMETER_NAME = "annotationSetName";
    public static final String DEF_TOK_TOKRULES_URL_PARAMETER_NAME = "tokeniserRulesURL";
    public static final String DEF_TOK_GRAMRULES_URL_PARAMETER_NAME = "transducerGrammarURL";
    public static final String DEF_TOK_ENCODING_PARAMETER_NAME = "encoding";
    private static final boolean DEBUG = false;
    protected SimpleTokeniser tokeniser;
    protected Transducer transducer;
    private URL tokeniserRulesURL;
    private String encoding;
    private URL transducerGrammarURL;
    private String annotationSetName;
    private String benchmarkId;

    public Resource init() throws ResourceInstantiationException {
        try {
            super.init();
            this.fireStatusChanged("Creating a tokeniser");
            FeatureMap featureMap = Factory.newFeatureMap();
            if (this.tokeniserRulesURL != null) {
                featureMap.put("rulesURL", this.tokeniserRulesURL);
            }
            featureMap.put(DEF_TOK_ENCODING_PARAMETER_NAME, this.encoding);
            FeatureMap featureMap2 = Factory.newFeatureMap();
            Gate.setHiddenAttribute(featureMap2, true);
            this.tokeniser = (SimpleTokeniser)Factory.createResource("gate.creole.tokeniser.SimpleTokeniser", featureMap, featureMap2);
            this.tokeniser.setName("Tokeniser " + System.currentTimeMillis());
            this.fireProgressChanged(50);
            this.fireStatusChanged("Creating a Jape transducer");
            featureMap.clear();
            if (this.transducerGrammarURL != null) {
                featureMap.put("grammarURL", this.transducerGrammarURL);
            }
            featureMap.put(DEF_TOK_ENCODING_PARAMETER_NAME, this.encoding);
            featureMap2.clear();
            Gate.setHiddenAttribute(featureMap2, true);
            this.transducer = (Transducer)Factory.createResource("gate.creole.Transducer", featureMap, featureMap2);
            this.fireProgressChanged(100);
            this.fireProcessFinished();
            this.transducer.setName("Transducer " + System.currentTimeMillis());
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw resourceInstantiationException;
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException(exception);
        }
        return this;
    }

    public void execute() throws ExecutionException {
        Object object;
        this.interrupted = false;
        try {
            object = Factory.newFeatureMap();
            this.fireProgressChanged(0);
            object.put(DEF_TOK_DOCUMENT_PARAMETER_NAME, this.document);
            object.put(DEF_TOK_ANNOT_SET_PARAMETER_NAME, this.annotationSetName);
            this.tokeniser.setParameterValues((FeatureMap)object);
            object.clear();
            object.put(DEF_TOK_DOCUMENT_PARAMETER_NAME, this.document);
            object.put("inputASName", this.annotationSetName);
            object.put("outputASName", this.annotationSetName);
            this.transducer.setParameterValues((FeatureMap)object);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new ExecutionException(resourceInstantiationException);
        }
        object = null;
        StatusListener statusListener = null;
        this.fireProgressChanged(5);
        object = new AbstractProcessingResource.IntervalProgressListener(5, 50);
        statusListener = new StatusListener(){

            public void statusChanged(String string) {
                DefaultTokeniser.this.fireStatusChanged(string);
            }
        };
        if (this.isInterrupted()) {
            throw new ExecutionInterruptedException("The execution of the \"" + this.getName() + "\" tokeniser has been abruptly interrupted!");
        }
        this.tokeniser.addProgressListener((ProgressListener)object);
        this.tokeniser.addStatusListener(statusListener);
        try {
            Benchmark.executeWithBenchmarking(this.tokeniser, Benchmark.createBenchmarkId("simpleTokeniser", this.getBenchmarkId()), this, null);
        }
        catch (ExecutionInterruptedException executionInterruptedException) {
            throw new ExecutionInterruptedException("The execution of the \"" + this.getName() + "\" tokeniser has been abruptly interrupted!");
        }
        this.tokeniser.removeProgressListener((ProgressListener)object);
        this.tokeniser.removeStatusListener(statusListener);
        if (this.isInterrupted()) {
            throw new ExecutionInterruptedException("The execution of the \"" + this.getName() + "\" tokeniser has been abruptly interrupted!");
        }
        object = new AbstractProcessingResource.IntervalProgressListener(50, 100);
        this.transducer.addProgressListener((ProgressListener)object);
        this.transducer.addStatusListener(statusListener);
        Benchmark.executeWithBenchmarking(this.transducer, Benchmark.createBenchmarkId("transducer", this.getBenchmarkId()), this, null);
        this.transducer.removeProgressListener((ProgressListener)object);
        this.transducer.removeStatusListener(statusListener);
    }

    public synchronized void interrupt() {
        this.interrupted = true;
        this.tokeniser.interrupt();
        this.transducer.interrupt();
    }

    public void setTokeniserRulesURL(URL uRL) {
        this.tokeniserRulesURL = uRL;
    }

    public URL getTokeniserRulesURL() {
        return this.tokeniserRulesURL;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setTransducerGrammarURL(URL uRL) {
        this.transducerGrammarURL = uRL;
    }

    public URL getTransducerGrammarURL() {
        return this.transducerGrammarURL;
    }

    public void setAnnotationSetName(String string) {
        this.annotationSetName = string;
    }

    public String getAnnotationSetName() {
        return this.annotationSetName;
    }

    public void setBenchmarkId(String string) {
        this.benchmarkId = string;
    }

    public String getBenchmarkId() {
        if (this.benchmarkId == null) {
            return this.getName();
        }
        return this.benchmarkId;
    }
}

