/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.splitter;

import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.util.InvalidOffsetException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexSentenceSplitter
extends AbstractLanguageAnalyser {
    public static final String SPLIT_DOCUMENT_PARAMETER_NAME = "document";
    public static final String SPLIT_INPUT_AS_PARAMETER_NAME = "inputASName";
    public static final String SPLIT_OUTPUT_AS_PARAMETER_NAME = "outputASName";
    public static final String SPLIT_ENCODING_PARAMETER_NAME = "encoding";
    public static final String SPLIT_SPLIT_LIST_PARAMETER_NAME = "splitListURL";
    public static final String SPLIT_NON_SPLIT_LIST_PARAMETER_NAME = "nonSplitListURL";
    private static final long serialVersionUID = 1L;
    protected Document document;
    protected String outputASName;
    protected String encoding;
    protected URL internalSplitListURL;
    protected URL externalSplitListURL;
    protected URL nonSplitListURL;
    protected Pattern internalSplitsPattern;
    protected Pattern externalSplitsPattern;
    protected Pattern nonSplitsPattern;

    protected Pattern compilePattern(URL uRL, String string) throws UnsupportedEncodingException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), string));
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if ((string2 = string2.trim()).length() != 0 && !string2.startsWith("//")) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("|");
                }
                stringBuffer.append("(?:" + string2 + ")");
            }
            string2 = bufferedReader.readLine();
        }
        return Pattern.compile(stringBuffer.toString());
    }

    @Override
    public void execute() throws ExecutionException {
        this.interrupted = false;
        int n = 0;
        this.fireProgressChanged(n);
        AnnotationSet annotationSet = this.outputASName == null || this.outputASName.trim().length() == 0 ? this.document.getAnnotations() : this.document.getAnnotations(this.outputASName);
        String string = this.document.getContent().toString();
        if (string.trim().length() < 1) {
            return;
        }
        Matcher matcher = this.internalSplitsPattern.matcher(string);
        Matcher matcher2 = this.externalSplitsPattern.matcher(string);
        Matcher matcher3 = this.nonSplitsPattern.matcher(string);
        LinkedList<int[]> linkedList = new LinkedList<int[]>();
        while (matcher3.find()) {
            linkedList.add(new int[]{matcher3.start(), matcher3.end()});
        }
        ArrayList<MatchResult> arrayList = new ArrayList<MatchResult>();
        MatchResult matchResult = null;
        if (matcher.find()) {
            matchResult = matcher.toMatchResult();
            arrayList.add(matchResult);
        }
        MatchResult matchResult2 = null;
        if (matcher2.find()) {
            matchResult2 = matcher2.toMatchResult();
            arrayList.add(matchResult2);
        }
        MatchResultComparator matchResultComparator = new MatchResultComparator();
        int n2 = 0;
        while (!arrayList.isEmpty()) {
            int n3;
            int n4;
            Collections.sort(arrayList, matchResultComparator);
            MatchResult matchResult3 = (MatchResult)arrayList.remove(0);
            if (matchResult3 == matchResult) {
                if (!this.veto(matchResult3, linkedList)) {
                    try {
                        FeatureMap featureMap = Factory.newFeatureMap();
                        featureMap.put("kind", "internal");
                        annotationSet.add(new Long(matchResult3.start()), new Long(matchResult3.end()), "Split", featureMap);
                        n4 = matchResult3.end();
                        while (n2 < n4 && Character.isWhitespace(Character.codePointAt(string, n2))) {
                            ++n2;
                        }
                        if (n2 < matchResult3.start()) {
                            annotationSet.add(new Long(n2), new Long(n4), "Sentence", Factory.newFeatureMap());
                        }
                        n2 = n4;
                    }
                    catch (InvalidOffsetException invalidOffsetException) {
                        throw new ExecutionException(invalidOffsetException);
                    }
                }
                if (matcher.find()) {
                    matchResult = matcher.toMatchResult();
                    arrayList.add(matchResult);
                } else {
                    matchResult = null;
                }
            } else if (matchResult3 == matchResult2) {
                if (!this.veto(matchResult3, linkedList)) {
                    try {
                        FeatureMap featureMap = Factory.newFeatureMap();
                        featureMap.put("kind", "external");
                        annotationSet.add(new Long(matchResult3.start()), new Long(matchResult3.end()), "Split", featureMap);
                        for (n4 = matchResult3.start(); n4 > n2 && Character.isSpaceChar(Character.codePointAt(string, n4 - 1)); --n4) {
                        }
                        while (n2 < n4 && Character.isSpaceChar(Character.codePointAt(string, n2))) {
                            ++n2;
                        }
                        if (n2 < n4) {
                            annotationSet.add(new Long(n2), new Long(n4), "Sentence", Factory.newFeatureMap());
                        }
                        n2 = matchResult3.end();
                    }
                    catch (InvalidOffsetException invalidOffsetException) {
                        throw new ExecutionException(invalidOffsetException);
                    }
                }
                if (matcher2.find()) {
                    matchResult2 = matcher2.toMatchResult();
                    arrayList.add(matchResult2);
                } else {
                    matchResult2 = null;
                }
            } else {
                throw new ExecutionException("Invalid state - cannot identify match!");
            }
            if ((n3 = 100 * n2 / string.length()) - n <= 20) continue;
            n = n3;
            this.fireProgressChanged(n);
        }
        this.fireProcessFinished();
    }

    private boolean veto(MatchResult matchResult, List<int[]> list) {
        Iterator<int[]> iterator = list.iterator();
        while (iterator.hasNext()) {
            int[] nArray = iterator.next();
            if (nArray[1] - 1 < matchResult.start()) {
                iterator.remove();
                continue;
            }
            return matchResult.end() - 1 >= nArray[0];
        }
        return false;
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        super.init();
        try {
            if (this.internalSplitListURL == null) {
                throw new ResourceInstantiationException("No list of internal splits provided!");
            }
            if (this.externalSplitListURL == null) {
                throw new ResourceInstantiationException("No list of external splits provided!");
            }
            if (this.nonSplitListURL == null) {
                throw new ResourceInstantiationException("No list of non splits provided!");
            }
            if (this.encoding == null) {
                throw new ResourceInstantiationException("No encoding provided!");
            }
            this.internalSplitsPattern = this.compilePattern(this.internalSplitListURL, this.encoding);
            this.externalSplitsPattern = this.compilePattern(this.externalSplitListURL, this.encoding);
            this.nonSplitsPattern = this.compilePattern(this.nonSplitListURL, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ResourceInstantiationException(unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new ResourceInstantiationException(iOException);
        }
        return this;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Document document) {
        this.document = document;
    }

    public String getOutputASName() {
        return this.outputASName;
    }

    public void setOutputASName(String string) {
        this.outputASName = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public URL getInternalSplitListURL() {
        return this.internalSplitListURL;
    }

    public void setInternalSplitListURL(URL uRL) {
        this.internalSplitListURL = uRL;
    }

    public URL getExternalSplitListURL() {
        return this.externalSplitListURL;
    }

    public void setExternalSplitListURL(URL uRL) {
        this.externalSplitListURL = uRL;
    }

    public URL getNonSplitListURL() {
        return this.nonSplitListURL;
    }

    public void setNonSplitListURL(URL uRL) {
        this.nonSplitListURL = uRL;
    }

    public Pattern getInternalSplitsPattern() {
        return this.internalSplitsPattern;
    }

    public void setInternalSplitsPattern(Pattern pattern) {
        this.internalSplitsPattern = pattern;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MatchResultComparator
    implements Comparator<MatchResult> {
        private MatchResultComparator() {
        }

        @Override
        public int compare(MatchResult matchResult, MatchResult matchResult2) {
            if (matchResult == null && matchResult2 == null) {
                return 0;
            }
            if (matchResult == null) {
                return 1;
            }
            if (matchResult2 == null) {
                return -1;
            }
            return matchResult.start() - matchResult2.start();
        }
    }
}

