/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.orthomatcher;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.creole.ExecutionException;
import gate.creole.orthomatcher.AnnotationOrthography;
import gate.creole.orthomatcher.OrthoMatcherHelper;
import gate.util.Err;
import gate.util.FeatureBearer;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAnnotationOrthography
implements AnnotationOrthography {
    private final boolean extLists;
    private final String personType;
    private final String unknownType;
    private Map<String, HashSet<String>> nicknameMap = new HashMap<String, HashSet<String>>();
    private final Double minimumNicknameLikelihood;
    protected static final Logger log = Logger.getLogger(BasicAnnotationOrthography.class);

    public BasicAnnotationOrthography(String string, boolean bl, String string2, URL uRL, Double d, String string3) {
        this.personType = string;
        this.extLists = bl;
        this.unknownType = string2;
        this.minimumNicknameLikelihood = d;
        try {
            if (uRL != null) {
                this.initNicknames(string3, uRL);
            }
        }
        catch (IOException iOException) {
            log.warn((Object)"Could not load nickname map.", (Throwable)iOException);
        }
    }

    @Override
    public String getStringForAnnotation(Annotation annotation, Document document) throws ExecutionException {
        String string = OrthoMatcherHelper.getStringForSpan(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset(), document);
        string = string.replaceAll("\\s+", " ");
        return string;
    }

    @Override
    public boolean fuzzyMatch(String string, String string2) {
        String string3;
        String string4 = string.toLowerCase();
        if (string4.equals(string3 = string2.toLowerCase())) {
            return true;
        }
        Set set = this.nicknameMap.get(string4);
        if (set != null && set.contains(string3)) {
            return true;
        }
        set = this.nicknameMap.get(string3);
        return set != null && set.contains(string4);
    }

    @Override
    public boolean allNonStopTokensInOtherAnnot(ArrayList<Annotation> arrayList, ArrayList<Annotation> arrayList2, String string, boolean bl) {
        for (Annotation annotation : arrayList) {
            if (annotation.getFeatures().containsKey("ortho_stop")) continue;
            String string2 = (String)annotation.getFeatures().get(string);
            boolean bl2 = false;
            for (Annotation annotation2 : arrayList2) {
                if (!OrthoMatcherHelper.straightCompare(string2, (String)annotation2.getFeatures().get(string), bl)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return false;
        }
        return true;
    }

    @Override
    public String stripPersonTitle(String string, Annotation annotation, Document document, Map<Integer, List<Annotation>> map, HashMap hashMap, AnnotationSet annotationSet) throws ExecutionException {
        FeatureMap featureMap = Factory.newFeatureMap();
        Long l = annotation.getStartNode().getOffset();
        Long l2 = annotation.getEndNode().getOffset();
        featureMap.clear();
        featureMap.put("majorType", "title");
        AnnotationSet annotationSet2 = annotationSet.getContained(l, l2);
        if (annotationSet2 == null || annotationSet2.isEmpty()) {
            return string;
        }
        AnnotationSet annotationSet3 = annotationSet2.get("Lookup", featureMap);
        if (annotationSet3 != null && !annotationSet3.isEmpty()) {
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationSet3);
            Collections.sort(arrayList, new OffsetComparator());
            for (Annotation annotation2 : arrayList) {
                if (annotation2.getStartNode().getOffset().compareTo(l) != 0) {
                    return string;
                }
                try {
                    String string2 = document.getContent().getContent(annotation2.getStartNode().getOffset(), annotation2.getEndNode().getOffset()).toString();
                    if (string2.length() >= string.length()) continue;
                    ((ArrayList)map.get(annotation.getId())).remove(0);
                    ((ArrayList)hashMap.get(annotation.getId())).remove(0);
                    return string.substring(string2.length() + 1, string.length());
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    throw new ExecutionException("Invalid offset of the annotation");
                }
            }
        }
        return string;
    }

    @Override
    public boolean matchedAlready(Annotation annotation, Annotation annotation2, List list, AnnotationSet annotationSet) {
        List list2 = (List)annotation.getFeatures().get("matches");
        if (list2 == null || list2.isEmpty()) {
            return false;
        }
        return list2.contains(annotation2.getId());
    }

    @Override
    public Annotation updateMatches(Annotation annotation, String string, HashMap hashMap, AnnotationSet annotationSet, List list) {
        Object object;
        FeatureBearer featureBearer = null;
        for (Integer n : hashMap.keySet()) {
            object = (String)hashMap.get(n);
            if (!string.equals(object)) continue;
            Annotation annotation2 = annotationSet.get(n);
            if (annotation2 == null) {
                log.warn((Object)("TempAnnot is null when looking at " + string + " | " + object + " | old id: " + n));
                return null;
            }
            if (!annotation.getType().equals(this.unknownType) && !annotation2.getType().equals(annotation.getType())) continue;
            featureBearer = annotation2;
            break;
        }
        if (featureBearer == null) {
            return null;
        }
        object = (List)featureBearer.getFeatures().get("matches");
        if (object == null || object.isEmpty()) {
            if (object == null) {
                object = new ArrayList<Integer>();
                featureBearer.getFeatures().put("matches", object);
                list.add(object);
            }
            object.add(featureBearer.getId());
            object.add(annotation.getId());
        } else {
            object.add(annotation.getId());
        }
        annotation.getFeatures().put("matches", object);
        return featureBearer;
    }

    @Override
    public void updateMatches(Annotation annotation, Annotation annotation2, List list, AnnotationSet annotationSet) {
        ArrayList<Integer> arrayList = (ArrayList<Integer>)annotation2.getFeatures().get("matches");
        if (arrayList == null || arrayList.isEmpty()) {
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
                annotation2.getFeatures().put("matches", arrayList);
                list.add(arrayList);
            }
            arrayList.add(annotation2.getId());
            arrayList.add(annotation.getId());
        } else {
            arrayList.add(annotation.getId());
        }
        annotation.getFeatures().put("matches", arrayList);
        if (annotation2.getType().equals(this.personType)) {
            String string = (String)annotation2.getFeatures().get("gender");
            String string2 = (String)annotation.getFeatures().get("gender");
            boolean bl = this.isUnknownGender(string);
            boolean bl2 = this.isUnknownGender(string2);
            if (bl && !bl2) {
                annotation2.getFeatures().put("gender", string2);
            } else if (bl2 && !bl) {
                annotation.getFeatures().put("gender", string);
            }
        }
    }

    @Override
    public HashSet buildTables(AnnotationSet annotationSet) {
        FeatureMap featureMap = Factory.newFeatureMap();
        HashSet<String> hashSet = new HashSet<String>();
        if (!this.extLists) {
            featureMap.clear();
            featureMap.put("majorType", "cdg");
            AnnotationSet annotationSet2 = annotationSet.get("Lookup", featureMap);
            if (annotationSet2 == null || annotationSet2.isEmpty()) {
                return hashSet;
            }
            for (Annotation annotation : annotationSet2) {
                Long l = annotation.getStartNode().getOffset();
                Long l2 = annotation.getEndNode().getOffset();
                try {
                    Document document = annotationSet.getDocument();
                    String string = document.getContent().getContent(l, l2).toString();
                    hashSet.add(string);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    invalidOffsetException.printStackTrace(Err.getPrintWriter());
                }
            }
        }
        return hashSet;
    }

    @Override
    public boolean isUnknownGender(String string) {
        if (string == null) {
            return true;
        }
        return !string.equalsIgnoreCase("male") && !string.equalsIgnoreCase("female");
    }

    protected Map<String, HashSet<String>> initNicknames(String string, URL uRL) throws IOException {
        Pattern pattern = Pattern.compile("(\\s+)");
        this.nicknameMap = new HashMap<String, HashSet<String>>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), string));
        String string2 = null;
        boolean bl = false;
        while ((string2 = bufferedReader.readLine()) != null) {
            ArrayList<String> arrayList;
            if (string2.length() == 0 || string2.charAt(0) == '#' || (arrayList = new ArrayList<String>(Arrays.asList(pattern.split(string2.toLowerCase().trim())))).size() != 3 && arrayList.size() != 4 && (arrayList.get(3) != "M" || arrayList.get(3) != "F") || OrthoMatcherHelper.round2Places(Double.valueOf(arrayList.get(2))) < OrthoMatcherHelper.round2Places(this.minimumNicknameLikelihood)) continue;
            if (this.nicknameMap.containsKey(arrayList.get(0))) {
                this.nicknameMap.get(arrayList.get(0)).add(arrayList.get(1));
                continue;
            }
            this.nicknameMap.put(arrayList.get(0), new HashSet<String>(Collections.singleton(arrayList.get(1))));
        }
        return this.nicknameMap;
    }
}

