/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ir;

import gate.Gate;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractProcessingResource;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.ir.IndexException;
import gate.creole.ir.IndexedCorpus;
import gate.creole.ir.QueryResultList;
import gate.creole.ir.Search;
import gate.creole.ir.SearchException;
import gate.gui.MainFrame;
import java.util.List;
import javax.swing.JOptionPane;

public class SearchPR
extends AbstractProcessingResource
implements ProcessingResource {
    private IndexedCorpus corpus = null;
    private String query = null;
    private String searcherClassName = null;
    private QueryResultList resultList = null;
    private int limit = -1;
    private List fieldNames = null;
    private Search searcher = null;

    public Resource init() throws ResourceInstantiationException {
        Resource resource = super.init();
        return resource;
    }

    public void reInit() throws ResourceInstantiationException {
        this.init();
    }

    public void execute() throws ExecutionException {
        if (this.corpus == null) {
            throw new ExecutionException("Corpus is not initialized");
        }
        if (this.query == null) {
            throw new ExecutionException("Query is not initialized");
        }
        if (this.searcher == null) {
            throw new ExecutionException("Searcher is not initialized");
        }
        String string = (String)this.corpus.getFeatures().get("CorpusIndexFeature");
        if (!string.equals("IR")) {
            throw new ExecutionException("This corpus was not indexed by the specified IR");
        }
        try {
            if (this.corpus.getIndexManager() == null) {
                MainFrame.unlockGUI();
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Corpus is not indexed!\nPlease index first this corpus!", "Search Processing", 2);
                return;
            }
            this.fireProgressChanged(0);
            this.resultList = null;
            this.searcher.setCorpus(this.corpus);
            this.resultList = this.searcher.search(this.query, this.limit, this.fieldNames);
            this.fireProcessFinished();
        }
        catch (SearchException searchException) {
            throw new ExecutionException(searchException.getMessage());
        }
        catch (IndexException indexException) {
            throw new ExecutionException(indexException.getMessage());
        }
    }

    public void setCorpus(IndexedCorpus indexedCorpus) {
        this.corpus = indexedCorpus;
    }

    public IndexedCorpus getCorpus() {
        return this.corpus;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public String getQuery() {
        return this.query;
    }

    public void setSearcherClassName(String string) {
        this.searcherClassName = string;
        try {
            this.searcher = (Search)Class.forName(this.searcherClassName, true, Gate.getClassLoader()).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getSearcherClassName() {
        return this.searcher.getClass().getName();
    }

    public void setLimit(Integer n) {
        this.limit = n;
    }

    public Integer getLimit() {
        return new Integer(this.limit);
    }

    public void setFieldNames(List list) {
        this.fieldNames = list;
    }

    public List getFieldNames() {
        return this.fieldNames;
    }

    public QueryResultList getResult() {
        return this.resultList;
    }

    public void setResult(QueryResultList queryResultList) {
        throw new UnsupportedOperationException();
    }
}

