/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.creole.gazetteer.InvalidFormatException;

public class LinearNode {
    private String list;
    private String minor;
    private String major;
    private String language;

    public LinearNode(String string, String string2, String string3, String string4) {
        this.list = string;
        this.minor = string3;
        this.major = string2;
        this.language = string4;
    }

    public LinearNode(String string) throws InvalidFormatException {
        int n = string.indexOf(58);
        int n2 = string.indexOf(58, n + 1);
        int n3 = string.indexOf(58, n2 + 1);
        if (n == -1) {
            throw new InvalidFormatException("", "Line: " + string);
        }
        this.list = string.substring(0, n);
        if (n2 == -1) {
            this.major = string.substring(n + 1);
            this.minor = null;
            this.language = null;
        } else {
            this.major = string.substring(n + 1, n2);
            if (n3 == -1) {
                this.minor = string.substring(n2 + 1);
                this.language = null;
            } else {
                this.minor = string.substring(n2 + 1, n3);
                this.language = string.substring(n3 + 1);
            }
        }
    }

    public String getList() {
        return this.list;
    }

    public void setList(String string) {
        this.list = string;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public String getMinorType() {
        return this.minor;
    }

    public void setMinorType(String string) {
        this.minor = string;
    }

    public String getMajorType() {
        return this.major;
    }

    public void setMajorType(String string) {
        this.major = string;
    }

    public String toString() {
        String string = this.list + ':' + this.major;
        if (null != this.minor && 0 != this.minor.length()) {
            string = string + ':' + this.minor;
        }
        if (null != this.language && 0 != this.language.length()) {
            if (null == this.minor || 0 == this.minor.length()) {
                string = string + ':';
            }
            string = string + ':' + this.language;
        }
        return string;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof LinearNode) {
            LinearNode linearNode = (LinearNode)object;
            bl = true;
            if (null != this.getLanguage()) {
                bl &= this.getLanguage().equals(linearNode.getLanguage());
            }
            if (null != this.getList()) {
                bl &= this.getList().equals(linearNode.getList());
            }
            if (null != this.getMajorType()) {
                bl &= this.getMajorType().equals(linearNode.getMajorType());
            }
            if (null != this.getMinorType()) {
                bl &= this.getMinorType().equals(linearNode.getMinorType());
            }
        }
        return bl;
    }
}

