/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.ProcessingResource;
import gate.Resource;
import gate.corpora.DocumentImpl;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.Gazetteer;
import gate.creole.gazetteer.NodePosition;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FlexibleGazetteer
extends AbstractLanguageAnalyser
implements ProcessingResource {
    private Document document;
    private String outputAnnotationSetName;
    private String inputAnnotationSetName;
    private Gazetteer gazetteerInst;
    private List inputFeatureNames;
    private ArrayList changedNodes = new ArrayList();

    public Resource init() throws ResourceInstantiationException {
        if (this.gazetteerInst == null) {
            throw new ResourceInstantiationException("No Gazetteer Provided!");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws ExecutionException {
        Object object;
        Object object2;
        Object object3;
        this.changedNodes = new ArrayList();
        this.fireProgressChanged(0);
        this.fireStatusChanged("Checking Document...");
        if (this.document == null) {
            throw new ExecutionException("No document to process!");
        }
        this.fireStatusChanged("Creating temporary Document...");
        StringBuffer stringBuffer = new StringBuffer(this.document.getContent().toString());
        Document document = null;
        boolean bl = false;
        if (this.inputFeatureNames == null || this.inputFeatureNames.size() == 0) {
            this.inputFeatureNames = new ArrayList();
        }
        Iterator iterator = this.getTokenIterator(this.document, this.inputAnnotationSetName);
        long l = 0L;
        this.fireStatusChanged("Replacing contents with the feature value...");
        block6: while (iterator != null && iterator.hasNext()) {
            long l2;
            object3 = (Annotation)iterator.next();
            if (object3.getType().equals("SpaceToken") && ((String)object3.getFeatures().get("kind")).equals("ChineseSplit")) {
                long l3 = object3.getStartNode().getOffset();
                long l4 = l3 - l;
                l2 = l4 + 1L;
                NodePosition nodePosition = new NodePosition(l3, l3, l4, l2, l);
                bl = true;
                --l;
                this.changedNodes.add(nodePosition);
                stringBuffer = stringBuffer.insert((int)l4, ' ');
                continue;
            }
            for (int i = 0; i < this.inputFeatureNames.size(); ++i) {
                FeatureMap featureMap;
                String string;
                object2 = ((String)this.inputFeatureNames.get(i)).split("[.]");
                if (((String[])object2).length != 2 || !object3.getType().equals(object2[0]) || (string = (String)(featureMap = object3.getFeatures()).get(object2[1])) == null) continue;
                l2 = object3.getStartNode().getOffset();
                long l5 = object3.getEndNode().getOffset();
                long l6 = l5 - l2;
                long l7 = l6 - (long)string.length();
                long l8 = l2 - l;
                long l9 = l8 + (long)string.length();
                NodePosition nodePosition = new NodePosition(l2, l5, l8, l9, l += l7);
                this.changedNodes.add(nodePosition);
                stringBuffer = stringBuffer.replace((int)l8, (int)l8 + (int)l6, string);
                continue block6;
            }
        }
        this.fireStatusChanged("New Document to be processed with Gazetteer...");
        try {
            object3 = Factory.newFeatureMap();
            object3.put("stringContent", stringBuffer.toString());
            if (this.document instanceof DocumentImpl) {
                object3.put("encoding", ((DocumentImpl)this.document).getEncoding());
                object3.put("markupAware", ((DocumentImpl)this.document).getMarkupAware());
            }
            object = Factory.newFeatureMap();
            document = (Document)Factory.createResource("gate.corpora.DocumentImpl", (FeatureMap)object3, (FeatureMap)object);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new ExecutionException("Temporary document cannot be created");
        }
        object3 = Factory.newFeatureMap();
        this.gazetteerInst.setDocument(document);
        this.gazetteerInst.setAnnotationSetName(this.outputAnnotationSetName);
        this.fireStatusChanged("Executing Gazetteer...");
        try {
            this.gazetteerInst.execute();
            Object var26_27 = null;
        }
        catch (Throwable throwable) {
            Object var26_28 = null;
            this.gazetteerInst.setDocument(null);
            throw throwable;
        }
        this.gazetteerInst.setDocument(null);
        this.fireStatusChanged("Transfering new tags to the original one...");
        object = this.getTokenIterator(document, this.outputAnnotationSetName);
        Object object4 = object2 = this.outputAnnotationSetName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.outputAnnotationSetName);
        while (object != null && object.hasNext()) {
            NodePosition nodePosition;
            NodePosition nodePosition2;
            int n;
            Annotation annotation = (Annotation)object.next();
            long l10 = annotation.getStartNode().getOffset();
            long l11 = annotation.getEndNode().getOffset();
            long l12 = 0L;
            long l13 = 0L;
            for (n = 0; n < this.changedNodes.size(); ++n) {
                nodePosition2 = (NodePosition)this.changedNodes.get(n);
                if (nodePosition2.getNewStartNode() < l10) continue;
                if (nodePosition2.getNewStartNode() == l10) {
                    if (n > 0) {
                        nodePosition = (NodePosition)this.changedNodes.get(n - 1);
                        l12 = nodePosition.getDeductedSpaces();
                        break;
                    }
                    l12 = 0L;
                    break;
                }
                if ((n -= 2) >= 0) {
                    nodePosition = (NodePosition)this.changedNodes.get(n);
                    l12 = nodePosition.getDeductedSpaces();
                    break;
                }
                l12 = 0L;
                break;
            }
            while (n < this.changedNodes.size()) {
                nodePosition2 = (NodePosition)this.changedNodes.get(n);
                if (nodePosition2.getNewEndNode() >= l11) {
                    nodePosition = (NodePosition)this.changedNodes.get(n);
                    l13 = nodePosition.getDeductedSpaces();
                    break;
                }
                ++n;
            }
            try {
                object2.add(new Long(l10 + l12), new Long(l11 + l13), annotation.getType(), annotation.getFeatures());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new ExecutionException(invalidOffsetException);
            }
        }
        Factory.deleteResource(document);
        this.fireProcessFinished();
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setOutputAnnotationSetName(String string) {
        this.outputAnnotationSetName = string;
    }

    public String getOutputAnnotationSetName() {
        return this.outputAnnotationSetName;
    }

    public void setInputAnnotationSetName(String string) {
        this.inputAnnotationSetName = string;
    }

    public String getInputAnnotationSetName() {
        return this.inputAnnotationSetName;
    }

    public void setInputFeatureNames(List list) {
        this.inputFeatureNames = list;
    }

    public List getInputFeatureNames() {
        return this.inputFeatureNames;
    }

    public Gazetteer getGazetteerInst() {
        return this.gazetteerInst;
    }

    public void setGazetteerInst(Gazetteer gazetteer) {
        this.gazetteerInst = gazetteer;
    }

    public Iterator getTokenIterator(Document document, String string) {
        AnnotationSet annotationSet = string == null ? document.getAnnotations() : document.getAnnotations(string);
        AnnotationSet annotationSet2 = annotationSet.get();
        if (annotationSet2 == null) {
            return null;
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationSet.get());
        if (arrayList == null) {
            return null;
        }
        OffsetComparator offsetComparator = new OffsetComparator();
        Collections.sort(arrayList, offsetComparator);
        ListIterator listIterator = arrayList.listIterator();
        return listIterator;
    }
}

