/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.coref;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.FeatureMap;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.coref.PronominalCoref;
import gate.util.GateRuntimeException;
import gate.util.SimpleFeatureMapImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Coreferencer
extends AbstractLanguageAnalyser
implements ProcessingResource {
    public static final String COREF_DOCUMENT_PARAMETER_NAME = "document";
    public static final String COREF_ANN_SET_PARAMETER_NAME = "annotationSetName";
    public static final String COREF_TYPE_FEATURE_NAME = "ENTITY_MENTION_TYPE";
    public static final String COREF_ANTECEDENT_FEATURE_NAME = "antecedent_offset";
    private static final boolean DEBUG = false;
    private PronominalCoref pronominalModule = new PronominalCoref();

    public Resource init() throws ResourceInstantiationException {
        Resource resource = super.init();
        this.pronominalModule.init();
        return resource;
    }

    public void reInit() throws ResourceInstantiationException {
        this.init();
    }

    public void setDocument(Document document) {
        this.pronominalModule.setDocument(document);
        super.setDocument(document);
    }

    public void setAnnotationSetName(String string) {
        this.pronominalModule.setAnnotationSetName(string);
    }

    public String getAnnotationSetName() {
        return this.pronominalModule.getAnnotationSetName();
    }

    public void setResolveIt(Boolean bl) {
        this.pronominalModule.setResolveIt(bl);
    }

    public Boolean getResolveIt() {
        return this.pronominalModule.getResolveIt();
    }

    public void execute() throws ExecutionException {
        this.fireStatusChanged("Pronominal Coreferencer processing: " + this.document.getName());
        this.pronominalModule.execute();
        this.generateCorefChains();
        this.fireStatusChanged("Pronominal Coreferencer completed");
    }

    private void generateCorefChains() throws GateRuntimeException {
        HashMap hashMap = this.pronominalModule.getResolvedAnaphora();
        String string = this.getAnnotationSetName();
        AnnotationSet annotationSet = null;
        annotationSet = null == string || string.equals("") ? this.getDocument().getAnnotations() : this.getDocument().getAnnotations(string);
        for (Map.Entry entry : hashMap.entrySet()) {
            Collection<ArrayList<Integer>> collection;
            Map<Object, Object> map;
            Annotation annotation = (Annotation)entry.getKey();
            Annotation annotation2 = (Annotation)entry.getValue();
            if (null == annotation2) continue;
            ArrayList<Integer> arrayList = (ArrayList<Integer>)annotation2.getFeatures().get("matches");
            if (null == arrayList) {
                arrayList = new ArrayList<Integer>();
                arrayList.add(annotation2.getId());
                annotation2.getFeatures().put("matches", arrayList);
                if (this.document.getFeatures().containsKey("MatchesAnnots")) {
                    map = (Map)this.document.getFeatures().get("MatchesAnnots");
                    collection = (List)map.get(this.getAnnotationSetName());
                    if (collection == null) {
                        collection = new ArrayList();
                        map.put(this.getAnnotationSetName(), collection);
                    }
                    collection.add(arrayList);
                } else {
                    map = new HashMap();
                    collection = new ArrayList();
                    map.put(this.getAnnotationSetName(), collection);
                    collection.add(arrayList);
                }
            }
            map = new SimpleFeatureMapImpl();
            map.put(COREF_TYPE_FEATURE_NAME, "PRONOUN");
            map.put("matches", arrayList);
            map.put(COREF_ANTECEDENT_FEATURE_NAME, annotation2.getStartNode().getOffset());
            collection = annotationSet.get(annotation2.getType(), annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset());
            if (collection.size() > 0) {
                Annotation annotation3 = collection.iterator().next();
                annotation3.getFeatures().putAll(map);
                arrayList.add(annotation3.getId());
                continue;
            }
            arrayList.add(annotationSet.add(annotation.getStartNode(), annotation.getEndNode(), annotation2.getType(), (FeatureMap)map));
        }
    }

    public String getInanimatedEntityTypes() {
        return this.pronominalModule.getInanimatedEntityTypes();
    }

    public void setInanimatedEntityTypes(String string) {
        this.pronominalModule.setInanimatedEntityTypes(string);
    }
}

