/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.test;

import gate.Corpus;
import gate.creole.ExecutionException;
import gate.creole.annic.IndexException;
import gate.creole.annic.lucene.LuceneIndexer;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnicIndexing {
    private static final long serialVersionUID = 3688785860577212210L;
    private Corpus corpus = null;
    private ArrayList<String> featuresToExclude = new ArrayList();
    private URL indexOutputDirectoryLocation;
    private String annotationSetName = "";
    private String baseTokenAnnotationType = "";
    private String indexUnitAnnotationType = "";
    private LuceneIndexer indexer = new LuceneIndexer(null);

    public void execute() throws ExecutionException {
        long l = System.currentTimeMillis();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.getAnnotationSetName());
            hashMap.put("ANNOTATION_SETS_NAMES_TO_INCLUDE", arrayList);
            hashMap.put("ANNOTATION_SETS_NAMES_TO_EXCLUDE", new ArrayList());
            hashMap.put("BASE_TOKEN_ANNOTATION_TYPE", this.getBaseTokenAnnotationType());
            hashMap.put("FEATURES_TO_EXCLUDE", this.getFeaturesToExclude());
            hashMap.put("FEATURES_TO_INCLUDE", new ArrayList());
            hashMap.put("INDEX_UNIT_ANNOTATION_TYPE", this.getIndexUnitAnnotationType());
            hashMap.put("INDEX_LOCATION_URL", this.getIndexOutputDirectoryLocation());
            this.indexer.setCorpus(this.getCorpus());
            this.indexer.createIndex(hashMap);
        }
        catch (IndexException indexException) {
            throw new ExecutionException(indexException);
        }
    }

    public URL getIndexOutputDirectoryLocation() {
        return this.indexOutputDirectoryLocation;
    }

    public void setIndexOutputDirectoryLocation(URL uRL) {
        this.indexOutputDirectoryLocation = uRL;
    }

    public String getAnnotationSetName() {
        return this.annotationSetName;
    }

    public void setAnnotationSetName(String string) {
        if (string != null && string.trim().equals("")) {
            string = null;
        }
        this.annotationSetName = string;
    }

    public String getBaseTokenAnnotationType() {
        return this.baseTokenAnnotationType;
    }

    public void setBaseTokenAnnotationType(String string) {
        this.baseTokenAnnotationType = string;
    }

    public void setCorpus(Corpus corpus) {
        this.corpus = corpus;
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    public List getFeaturesToExclude() {
        return this.featuresToExclude;
    }

    public void setFeaturesToExclude(ArrayList<String> arrayList) {
        this.featuresToExclude = arrayList;
    }

    public String getIndexUnitAnnotationType() {
        return this.indexUnitAnnotationType;
    }

    public void setIndexUnitAnnotationType(String string) {
        this.indexUnitAnnotationType = string;
    }
}

