/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.store;

import gate.creole.annic.apache.lucene.index.IndexWriter;
import java.io.IOException;

public abstract class Lock {
    public static long LOCK_POLL_INTERVAL = 1000L;

    public abstract boolean obtain() throws IOException;

    public boolean obtain(long l) throws IOException {
        boolean bl = this.obtain();
        int n = (int)(l / LOCK_POLL_INTERVAL);
        int n2 = 0;
        while (!bl) {
            if (++n2 == n) {
                throw new IOException("Lock obtain timed out: " + this.toString());
            }
            try {
                Thread.sleep(LOCK_POLL_INTERVAL);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException.toString());
            }
            bl = this.obtain();
        }
        return bl;
    }

    public abstract void release();

    public abstract boolean isLocked();

    public static abstract class With {
        private Lock lock;
        private long lockWaitTimeout;

        public With(Lock lock) {
            this(lock, IndexWriter.COMMIT_LOCK_TIMEOUT);
        }

        public With(Lock lock, long l) {
            this.lock = lock;
            this.lockWaitTimeout = l;
        }

        protected abstract Object doBody() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() throws IOException {
            boolean bl = false;
            try {
                bl = this.lock.obtain(this.lockWaitTimeout);
                Object object = this.doBody();
                Object var4_3 = null;
                if (bl) {
                    this.lock.release();
                }
                return object;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (!bl) break block3;
                    this.lock.release();
                }
                throw throwable;
            }
        }
    }
}

