/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.search.FieldCache;
import gate.creole.annic.apache.lucene.search.FieldCacheImpl;
import gate.creole.annic.apache.lucene.search.FieldDoc;
import gate.creole.annic.apache.lucene.search.ScoreDoc;
import gate.creole.annic.apache.lucene.search.ScoreDocComparator;
import gate.creole.annic.apache.lucene.search.SortComparatorSource;
import gate.creole.annic.apache.lucene.search.SortField;
import gate.creole.annic.apache.lucene.util.PriorityQueue;
import java.io.IOException;
import java.text.Collator;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

class FieldSortedHitQueue
extends PriorityQueue {
    protected ScoreDocComparator[] comparators;
    protected SortField[] fields;
    protected float maxscore = 1.0f;
    static final Map Comparators = new WeakHashMap();

    FieldSortedHitQueue(IndexReader indexReader, SortField[] sortFieldArray, int n) throws IOException {
        int n2 = sortFieldArray.length;
        this.comparators = new ScoreDocComparator[n2];
        this.fields = new SortField[n2];
        for (int i = 0; i < n2; ++i) {
            String string = sortFieldArray[i].getField();
            this.comparators[i] = FieldSortedHitQueue.getCachedComparator(indexReader, string, sortFieldArray[i].getType(), sortFieldArray[i].getLocale(), sortFieldArray[i].getFactory());
            this.fields[i] = new SortField(string, this.comparators[i].sortType(), sortFieldArray[i].getReverse());
        }
        this.initialize(n);
    }

    protected final boolean lessThan(Object object, Object object2) {
        ScoreDoc scoreDoc = (ScoreDoc)object;
        ScoreDoc scoreDoc2 = (ScoreDoc)object2;
        if (scoreDoc.score > this.maxscore) {
            this.maxscore = scoreDoc.score;
        }
        if (scoreDoc2.score > this.maxscore) {
            this.maxscore = scoreDoc2.score;
        }
        int n = this.comparators.length;
        int n2 = 0;
        for (int i = 0; i < n && n2 == 0; ++i) {
            n2 = this.fields[i].reverse ? this.comparators[i].compare(scoreDoc2, scoreDoc) : this.comparators[i].compare(scoreDoc, scoreDoc2);
        }
        return n2 > 0;
    }

    FieldDoc fillFields(FieldDoc fieldDoc) {
        int n = this.comparators.length;
        Comparable[] comparableArray = new Comparable[n];
        for (int i = 0; i < n; ++i) {
            comparableArray[i] = this.comparators[i].sortValue(fieldDoc);
        }
        fieldDoc.fields = comparableArray;
        if (this.maxscore > 1.0f) {
            fieldDoc.score /= this.maxscore;
        }
        return fieldDoc;
    }

    SortField[] getFields() {
        return this.fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ScoreDocComparator lookup(IndexReader indexReader, String string, int n, Object object) {
        FieldCacheImpl.Entry entry = object != null ? new FieldCacheImpl.Entry(indexReader, string, object) : new FieldCacheImpl.Entry(indexReader, string, n);
        Map map = Comparators;
        synchronized (map) {
            return (ScoreDocComparator)Comparators.get(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object store(IndexReader indexReader, String string, int n, Object object, Object object2) {
        FieldCacheImpl.Entry entry = object != null ? new FieldCacheImpl.Entry(indexReader, string, object) : new FieldCacheImpl.Entry(indexReader, string, n);
        Map map = Comparators;
        synchronized (map) {
            return Comparators.put(entry, object2);
        }
    }

    static ScoreDocComparator getCachedComparator(IndexReader indexReader, String string, int n, Locale locale, SortComparatorSource sortComparatorSource) throws IOException {
        if (n == 1) {
            return ScoreDocComparator.INDEXORDER;
        }
        if (n == 0) {
            return ScoreDocComparator.RELEVANCE;
        }
        ScoreDocComparator scoreDocComparator = FieldSortedHitQueue.lookup(indexReader, string, n, sortComparatorSource);
        if (scoreDocComparator == null) {
            switch (n) {
                case 2: {
                    scoreDocComparator = FieldSortedHitQueue.comparatorAuto(indexReader, string);
                    break;
                }
                case 4: {
                    scoreDocComparator = FieldSortedHitQueue.comparatorInt(indexReader, string);
                    break;
                }
                case 5: {
                    scoreDocComparator = FieldSortedHitQueue.comparatorFloat(indexReader, string);
                    break;
                }
                case 3: {
                    if (locale != null) {
                        scoreDocComparator = FieldSortedHitQueue.comparatorStringLocale(indexReader, string, locale);
                        break;
                    }
                    scoreDocComparator = FieldSortedHitQueue.comparatorString(indexReader, string);
                    break;
                }
                case 9: {
                    scoreDocComparator = sortComparatorSource.newComparator(indexReader, string);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown field type: " + n);
                }
            }
            FieldSortedHitQueue.store(indexReader, string, n, sortComparatorSource, scoreDocComparator);
        }
        return scoreDocComparator;
    }

    static ScoreDocComparator comparatorInt(final IndexReader indexReader, String string) throws IOException {
        final String string2 = string.intern();
        return new ScoreDocComparator(){
            final int[] fieldOrder;
            {
                this.fieldOrder = FieldCache.DEFAULT.getInts(indexReader, string2);
            }

            public final int compare(ScoreDoc scoreDoc, ScoreDoc scoreDoc2) {
                int n = this.fieldOrder[scoreDoc.doc];
                int n2 = this.fieldOrder[scoreDoc2.doc];
                if (n < n2) {
                    return -1;
                }
                if (n > n2) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc scoreDoc) {
                return new Integer(this.fieldOrder[scoreDoc.doc]);
            }

            public int sortType() {
                return 4;
            }
        };
    }

    static ScoreDocComparator comparatorFloat(final IndexReader indexReader, String string) throws IOException {
        final String string2 = string.intern();
        return new ScoreDocComparator(){
            protected final float[] fieldOrder;
            {
                this.fieldOrder = FieldCache.DEFAULT.getFloats(indexReader, string2);
            }

            public final int compare(ScoreDoc scoreDoc, ScoreDoc scoreDoc2) {
                float f = this.fieldOrder[scoreDoc.doc];
                float f2 = this.fieldOrder[scoreDoc2.doc];
                if (f < f2) {
                    return -1;
                }
                if (f > f2) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc scoreDoc) {
                return new Float(this.fieldOrder[scoreDoc.doc]);
            }

            public int sortType() {
                return 5;
            }
        };
    }

    static ScoreDocComparator comparatorString(final IndexReader indexReader, String string) throws IOException {
        final String string2 = string.intern();
        return new ScoreDocComparator(){
            final FieldCache.StringIndex index;
            {
                this.index = FieldCache.DEFAULT.getStringIndex(indexReader, string2);
            }

            public final int compare(ScoreDoc scoreDoc, ScoreDoc scoreDoc2) {
                int n = this.index.order[scoreDoc.doc];
                int n2 = this.index.order[scoreDoc2.doc];
                if (n < n2) {
                    return -1;
                }
                if (n > n2) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc scoreDoc) {
                return this.index.lookup[this.index.order[scoreDoc.doc]];
            }

            public int sortType() {
                return 3;
            }
        };
    }

    static ScoreDocComparator comparatorStringLocale(final IndexReader indexReader, String string, Locale locale) throws IOException {
        final Collator collator = Collator.getInstance(locale);
        final String string2 = string.intern();
        return new ScoreDocComparator(){
            final String[] index;
            {
                this.index = FieldCache.DEFAULT.getStrings(indexReader, string2);
            }

            public final int compare(ScoreDoc scoreDoc, ScoreDoc scoreDoc2) {
                return collator.compare(this.index[scoreDoc.doc], this.index[scoreDoc2.doc]);
            }

            public Comparable sortValue(ScoreDoc scoreDoc) {
                return this.index[scoreDoc.doc];
            }

            public int sortType() {
                return 3;
            }
        };
    }

    static ScoreDocComparator comparatorAuto(IndexReader indexReader, String string) throws IOException {
        String string2 = string.intern();
        Object object = FieldCache.DEFAULT.getAuto(indexReader, string2);
        if (object instanceof FieldCache.StringIndex) {
            return FieldSortedHitQueue.comparatorString(indexReader, string2);
        }
        if (object instanceof int[]) {
            return FieldSortedHitQueue.comparatorInt(indexReader, string2);
        }
        if (object instanceof float[]) {
            return FieldSortedHitQueue.comparatorFloat(indexReader, string2);
        }
        if (object instanceof String[]) {
            return FieldSortedHitQueue.comparatorString(indexReader, string2);
        }
        throw new RuntimeException("unknown data type in field '" + string2 + "'");
    }
}

