/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.FieldInfos;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermInfo;
import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.OutputStream;
import java.io.IOException;

final class TermInfosWriter {
    public static final int FORMAT = -2;
    private FieldInfos fieldInfos;
    private OutputStream output;
    private Term lastTerm = new Term("", "", "");
    private TermInfo lastTi = new TermInfo();
    private long size = 0L;
    int indexInterval = 128;
    int skipInterval = 16;
    private long lastIndexPointer = 0L;
    private boolean isIndex = false;
    private TermInfosWriter other = null;

    TermInfosWriter(Directory directory, String string, FieldInfos fieldInfos) throws IOException {
        this.initialize(directory, string, fieldInfos, false);
        this.other = new TermInfosWriter(directory, string, fieldInfos, true);
        this.other.other = this;
    }

    private TermInfosWriter(Directory directory, String string, FieldInfos fieldInfos, boolean bl) throws IOException {
        this.initialize(directory, string, fieldInfos, bl);
    }

    private void initialize(Directory directory, String string, FieldInfos fieldInfos, boolean bl) throws IOException {
        this.fieldInfos = fieldInfos;
        this.isIndex = bl;
        this.output = directory.createFile(string + (this.isIndex ? ".tii" : ".tis"));
        this.output.writeInt(-2);
        this.output.writeLong(0L);
        this.output.writeInt(this.indexInterval);
        this.output.writeInt(this.skipInterval);
    }

    final void add(Term term, TermInfo termInfo) throws IOException {
        int n = term.compareTo(this.lastTerm);
        if (!this.isIndex && n <= 0) {
            throw new IOException("term out of order");
        }
        if (termInfo.freqPointer < this.lastTi.freqPointer) {
            throw new IOException("freqPointer out of order");
        }
        if (termInfo.proxPointer < this.lastTi.proxPointer) {
            throw new IOException("proxPointer out of order");
        }
        if (!this.isIndex && this.size % (long)this.indexInterval == 0L) {
            this.other.add(this.lastTerm, this.lastTi);
        }
        this.writeTerm(term);
        this.output.writeVInt(termInfo.docFreq);
        this.output.writeVLong(termInfo.freqPointer - this.lastTi.freqPointer);
        this.output.writeVLong(termInfo.proxPointer - this.lastTi.proxPointer);
        if (termInfo.docFreq >= this.skipInterval) {
            this.output.writeVInt(termInfo.skipOffset);
        }
        if (this.isIndex) {
            this.output.writeVLong(this.other.output.getFilePointer() - this.lastIndexPointer);
            this.lastIndexPointer = this.other.output.getFilePointer();
        }
        this.lastTi.set(termInfo);
        ++this.size;
    }

    private final void writeTerm(Term term) throws IOException {
        int n = term.text.length();
        this.output.writeVInt(n);
        this.output.writeChars(term.text, 0, n);
        if (term.type == null) {
            term.type = "word";
        }
        n = term.type.length();
        this.output.writeVInt(n);
        this.output.writeChars(term.type, 0, n);
        this.output.writeVInt(this.fieldInfos.fieldNumber(term.field));
        this.lastTerm = term;
    }

    final void close() throws IOException {
        this.output.seek(4L);
        this.output.writeLong(this.size);
        this.output.close();
        if (!this.isIndex) {
            this.other.close();
        }
    }
}

