/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.analysis.Analyzer;
import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.index.DocumentWriter;
import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.SegmentInfo;
import gate.creole.annic.apache.lucene.index.SegmentInfos;
import gate.creole.annic.apache.lucene.index.SegmentMerger;
import gate.creole.annic.apache.lucene.index.SegmentReader;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.FSDirectory;
import gate.creole.annic.apache.lucene.store.InputStream;
import gate.creole.annic.apache.lucene.store.Lock;
import gate.creole.annic.apache.lucene.store.OutputStream;
import gate.creole.annic.apache.lucene.store.RAMDirectory;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;

public class IndexWriter {
    public static long WRITE_LOCK_TIMEOUT = Integer.parseInt(System.getProperty("gate.creole.annic.apache.lucene.writeLockTimeout", "1000"));
    public static long COMMIT_LOCK_TIMEOUT = Integer.parseInt(System.getProperty("gate.creole.annic.apache.lucene.commitLockTimeout", "10000"));
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final String COMMIT_LOCK_NAME = "commit.lock";
    public static final int DEFAULT_MERGE_FACTOR = Integer.parseInt(System.getProperty("gate.creole.annic.apache.lucene.mergeFactor", "10"));
    public static final int DEFAULT_MIN_MERGE_DOCS = Integer.parseInt(System.getProperty("gate.creole.annic.apache.lucene.minMergeDocs", "10"));
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.parseInt(System.getProperty("gate.creole.annic.apache.lucene.maxMergeDocs", String.valueOf(Integer.MAX_VALUE)));
    public static final int DEFAULT_MAX_FIELD_LENGTH = Integer.parseInt(System.getProperty("gate.creole.annic.apache.lucene.maxFieldLength", "300000"));
    private Directory directory;
    private Analyzer analyzer;
    private Similarity similarity = Similarity.getDefault();
    private SegmentInfos segmentInfos = new SegmentInfos();
    private final Directory ramDirectory = new RAMDirectory();
    private Lock writeLock;
    private boolean useCompoundFile = true;
    private boolean closeDir;
    public int maxFieldLength = DEFAULT_MAX_FIELD_LENGTH;
    public int mergeFactor = DEFAULT_MERGE_FACTOR;
    public int minMergeDocs = DEFAULT_MIN_MERGE_DOCS;
    public int maxMergeDocs = DEFAULT_MAX_MERGE_DOCS;
    public PrintStream infoStream = null;

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public void setUseCompoundFile(boolean bl) {
        this.useCompoundFile = bl;
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public IndexWriter(String string, Analyzer analyzer, boolean bl) throws IOException {
        this(FSDirectory.getDirectory(string, bl), analyzer, bl, true);
    }

    public IndexWriter(File file, Analyzer analyzer, boolean bl) throws IOException {
        this(FSDirectory.getDirectory(file, bl), analyzer, bl, true);
    }

    public IndexWriter(Directory directory, Analyzer analyzer, boolean bl) throws IOException {
        this(directory, analyzer, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexWriter(Directory directory, Analyzer analyzer, final boolean bl, boolean bl2) throws IOException {
        this.closeDir = bl2;
        this.directory = directory;
        this.analyzer = analyzer;
        Lock lock = this.directory.makeLock(WRITE_LOCK_NAME);
        if (!lock.obtain(WRITE_LOCK_TIMEOUT)) {
            throw new IOException("Index locked for write: " + lock);
        }
        this.writeLock = lock;
        Directory directory2 = this.directory;
        synchronized (directory2) {
            new Lock.With(this.directory.makeLock(COMMIT_LOCK_NAME), COMMIT_LOCK_TIMEOUT){

                public Object doBody() throws IOException {
                    if (bl) {
                        IndexWriter.this.segmentInfos.write(IndexWriter.this.directory);
                    } else {
                        IndexWriter.this.segmentInfos.read(IndexWriter.this.directory);
                    }
                    return null;
                }
            }.run();
        }
    }

    public synchronized void close() throws IOException {
        this.flushRamSegments();
        this.ramDirectory.close();
        this.writeLock.release();
        this.writeLock = null;
        if (this.closeDir) {
            this.directory.close();
        }
    }

    protected void finalize() throws IOException {
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public synchronized int docCount() {
        int n = 0;
        for (int i = 0; i < this.segmentInfos.size(); ++i) {
            SegmentInfo segmentInfo = this.segmentInfos.info(i);
            n += segmentInfo.docCount;
        }
        return n;
    }

    public void addDocument(Document document) throws IOException {
        this.addDocument(document, this.analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Document document, Analyzer analyzer) throws IOException {
        DocumentWriter documentWriter = new DocumentWriter(this.ramDirectory, analyzer, this.similarity, this.maxFieldLength);
        String string = this.newSegmentName();
        documentWriter.addDocument(string, document);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.segmentInfos.addElement(new SegmentInfo(string, 1, this.ramDirectory));
            this.maybeMergeSegments();
        }
    }

    final int getSegmentsCounter() {
        return this.segmentInfos.counter;
    }

    private final synchronized String newSegmentName() {
        return "_" + Integer.toString(this.segmentInfos.counter++, 36);
    }

    public synchronized void optimize() throws IOException {
        this.flushRamSegments();
        while (this.segmentInfos.size() > 1 || this.segmentInfos.size() == 1 && (SegmentReader.hasDeletions(this.segmentInfos.info(0)) || this.segmentInfos.info((int)0).dir != this.directory || this.useCompoundFile && (!SegmentReader.usesCompoundFile(this.segmentInfos.info(0)) || SegmentReader.hasSeparateNorms(this.segmentInfos.info(0))))) {
            int n = this.segmentInfos.size() - this.mergeFactor;
            this.mergeSegments(n < 0 ? 0 : n);
        }
    }

    public synchronized void addIndexes(Directory[] directoryArray) throws IOException {
        this.optimize();
        for (int i = 0; i < directoryArray.length; ++i) {
            SegmentInfos segmentInfos = new SegmentInfos();
            segmentInfos.read(directoryArray[i]);
            for (int j = 0; j < segmentInfos.size(); ++j) {
                this.segmentInfos.addElement(segmentInfos.info(j));
            }
        }
        this.optimize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addIndexes(IndexReader[] indexReaderArray) throws IOException {
        int n;
        this.optimize();
        String string = this.newSegmentName();
        SegmentMerger segmentMerger = new SegmentMerger(this.directory, string, false);
        if (this.segmentInfos.size() == 1) {
            segmentMerger.add(new SegmentReader(this.segmentInfos.info(0)));
        }
        for (n = 0; n < indexReaderArray.length; ++n) {
            segmentMerger.add(indexReaderArray[n]);
        }
        n = segmentMerger.merge();
        this.segmentInfos.setSize(0);
        this.segmentInfos.addElement(new SegmentInfo(string, n, this.directory));
        Directory directory = this.directory;
        synchronized (directory) {
            new Lock.With(this.directory.makeLock(COMMIT_LOCK_NAME), COMMIT_LOCK_TIMEOUT){

                public Object doBody() throws IOException {
                    IndexWriter.this.segmentInfos.write(IndexWriter.this.directory);
                    return null;
                }
            }.run();
        }
    }

    private final void flushRamSegments() throws IOException {
        int n;
        int n2 = 0;
        for (n = this.segmentInfos.size() - 1; n >= 0 && this.segmentInfos.info((int)n).dir == this.ramDirectory; --n) {
            n2 += this.segmentInfos.info((int)n).docCount;
        }
        if (n < 0 || n2 + this.segmentInfos.info((int)n).docCount > this.mergeFactor || this.segmentInfos.info((int)(this.segmentInfos.size() - 1)).dir != this.ramDirectory) {
            ++n;
        }
        if (n >= this.segmentInfos.size()) {
            return;
        }
        this.mergeSegments(n);
    }

    private final void maybeMergeSegments() throws IOException {
        for (long i = (long)this.minMergeDocs; i <= (long)this.maxMergeDocs; i *= (long)this.mergeFactor) {
            int n = this.segmentInfos.size();
            int n2 = 0;
            while (--n >= 0) {
                SegmentInfo segmentInfo = this.segmentInfos.info(n);
                if ((long)segmentInfo.docCount >= i) break;
                n2 += segmentInfo.docCount;
            }
            if ((long)n2 < i) break;
            this.mergeSegments(n + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeSegments(int n) throws IOException {
        Object object;
        int n2;
        String string = this.newSegmentName();
        if (this.infoStream != null) {
            this.infoStream.print("merging segments");
        }
        SegmentMerger segmentMerger = new SegmentMerger(this.directory, string, this.useCompoundFile);
        final Vector<SegmentReader> vector = new Vector<SegmentReader>();
        for (n2 = n; n2 < this.segmentInfos.size(); ++n2) {
            object = this.segmentInfos.info(n2);
            if (this.infoStream != null) {
                this.infoStream.print(" " + ((SegmentInfo)object).name + " (" + ((SegmentInfo)object).docCount + " docs)");
            }
            SegmentReader segmentReader = new SegmentReader((SegmentInfo)object);
            segmentMerger.add(segmentReader);
            if (segmentReader.directory() != this.directory && segmentReader.directory() != this.ramDirectory) continue;
            vector.addElement(segmentReader);
        }
        n2 = segmentMerger.merge();
        if (this.infoStream != null) {
            this.infoStream.println(" into " + string + " (" + n2 + " docs)");
        }
        this.segmentInfos.setSize(n);
        this.segmentInfos.addElement(new SegmentInfo(string, n2, this.directory));
        segmentMerger.closeReaders();
        object = this.directory;
        synchronized (object) {
            new Lock.With(this.directory.makeLock(COMMIT_LOCK_NAME), COMMIT_LOCK_TIMEOUT){

                public Object doBody() throws IOException {
                    IndexWriter.this.segmentInfos.write(IndexWriter.this.directory);
                    IndexWriter.this.deleteSegments(vector);
                    return null;
                }
            }.run();
        }
    }

    private final void deleteSegments(Vector vector) throws IOException {
        Vector vector2 = new Vector();
        this.deleteFiles(this.readDeleteableFiles(), vector2);
        for (int i = 0; i < vector.size(); ++i) {
            SegmentReader segmentReader = (SegmentReader)vector.elementAt(i);
            if (segmentReader.directory() == this.directory) {
                this.deleteFiles(segmentReader.files(), vector2);
                continue;
            }
            this.deleteFiles(segmentReader.files(), segmentReader.directory());
        }
        this.writeDeleteableFiles(vector2);
    }

    private final void deleteFiles(Vector vector, Directory directory) throws IOException {
        for (int i = 0; i < vector.size(); ++i) {
            directory.deleteFile((String)vector.elementAt(i));
        }
    }

    private final void deleteFiles(Vector vector, Vector vector2) throws IOException {
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            try {
                this.directory.deleteFile(string);
                continue;
            }
            catch (IOException iOException) {
                if (!this.directory.fileExists(string)) continue;
                if (this.infoStream != null) {
                    this.infoStream.println(iOException.getMessage() + "; Will re-try later.");
                }
                vector2.addElement(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Vector readDeleteableFiles() throws IOException {
        Vector<String> vector = new Vector<String>();
        if (!this.directory.fileExists("deletable")) {
            return vector;
        }
        InputStream inputStream = this.directory.openFile("deletable");
        try {
            for (int i = inputStream.readInt(); i > 0; --i) {
                vector.addElement(inputStream.readString());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeDeleteableFiles(Vector vector) throws IOException {
        OutputStream outputStream = this.directory.createFile("deleteable.new");
        try {
            outputStream.writeInt(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                outputStream.writeString((String)vector.elementAt(i));
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
        this.directory.renameFile("deleteable.new", "deletable");
    }
}

