/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.index.IndexWriter;
import gate.creole.annic.apache.lucene.index.MultiReader;
import gate.creole.annic.apache.lucene.index.SegmentInfos;
import gate.creole.annic.apache.lucene.index.SegmentReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermDocs;
import gate.creole.annic.apache.lucene.index.TermEnum;
import gate.creole.annic.apache.lucene.index.TermFreqVector;
import gate.creole.annic.apache.lucene.index.TermPositions;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.FSDirectory;
import gate.creole.annic.apache.lucene.store.Lock;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public abstract class IndexReader {
    private final Directory directory;
    private final boolean directoryOwner;
    private final SegmentInfos segmentInfos;
    private Lock writeLock;
    private boolean stale;
    private boolean hasChanges;
    private final boolean closeDirectory;

    protected IndexReader(Directory directory) {
        this.directory = directory;
        this.segmentInfos = null;
        this.directoryOwner = false;
        this.closeDirectory = false;
        this.stale = false;
        this.hasChanges = false;
        this.writeLock = null;
    }

    IndexReader(Directory directory, SegmentInfos segmentInfos, boolean bl) {
        this.directory = directory;
        this.segmentInfos = segmentInfos;
        this.directoryOwner = true;
        this.closeDirectory = bl;
        this.stale = false;
        this.hasChanges = false;
        this.writeLock = null;
    }

    public static IndexReader open(String string) throws IOException {
        return IndexReader.open(FSDirectory.getDirectory(string, false), true);
    }

    public static IndexReader open(File file) throws IOException {
        return IndexReader.open(FSDirectory.getDirectory(file, false), true);
    }

    public static IndexReader open(Directory directory) throws IOException {
        return IndexReader.open(directory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexReader open(final Directory directory, final boolean bl) throws IOException {
        Directory directory2 = directory;
        synchronized (directory2) {
            return (IndexReader)new Lock.With(directory.makeLock("commit.lock"), IndexWriter.COMMIT_LOCK_TIMEOUT){

                public Object doBody() throws IOException {
                    SegmentInfos segmentInfos = new SegmentInfos();
                    segmentInfos.read(directory);
                    if (segmentInfos.size() == 1) {
                        return new SegmentReader(segmentInfos, segmentInfos.info(0), bl);
                    }
                    IndexReader[] indexReaderArray = new IndexReader[segmentInfos.size()];
                    for (int i = 0; i < segmentInfos.size(); ++i) {
                        indexReaderArray[i] = new SegmentReader(segmentInfos.info(i));
                    }
                    return new MultiReader(directory, segmentInfos, bl, indexReaderArray);
                }
            }.run();
        }
    }

    public Directory directory() {
        return this.directory;
    }

    public static long lastModified(String string) throws IOException {
        return IndexReader.lastModified(new File(string));
    }

    public static long lastModified(File file) throws IOException {
        return FSDirectory.fileModified(file, "segments");
    }

    public static long lastModified(Directory directory) throws IOException {
        return directory.fileModified("segments");
    }

    public static long getCurrentVersion(String string) throws IOException {
        return IndexReader.getCurrentVersion(new File(string));
    }

    public static long getCurrentVersion(File file) throws IOException {
        FSDirectory fSDirectory = FSDirectory.getDirectory(file, false);
        long l = IndexReader.getCurrentVersion(fSDirectory);
        ((Directory)fSDirectory).close();
        return l;
    }

    public static long getCurrentVersion(Directory directory) throws IOException {
        return SegmentInfos.readCurrentVersion(directory);
    }

    public abstract TermFreqVector[] getTermFreqVectors(int var1) throws IOException;

    public abstract TermFreqVector getTermFreqVector(int var1, String var2) throws IOException;

    public static boolean indexExists(String string) {
        return new File(string, "segments").exists();
    }

    public static boolean indexExists(File file) {
        return new File(file, "segments").exists();
    }

    public static boolean indexExists(Directory directory) throws IOException {
        return directory.fileExists("segments");
    }

    public abstract int numDocs();

    public abstract int maxDoc();

    public abstract Document document(int var1) throws IOException;

    public abstract boolean isDeleted(int var1);

    public abstract boolean hasDeletions();

    public abstract byte[] norms(String var1) throws IOException;

    public abstract void norms(String var1, byte[] var2, int var3) throws IOException;

    public final synchronized void setNorm(int n, String string, byte by) throws IOException {
        if (this.directoryOwner) {
            this.aquireWriteLock();
        }
        this.doSetNorm(n, string, by);
        this.hasChanges = true;
    }

    protected abstract void doSetNorm(int var1, String var2, byte var3) throws IOException;

    public void setNorm(int n, String string, float f) throws IOException {
        this.setNorm(n, string, Similarity.encodeNorm(f));
    }

    public abstract TermEnum terms() throws IOException;

    public abstract TermEnum terms(Term var1) throws IOException;

    public abstract int docFreq(Term var1) throws IOException;

    public TermDocs termDocs(Term term) throws IOException {
        TermDocs termDocs = this.termDocs();
        termDocs.seek(term);
        return termDocs;
    }

    public abstract TermDocs termDocs() throws IOException;

    public TermPositions termPositions(Term term) throws IOException {
        TermPositions termPositions = this.termPositions();
        termPositions.seek(term);
        return termPositions;
    }

    public abstract TermPositions termPositions() throws IOException;

    private void aquireWriteLock() throws IOException {
        if (this.stale) {
            throw new IOException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
        }
        if (this.writeLock == null) {
            Lock lock = this.directory.makeLock("write.lock");
            if (!lock.obtain(IndexWriter.WRITE_LOCK_TIMEOUT)) {
                throw new IOException("Index locked for write: " + lock);
            }
            this.writeLock = lock;
            if (SegmentInfos.readCurrentVersion(this.directory) > this.segmentInfos.getVersion()) {
                this.stale = true;
                this.writeLock.release();
                this.writeLock = null;
                throw new IOException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
            }
        }
    }

    public final synchronized void delete(int n) throws IOException {
        if (this.directoryOwner) {
            this.aquireWriteLock();
        }
        this.doDelete(n);
        this.hasChanges = true;
    }

    protected abstract void doDelete(int var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int delete(Term term) throws IOException {
        TermDocs termDocs = this.termDocs(term);
        if (termDocs == null) {
            return 0;
        }
        int n = 0;
        try {
            while (termDocs.next()) {
                this.delete(termDocs.doc());
                ++n;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            termDocs.close();
            throw throwable;
        }
        termDocs.close();
        return n;
    }

    public final synchronized void undeleteAll() throws IOException {
        if (this.directoryOwner) {
            this.aquireWriteLock();
        }
        this.doUndeleteAll();
        this.hasChanges = true;
    }

    protected abstract void doUndeleteAll() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void commit() throws IOException {
        if (this.hasChanges) {
            if (this.directoryOwner) {
                Directory directory = this.directory;
                synchronized (directory) {
                    new Lock.With(this.directory.makeLock("commit.lock"), IndexWriter.COMMIT_LOCK_TIMEOUT){

                        public Object doBody() throws IOException {
                            IndexReader.this.doCommit();
                            IndexReader.this.segmentInfos.write(IndexReader.this.directory);
                            return null;
                        }
                    }.run();
                }
                if (this.writeLock != null) {
                    this.writeLock.release();
                    this.writeLock = null;
                }
            } else {
                this.doCommit();
            }
        }
        this.hasChanges = false;
    }

    protected abstract void doCommit() throws IOException;

    public final synchronized void close() throws IOException {
        this.commit();
        this.doClose();
        if (this.closeDirectory) {
            this.directory.close();
        }
    }

    protected abstract void doClose() throws IOException;

    protected final void finalize() throws IOException {
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    public abstract Collection getFieldNames() throws IOException;

    public abstract Collection getFieldNames(boolean var1) throws IOException;

    public abstract Collection getIndexedFieldNames(boolean var1);

    public static boolean isLocked(Directory directory) throws IOException {
        return directory.makeLock("write.lock").isLocked() || directory.makeLock("commit.lock").isLocked();
    }

    public static boolean isLocked(String string) throws IOException {
        FSDirectory fSDirectory = FSDirectory.getDirectory(string, false);
        boolean bl = IndexReader.isLocked(fSDirectory);
        ((Directory)fSDirectory).close();
        return bl;
    }

    public static void unlock(Directory directory) throws IOException {
        directory.makeLock("write.lock").release();
        directory.makeLock("commit.lock").release();
    }
}

