/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.document.Field;
import gate.creole.annic.apache.lucene.index.FieldInfo;
import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.InputStream;
import gate.creole.annic.apache.lucene.store.OutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

final class FieldInfos {
    private Vector byNumber = new Vector();
    private Hashtable byName = new Hashtable();

    FieldInfos() {
        this.add("", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldInfos(Directory directory, String string) throws IOException {
        InputStream inputStream = directory.openFile(string);
        try {
            this.read(inputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public void add(Document document) {
        Enumeration enumeration = document.fields();
        while (enumeration.hasMoreElements()) {
            Field field = (Field)enumeration.nextElement();
            this.add(field.name(), field.isIndexed(), field.isTermVectorStored());
        }
    }

    public void addIndexed(Collection collection, boolean bl) {
        Iterator iterator = collection.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            this.add((String)iterator.next(), true, bl);
        }
    }

    public void add(Collection collection, boolean bl) {
        Iterator iterator = collection.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            this.add((String)iterator.next(), bl);
        }
    }

    public void add(String string, boolean bl) {
        this.add(string, bl, false);
    }

    public void add(String string, boolean bl, boolean bl2) {
        FieldInfo fieldInfo = this.fieldInfo(string);
        if (fieldInfo == null) {
            this.addInternal(string, bl, bl2);
        } else {
            if (fieldInfo.isIndexed != bl) {
                fieldInfo.isIndexed = true;
            }
            if (fieldInfo.storeTermVector != bl2) {
                fieldInfo.storeTermVector = true;
            }
        }
    }

    private void addInternal(String string, boolean bl, boolean bl2) {
        FieldInfo fieldInfo = new FieldInfo(string, bl, this.byNumber.size(), bl2);
        this.byNumber.addElement(fieldInfo);
        this.byName.put(string, fieldInfo);
    }

    public int fieldNumber(String string) {
        FieldInfo fieldInfo = this.fieldInfo(string);
        if (fieldInfo != null) {
            return fieldInfo.number;
        }
        return -1;
    }

    public FieldInfo fieldInfo(String string) {
        return (FieldInfo)this.byName.get(string);
    }

    public String fieldName(int n) {
        return this.fieldInfo((int)n).name;
    }

    public FieldInfo fieldInfo(int n) {
        return (FieldInfo)this.byNumber.elementAt(n);
    }

    public int size() {
        return this.byNumber.size();
    }

    public boolean hasVectors() {
        boolean bl = false;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.fieldInfo((int)i).storeTermVector) continue;
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Directory directory, String string) throws IOException {
        OutputStream outputStream = directory.createFile(string);
        try {
            this.write(outputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.writeVInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            FieldInfo fieldInfo = this.fieldInfo(i);
            byte by = 0;
            if (fieldInfo.isIndexed) {
                by = (byte)(by | 1);
            }
            if (fieldInfo.storeTermVector) {
                by = (byte)(by | 2);
            }
            outputStream.writeString(fieldInfo.name);
            outputStream.writeByte(by);
        }
    }

    private void read(InputStream inputStream) throws IOException {
        int n = inputStream.readVInt();
        for (int i = 0; i < n; ++i) {
            String string = inputStream.readString().intern();
            byte by = inputStream.readByte();
            boolean bl = (by & 1) != 0;
            boolean bl2 = (by & 2) != 0;
            this.addInternal(string, bl, bl2);
        }
    }
}

