/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Factory;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.AbstractProcessingResource;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.ontology.Ontology;
import gate.gui.ActionsPublisher;
import gate.gui.MainFrame;
import gate.jape.Batch;
import gate.jape.JapeException;
import gate.jape.constraint.AnnotationAccessor;
import gate.jape.constraint.ConstraintPredicate;
import gate.swing.XJFileChooser;
import gate.util.Benchmarkable;
import gate.util.Err;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transducer
extends AbstractLanguageAnalyser
implements ActionsPublisher,
Benchmarkable {
    public static final String TRANSD_DOCUMENT_PARAMETER_NAME = "document";
    public static final String TRANSD_INPUT_AS_PARAMETER_NAME = "inputASName";
    public static final String TRANSD_OUTPUT_AS_PARAMETER_NAME = "outputASName";
    public static final String TRANSD_ENCODING_PARAMETER_NAME = "encoding";
    public static final String TRANSD_GRAMMAR_URL_PARAMETER_NAME = "grammarURL";
    public static final String TRANSD_BINARY_GRAMMAR_URL_PARAMETER_NAME = "binaryGrammarURL";
    public static final String TRANSD_OPERATORS_PARAMETER_NAME = "operators";
    public static final String TRANSD_ANNOTATION_ACCESSORS_PARAMETER_NAME = "annotationAccessors";
    protected List<Action> actionList = new ArrayList<Action>();
    protected URL grammarURL;
    protected URL binaryGrammarURL;
    protected Batch batch;
    protected String encoding;
    protected String inputASName;
    protected String outputASName;
    protected Ontology ontology;
    protected List<String> operators = null;
    protected List<String> annotationAccessors = null;
    protected Boolean enableDebugging;

    public Transducer() {
        this.actionList.add(null);
        this.actionList.add(new SerializeTransducerAction());
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        block11: {
            try {
                this.fireProgressChanged(0);
                this.initCustomConstraints();
                if (this.binaryGrammarURL != null) {
                    ObjectInputStream objectInputStream = new ObjectInputStream(this.binaryGrammarURL.openStream());
                    this.batch = (Batch)objectInputStream.readObject();
                    break block11;
                }
                if (this.grammarURL != null) {
                    if (this.encoding != null) {
                        this.batch = new Batch(this.grammarURL, this.encoding, new AbstractProcessingResource.InternalStatusListener());
                        if (this.enableDebugging != null) {
                            this.batch.setEnableDebugging(this.enableDebugging);
                        } else {
                            this.batch.setEnableDebugging(false);
                        }
                        this.batch.setOntology(this.ontology);
                        break block11;
                    }
                    throw new ResourceInstantiationException("encoding is not set!");
                }
                throw new ResourceInstantiationException("Neither grammarURL or binaryGrammarURL parameters are set!");
            }
            catch (Exception exception) {
                String string = "Error while parsing the grammar ";
                if (this.grammarURL != null) {
                    string = string + "(" + this.grammarURL.toExternalForm() + ")";
                }
                string = string + ":";
                throw new ResourceInstantiationException(string, exception);
            }
            finally {
                this.fireProcessFinished();
            }
        }
        this.batch.addProgressListener(new AbstractProcessingResource.IntervalProgressListener(0, 100));
        return this;
    }

    @Override
    public void execute() throws ExecutionException {
        this.interrupted = false;
        if (this.document == null) {
            throw new ExecutionException("No document provided!");
        }
        if (this.inputASName != null && this.inputASName.equals("")) {
            this.inputASName = null;
        }
        if (this.outputASName != null && this.outputASName.equals("")) {
            this.outputASName = null;
        }
        try {
            this.batch.transduce(this.document, this.inputASName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.inputASName), this.outputASName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.outputASName));
        }
        catch (JapeException japeException) {
            throw new ExecutionException(japeException);
        }
    }

    @Override
    public List<Action> getActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.addAll(this.actionList);
        return arrayList;
    }

    protected void initCustomConstraints() throws ResourceInstantiationException {
        String string;
        Serializable serializable;
        Class<Serializable> clazz;
        if (this.operators != null) {
            for (String string2 : this.operators) {
                clazz = null;
                try {
                    clazz = Class.forName(string2, true, Gate.getClassLoader()).asSubclass(ConstraintPredicate.class);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        clazz = Class.forName(string2, true, Thread.currentThread().getContextClassLoader()).asSubclass(ConstraintPredicate.class);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        throw new ResourceInstantiationException("Cannot load class for operator: " + string2, classNotFoundException2);
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new ResourceInstantiationException("Operator class '" + string2 + "' must implement ConstraintPredicate");
                }
                try {
                    serializable = clazz.newInstance();
                    string = serializable.getOperator();
                    Factory.getConstraintFactory().addOperator(string, clazz);
                }
                catch (Exception exception) {
                    throw new ResourceInstantiationException("Cannot instantiate class for operator: " + string2, exception);
                }
            }
        }
        if (this.annotationAccessors != null) {
            for (String string2 : this.annotationAccessors) {
                clazz = null;
                try {
                    clazz = Class.forName(string2, true, Gate.getClassLoader()).asSubclass(AnnotationAccessor.class);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        clazz = Class.forName(string2, true, Thread.currentThread().getContextClassLoader()).asSubclass(AnnotationAccessor.class);
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        throw new ResourceInstantiationException("Cannot load class for accessor: " + string2, classNotFoundException3);
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new ResourceInstantiationException("Operator class '" + string2 + "' must implement AnnotationAccessor");
                }
                try {
                    serializable = (AnnotationAccessor)clazz.newInstance();
                    string = (String)serializable.getKey();
                    Factory.getConstraintFactory().addMetaProperty(string, clazz);
                }
                catch (Exception exception) {
                    throw new ResourceInstantiationException("Cannot instantiate class for accessor: " + string2, exception);
                }
            }
        }
    }

    @Override
    public synchronized void interrupt() {
        this.interrupted = true;
        this.batch.interrupt();
    }

    public void setGrammarURL(URL uRL) {
        this.grammarURL = uRL;
    }

    public URL getGrammarURL() {
        return this.grammarURL;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setInputASName(String string) {
        this.inputASName = string;
    }

    public String getInputASName() {
        return this.inputASName;
    }

    public void setOutputASName(String string) {
        this.outputASName = string;
    }

    public String getOutputASName() {
        return this.outputASName;
    }

    public Boolean getEnableDebugging() {
        return this.enableDebugging;
    }

    public void setEnableDebugging(Boolean bl) {
        this.enableDebugging = bl;
    }

    public List<String> getOperators() {
        return this.operators;
    }

    public void setOperators(List<String> list) {
        this.operators = list;
    }

    public List<String> getAnnotationAccessors() {
        return this.annotationAccessors;
    }

    public void setAnnotationAccessors(List<String> list) {
        this.annotationAccessors = list;
    }

    @Override
    public String getBenchmarkId() {
        return this.batch.getBenchmarkId();
    }

    @Override
    public void setBenchmarkId(String string) {
        this.batch.setBenchmarkId(string);
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
        if (this.batch != null) {
            this.batch.setOntology(ontology);
        }
    }

    public URL getBinaryGrammarURL() {
        return this.binaryGrammarURL;
    }

    public void setBinaryGrammarURL(URL uRL) {
        this.binaryGrammarURL = uRL;
    }

    protected class SerializeTransducerAction
    extends AbstractAction {
        public SerializeTransducerAction() {
            super("Serialize Transducer");
            this.putValue("ShortDescription", "Serializes the Transducer as binary file");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    XJFileChooser xJFileChooser = MainFrame.getFileChooser();
                    xJFileChooser.setFileFilter(xJFileChooser.getAcceptAllFileFilter());
                    xJFileChooser.setFileSelectionMode(0);
                    xJFileChooser.setMultiSelectionEnabled(false);
                    if (xJFileChooser.showSaveDialog(null) == 0) {
                        File file = xJFileChooser.getSelectedFile();
                        try {
                            MainFrame.lockGUI("Serializing JAPE Transducer...");
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                            objectOutputStream.writeObject(Transducer.this.batch);
                            objectOutputStream.flush();
                            objectOutputStream.close();
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Error!\n" + iOException.toString(), "GATE", 0);
                            iOException.printStackTrace(Err.getPrintWriter());
                        }
                        finally {
                            MainFrame.unlockGUI();
                        }
                    }
                }
            };
            Thread thread = new Thread(runnable, "Transduer Serialization");
            thread.setPriority(1);
            thread.start();
        }
    }
}

