/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Annotation;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.corpora.TestDocument;
import gate.creole.POSTagger;
import gate.creole.splitter.SentenceSplitter;
import gate.creole.tokeniser.DefaultTokeniser;
import gate.util.GateException;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSplitterTagger
extends TestCase {
    public TestSplitterTagger(String string) {
        super(string);
    }

    public void setUp() throws GateException {
    }

    public void tearDown() throws Exception {
    }

    public static Test suite() {
        return new TestSuite(TestSplitterTagger.class);
    }

    public void testSplitterTagger() throws Exception {
        Document document = Factory.newDocument(new URL(TestDocument.getTestServerName() + "tests/doc0.html"));
        FeatureMap featureMap = Factory.newFeatureMap();
        DefaultTokeniser defaultTokeniser = (DefaultTokeniser)Factory.createResource("gate.creole.tokeniser.DefaultTokeniser", featureMap);
        defaultTokeniser.setDocument(document);
        defaultTokeniser.setAnnotationSetName("testAS");
        defaultTokeniser.execute();
        featureMap = Factory.newFeatureMap();
        SentenceSplitter sentenceSplitter = (SentenceSplitter)Factory.createResource("gate.creole.splitter.SentenceSplitter", featureMap);
        sentenceSplitter.setDocument(document);
        sentenceSplitter.setOutputASName("testAS");
        sentenceSplitter.setInputASName("testAS");
        sentenceSplitter.execute();
        TestSplitterTagger.assertTrue((!document.getAnnotations("testAS").get("Sentence").isEmpty() ? 1 : 0) != 0);
        featureMap = Factory.newFeatureMap();
        POSTagger pOSTagger = (POSTagger)Factory.createResource("gate.creole.POSTagger", featureMap);
        pOSTagger.setDocument(document);
        pOSTagger.setInputASName("testAS");
        pOSTagger.execute();
        for (Annotation annotation : document.getAnnotations("testAS").get("Token")) {
            String string = (String)annotation.getFeatures().get("kind");
            if (!string.equals("kind")) continue;
            TestSplitterTagger.assertNotNull(annotation.getFeatures().get("category"));
        }
    }
}

