/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.CreoleRegister;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractProcessingResource;
import gate.creole.ExecutionException;
import gate.creole.Parameter;
import gate.creole.ParameterList;
import gate.creole.ResourceData;
import gate.util.GateException;
import gate.util.Out;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCreole
extends TestCase {
    private static final boolean DEBUG = false;
    private CreoleRegister reg;

    public TestCreole(String string) throws GateException {
        super(string);
    }

    public void setUp() throws Exception {
        Gate.init();
        this.reg = Gate.getCreoleRegister();
        this.reg.clear();
        URL uRL = Gate.getUrl("tests/");
        this.reg.addDirectory(uRL);
        this.reg.registerDirectories();
    }

    public void tearDown() throws Exception {
        this.reg.clear();
        Gate.init();
    }

    public void testInstanceLists() throws Exception {
        CreoleRegister creoleRegister = Gate.getCreoleRegister();
        Object var4_2 = null;
        Resource resource = null;
        int n = 0;
        Set<String> set = this.reg.getVrTypes();
        Set<String> set2 = this.reg.getPrTypes();
        Set<String> set3 = this.reg.getLrTypes();
        List<Resource> list = creoleRegister.getVrInstances();
        if (!this.allAutoloaders(list)) {
            TestCreole.fail((String)" non-autoloading resources already present (1)");
        }
        list = creoleRegister.getLrInstances();
        n = list.size();
        if (!this.allAutoloaders(list)) {
            TestCreole.fail((String)" non-autoloading resources already present (2)");
        }
        if (!this.allAutoloaders(list = creoleRegister.getPrInstances())) {
            TestCreole.fail((String)" non-autoloading resources already present (3)");
        }
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("features", Factory.newFeatureMap());
        featureMap.put("sourceUrl", Gate.getUrl("tests/doc0.html"));
        resource = Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        if (creoleRegister.getLrInstances().size() != n + 1) {
            TestCreole.fail((String)"wrong number of LRs");
        }
        featureMap = Factory.newFeatureMap();
        featureMap.put("features", Factory.newFeatureMap());
        featureMap.put("sourceUrl", Gate.getUrl("tests/doc0.html"));
        resource = Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        if (creoleRegister.getLrInstances().size() != n + 2) {
            TestCreole.fail((String)"wrong number of LRs");
        }
        if ((list = creoleRegister.getLrInstances("gate.corpora.DocumentImpl")).size() != 2) {
            TestCreole.fail((String)"wrong number of documents");
        }
    }

    public void testViews() throws Exception {
        List<String> list = this.reg.getSmallVRsForResource("gate.persist.SerialDataStore");
        String string = new String("");
        if (list != null && list.size() > 0) {
            string = list.get(0);
        }
        TestCreole.assertTrue((String)("Found " + string + " as small viewer for gate.persist.SerialDataStore, " + "instead  of gate.gui.SerialDatastoreViewer"), (list.size() == 1 && "gate.gui.SerialDatastoreViewer".equals(string) ? 1 : 0) != 0);
        List<String> list2 = this.reg.getLargeVRsForResource("gate.Corpus");
        TestCreole.assertTrue((String)("Found " + list2.size() + " wich are " + list2 + " as large viewers for gate.Corpus, " + "instead  of 2 which are [gate.gui.CorpusEditor, gate.gui.FeaturesEditor]"), (list2.size() == 2 ? 1 : 0) != 0);
        List<String> list3 = this.reg.getLargeVRsForResource("gate.Document");
        TestCreole.assertTrue((String)("Found " + list3.size() + " wich are " + list3 + " as large viewers for gate.Document, " + "instead  of 2 which are [gate.gui.DocumentEditor, gate.gui.FeaturesEditor]"), (list3.size() == 2 ? 1 : 0) != 0);
        List<String> list4 = this.reg.getAnnotationVRs();
        TestCreole.assertTrue((String)("Found " + list4.size() + " wich are " + list4 + " as annotation viewers for all types annotations, " + "instead  of 2 which are [gate.gui.SchemaAnnotationEditor," + " gate.gui.UnrestrictedAnnotationEditor]"), (list4.size() == 2 ? 1 : 0) != 0);
    }

    protected boolean allAutoloaders(List list) {
        if (list != null) {
            Resource resource2 = null;
            ResourceData resourceData = null;
            CreoleRegister creoleRegister = Gate.getCreoleRegister();
            for (Resource resource2 : list) {
                resourceData = (ResourceData)creoleRegister.get(resource2.getClass().getName());
                if (resourceData.isAutoLoading()) continue;
                return false;
            }
        }
        return true;
    }

    public void testDiscovery() throws Exception {
        CreoleRegister creoleRegister = Gate.getCreoleRegister();
        ResourceData resourceData = (ResourceData)creoleRegister.get("gate.creole.tokeniser.DefaultTokeniser");
        TestCreole.assertNotNull((String)"couldn't find unicode tok in register of resources", (Object)resourceData);
        TestCreole.assertTrue((boolean)resourceData.getName().equals("ANNIE Unicode Tokeniser"));
        String string = "gate.corpora.XmlDocumentFormat";
        ResourceData resourceData2 = (ResourceData)creoleRegister.get(string);
        TestCreole.assertTrue((boolean)resourceData2.getName().equals("Sheffield XML Document Format"));
        TestCreole.assertTrue((boolean)resourceData2.isAutoLoading());
        resourceData = (ResourceData)creoleRegister.get("testpkg.TestPR1");
        TestCreole.assertTrue((boolean)resourceData.getJarFileName().equals("TestResources.jar"));
    }

    public void testMetadata() throws Exception {
        ResourceData resourceData = (ResourceData)this.reg.get("testpkg.TestPR1");
        ResourceData resourceData2 = (ResourceData)this.reg.get("testpkg.TestPR2");
        TestCreole.assertTrue((boolean)(resourceData != null & resourceData2 != null));
        TestCreole.assertTrue((boolean)resourceData2.getName().equals("Sheffield Test PR 2"));
        TestCreole.assertTrue((boolean)resourceData.getClassName().equals("testpkg.TestPR1"));
        Iterator<List<Parameter>> iterator = resourceData.getParameterList().getRuntimeParameters().iterator();
        Iterator<Parameter> iterator2 = null;
        Parameter parameter2 = null;
        while (iterator.hasNext()) {
            for (Parameter parameter2 : iterator.next()) {
                if (!parameter2.typeName.equals("param0")) continue;
            }
            if (!parameter2.typeName.equals("param0")) continue;
        }
        TestCreole.assertTrue((String)"param0 was null", (parameter2 != null ? 1 : 0) != 0);
        TestCreole.assertTrue((boolean)parameter2.typeName.equals("java.lang.String"));
        TestCreole.assertTrue((boolean)parameter2.optional);
        TestCreole.assertTrue((!parameter2.runtime ? 1 : 0) != 0);
        TestCreole.assertTrue((parameter2.comment == null ? 1 : 0) != 0);
        TestCreole.assertTrue((boolean)parameter2.name.equals("thing"));
        this.reg.clear();
    }

    public void testToolsAndPrivate() throws Exception {
        ResourceData resourceData = (ResourceData)this.reg.get("testpkg.PrintOutTokens");
        TestCreole.assertTrue((String)"couldn't get PR3", (resourceData != null ? 1 : 0) != 0);
        TestCreole.assertTrue((String)"PR3 not a tool", (boolean)resourceData.isTool());
        String string = "gate.corpora.XmlDocumentFormat";
        ResourceData resourceData2 = (ResourceData)this.reg.get(string);
        TestCreole.assertTrue((String)"Xml doc format not PRIVATE", (boolean)resourceData2.isPrivate());
    }

    public void testLoading() throws Exception {
        TestCreole.assertTrue((String)("wrong number of resources in the register: " + this.reg.size()), (this.reg.size() == 15 ? 1 : 0) != 0);
        ResourceData resourceData = (ResourceData)this.reg.get("testpkg.TestPR1");
        ResourceData resourceData2 = (ResourceData)this.reg.get("testpkg.TestPR2");
        TestCreole.assertTrue((String)"couldn't find PR1/PR2 res data", (resourceData != null && resourceData2 != null ? 1 : 0) != 0);
        TestCreole.assertTrue((String)"wrong name on PR1", (boolean)resourceData.getName().equals("Sheffield Test PR 1"));
        ProcessingResource processingResource = (ProcessingResource)Factory.createResource("testpkg.TestPR1", Factory.newFeatureMap());
        ProcessingResource processingResource2 = (ProcessingResource)Factory.createResource("testpkg.TestPR2", Factory.newFeatureMap());
        FeatureMap featureMap = processingResource.getFeatures();
        FeatureMap featureMap2 = processingResource2.getFeatures();
        TestCreole.assertNotNull((String)"PR1 features are null", (Object)featureMap);
        TestCreole.assertTrue((String)("PR2 got wrong features: " + featureMap2), (featureMap2 != null || featureMap2.size() != 1 ? 1 : 0) != 0);
        processingResource.execute();
        processingResource2.execute();
        TestCreole.assertTrue((String)"PR1 feature not present", (boolean)processingResource.getFeatures().get("I").equals("have been run, thankyou"));
        TestCreole.assertTrue((String)"PR2 feature not present", (boolean)processingResource2.getFeatures().get("I").equals("am in a bad mood"));
        this.reg.clear();
    }

    public void testClassIndex() throws Exception {
        ResourceData resourceData = (ResourceData)this.reg.get("gate.corpora.DocumentImpl");
        TestCreole.assertNotNull((String)"couldn't find document res data", (Object)resourceData);
        TestCreole.assertTrue((String)"doc res data has wrong class name", (boolean)resourceData.getClassName().equals("gate.corpora.DocumentImpl"));
        TestCreole.assertTrue((String)"doc res data has wrong interface name", (boolean)resourceData.getInterfaceName().equals("gate.Document"));
        Class<? extends Resource> clazz = resourceData.getResourceClass();
        TestCreole.assertNotNull((String)"couldn't get doc class", clazz);
        LanguageResource languageResource = (LanguageResource)clazz.newInstance();
        TestCreole.assertTrue((String)"instance of doc is wrong type", (languageResource instanceof LanguageResource && languageResource instanceof Document ? 1 : 0) != 0);
        this.reg.clear();
    }

    public void testTypeLists() throws Exception {
        Set<String> set = this.reg.getVrTypes();
        Set<String> set2 = this.reg.getPrTypes();
        Set<String> set3 = this.reg.getLrTypes();
        TestCreole.assertTrue((String)("wrong number vrs in reg: " + set.size()), (set.size() == 7 ? 1 : 0) != 0);
        TestCreole.assertTrue((String)("wrong number prs in reg: " + set2.size()), (set2.size() == 5 ? 1 : 0) != 0);
        TestCreole.assertTrue((String)("wrong number lrs in reg: " + set3.size()), (set3.size() == 3 ? 1 : 0) != 0);
    }

    public void testComments() throws Exception {
        ResourceData resourceData = (ResourceData)this.reg.get("gate.corpora.DocumentImpl");
        TestCreole.assertNotNull((String)"testComments: couldn't find document res data", (Object)resourceData);
        String string = resourceData.getComment();
        TestCreole.assertTrue((String)"testComments: incorrect or missing COMMENT on document", (string != null && string.equals("GATE document") ? 1 : 0) != 0);
    }

    public void testParameterDefaults1() throws Exception {
        ResourceData resourceData = (ResourceData)this.reg.get("gate.corpora.DocumentImpl");
        TestCreole.assertNotNull((String)"Couldn: couldn't find document res data", (Object)resourceData);
        ParameterList parameterList = resourceData.getParameterList();
        Iterator<List<Parameter>> iterator = parameterList.getRuntimeParameters().iterator();
        TestCreole.assertTrue((String)("Document has runtime params: " + parameterList), (!iterator.hasNext() ? 1 : 0) != 0);
        Parameter parameter = null;
        iterator = parameterList.getInitimeParameters().iterator();
        int n = -1;
        while (iterator.hasNext()) {
            List<Parameter> list = iterator.next();
            Iterator<Parameter> iterator2 = list.iterator();
            ++n;
            int n2 = 0;
            while (iterator2.hasNext()) {
                parameter = iterator2.next();
                switch (n) {
                    case 0: {
                        TestCreole.assertTrue((String)("Doc param 0 wrong type: " + parameter.getTypeName()), (boolean)parameter.getTypeName().equals("java.lang.String"));
                        TestCreole.assertTrue((String)("Doc param 0 wrong name: " + parameter.getName()), (boolean)parameter.getName().equals("sourceUrlName"));
                        Object object = parameter.calculateDefaultValue();
                        TestCreole.assertTrue((String)("Doc param 0 default should be null but was: " + object), (object == null ? 1 : 0) != 0);
                        break;
                    }
                    case 1: {
                        TestCreole.assertTrue((String)("Doc param 1 wrong name: " + parameter.getName()), (boolean)parameter.getName().equals("encoding"));
                        break;
                    }
                    case 2: {
                        TestCreole.assertTrue((String)("Doc param 2 wrong name: " + parameter.getName()), (boolean)parameter.getName().equals("sourceUrlStartOffset"));
                        break;
                    }
                    case 3: {
                        TestCreole.assertTrue((String)("Doc param 3 wrong name: " + parameter.getName()), (boolean)parameter.getName().equals("sourceUrlEndOffset"));
                        break;
                    }
                }
                ++n2;
            }
        }
    }

    public void testParameterDefaults2() throws Exception {
        ResourceData resourceData = (ResourceData)this.reg.get("testpkg.PrintOutTokens");
        TestCreole.assertNotNull((String)"Couldn't find testpkg.POT res data", (Object)resourceData);
        Factory.newDocument(Gate.getUrl("tests/doc0.html"));
        ParameterList parameterList = resourceData.getParameterList();
        Iterator<List<Parameter>> iterator = parameterList.getInitimeParameters().iterator();
        TestCreole.assertTrue((String)("POT has initime params: " + parameterList), (!iterator.hasNext() ? 1 : 0) != 0);
        Parameter parameter = null;
        iterator = parameterList.getRuntimeParameters().iterator();
        int n = -1;
        while (iterator.hasNext()) {
            List<Parameter> list = iterator.next();
            Iterator<Parameter> iterator2 = list.iterator();
            ++n;
            int n2 = 0;
            while (iterator2.hasNext()) {
                parameter = iterator2.next();
                switch (n) {
                    case 0: {
                        TestCreole.assertTrue((String)("POT param 0 wrong type: " + parameter.getTypeName()), (boolean)parameter.getTypeName().equals("gate.corpora.DocumentImpl"));
                        TestCreole.assertTrue((String)("POT param 0 wrong name: " + parameter.getName()), (boolean)parameter.getName().equals("document"));
                        Object object = parameter.calculateDefaultValue();
                        TestCreole.assertTrue((String)("POT param 0 default should be Document but is " + object.getClass().getName()), (boolean)(object instanceof Document));
                        break;
                    }
                    default: {
                        TestCreole.fail((String)("POT has more than 1 param; 2nd is: " + parameter));
                    }
                }
                ++n2;
            }
        }
    }

    public void testParamAsLists() throws Exception {
        ResourceData resourceData = (ResourceData)this.reg.get("testpkg.TestPR3");
        TestCreole.assertNotNull((String)"Couldn: couldn't find testPR3 res data", (Object)resourceData);
        ParameterList parameterList = resourceData.getParameterList();
        List<List<Parameter>> list = parameterList.getRuntimeParameters();
        TestCreole.assertTrue((String)("PR3 should have 4 runtime params: " + parameterList), (list.size() == 4 ? 1 : 0) != 0);
    }

    public void testParameters() throws Exception {
        ResourceData resourceData = (ResourceData)this.reg.get("gate.corpora.DocumentImpl");
        TestCreole.assertNotNull((String)"Couldn: couldn't find document res data", (Object)resourceData);
        ParameterList parameterList = resourceData.getParameterList();
        Iterator<List<Parameter>> iterator = parameterList.getRuntimeParameters().iterator();
        TestCreole.assertTrue((String)("Document has runtime params: " + parameterList), (!iterator.hasNext() ? 1 : 0) != 0);
        Parameter parameter = null;
        List<List<Parameter>> list = parameterList.getInitimeParameters();
        for (int i = 0; i < 4; ++i) {
            List<Parameter> list2 = list.get(i);
            Iterator<Parameter> iterator2 = list2.iterator();
            int n = list2.size();
            TestCreole.assertTrue((String)("param disj wrong length: " + n), (n == 1 ? 1 : 0) != 0);
            int n2 = 0;
            while (iterator2.hasNext()) {
                parameter = iterator2.next();
                switch (i) {
                    case 0: {
                        TestCreole.assertTrue((String)("Doc param 0 wrong type: " + parameter.getTypeName()), (boolean)parameter.getTypeName().equals("java.lang.String"));
                        TestCreole.assertTrue((String)("Doc param 0 wrong name: " + parameter.getName()), (boolean)parameter.getName().equals("sourceUrlName"));
                        Object object = parameter.calculateDefaultValue();
                        TestCreole.assertTrue((String)("Doc param 0 default should be null but was: " + object), (object == null ? 1 : 0) != 0);
                        break;
                    }
                    case 1: {
                        TestCreole.assertTrue((String)("Doc param 1 wrong name: " + parameter.getName()), (boolean)parameter.getName().equals("encoding"));
                        break;
                    }
                    case 2: {
                        TestCreole.assertTrue((String)("Doc param 2 wrong name: " + parameter.getName()), (boolean)parameter.getName().equals("sourceUrlStartOffset"));
                        Object object = parameter.getDefaultValue();
                        break;
                    }
                    case 3: {
                        TestCreole.assertTrue((String)("Doc param 3 wrong name: " + parameter.getName()), (boolean)parameter.getName().equals("sourceUrlEndOffset"));
                        break;
                    }
                }
                ++n2;
            }
        }
    }

    public void testDefaultRun() throws Exception {
        AbstractProcessingResource abstractProcessingResource = new AbstractProcessingResource(){};
        boolean bl = false;
        try {
            abstractProcessingResource.execute();
        }
        catch (ExecutionException executionException) {
            bl = true;
        }
        TestCreole.assertTrue((String)"check should have thrown exception", (boolean)bl);
    }

    public void testArbitraryMetadata() throws Exception {
        ResourceData resourceData = (ResourceData)this.reg.get("gate.corpora.DocumentImpl");
        TestCreole.assertNotNull((String)"testArbitraryMetadata: couldn't find doc res data", (Object)resourceData);
        FeatureMap featureMap = resourceData.getFeatures();
        String string = (String)featureMap.get("FUNKY-METADATA-THAING");
        TestCreole.assertTrue((String)"testArbitraryMetadata: incorrect FUNKY-METADATA-THAING on document", (string != null && string.equals("hubba hubba") ? 1 : 0) != 0);
    }

    public void testIntrospection() throws Exception {
        Object object;
        Object object2;
        ResourceData resourceData = (ResourceData)this.reg.get("gate.corpora.DocumentImpl");
        TestCreole.assertNotNull((String)"couldn't find document res data (2)", (Object)resourceData);
        Class<? extends Resource> clazz = resourceData.getResourceClass();
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        Object[] objectArray = null;
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            object2 = null;
            object = null;
            Class<?> clazz2 = null;
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            clazz2 = propertyDescriptor.getPropertyType();
            object2 = propertyDescriptor.getReadMethod();
            object = propertyDescriptor.getWriteMethod();
            if (object == null || !object.getName().equals("setFeatures")) continue;
            objectArray = object;
        }
        LanguageResource languageResource = (LanguageResource)clazz.newInstance();
        object2 = Factory.newFeatureMap();
        object2.put("things are sunny in sunny countries", "aren't they?");
        object = new Object[]{object2};
        objectArray.invoke((Object)languageResource, object);
        TestCreole.assertTrue((String)"features not added to resource properly", (boolean)languageResource.getFeatures().get("things are sunny in sunny countries").equals("aren't they?"));
    }

    public void testFactory() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("features", Factory.newFeatureMap());
        featureMap.put("sourceUrl", Gate.getUrl("tests/doc0.html"));
        Resource resource = Factory.createResource("gate.corpora.DocumentImpl", featureMap);
    }

    public static void printProperty(PropertyDescriptor propertyDescriptor) {
        Class<?> clazz = propertyDescriptor.getPropertyType();
        Method method = propertyDescriptor.getReadMethod();
        Method method2 = propertyDescriptor.getWriteMethod();
        Out.pr("prop dispname= " + propertyDescriptor.getDisplayName() + "; ");
        Out.pr("prop type name= " + clazz.getName() + "; ");
        if (method != null) {
            Out.pr("get meth name= " + method.getName() + "; ");
        }
        if (method2 != null) {
            Out.pr("set meth name= " + method2.getName() + "; ");
        }
        Out.prln();
    }

    public static Test suite() {
        return new TestSuite(TestCreole.class);
    }

    class DocumentImplBeanInfo
    extends SimpleBeanInfo {
        DocumentImplBeanInfo() {
        }

        public PropertyDescriptor[] getPropertyDescriptors() {
            return new PropertyDescriptor[0];
        }
    }
}

