/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.ParameterList;
import gate.util.AbstractFeatureBearer;
import gate.util.GateClassLoader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceData
extends AbstractFeatureBearer
implements Serializable {
    protected static final boolean DEBUG = false;
    protected static final String DEFAULT_LR_ICON = "lr";
    protected static final String DEFAULT_PR_ICON = "pr";
    protected static final String DEFAULT_OTHER_ICON = "application";
    protected String name;
    protected String icon;
    protected LinkedList<Resource> instantiationStack = new LinkedList();
    protected List<Resource> unmodifiableInstantiationStack = Collections.unmodifiableList(this.instantiationStack);
    @Deprecated
    protected List<Resource> persistantInstantiationList = new ArrayList<Resource>();
    protected String className;
    protected String interfaceName;
    protected Class<? extends Resource> resourceClass;
    protected String jarFileName;
    protected URL jarFileUrl;
    protected String xmlFileName;
    protected URL xmlFileUrl;
    protected String comment;
    protected String helpURL;
    protected ParameterList parameterList = new ParameterList();
    protected boolean autoLoading;
    protected boolean priv = false;
    protected boolean tool = false;
    protected String validityMessage = "";
    public static final int NULL_GUI = 0;
    public static final int LARGE_GUI = 1;
    public static final int SMALL_GUI = 2;
    protected int guiType = 0;
    protected boolean isMainView = false;
    protected String resourceDisplayed = null;
    protected String annotationTypeDisplayed = null;

    public String toString() {
        int n = this.instantiationStack == null ? 0 : this.instantiationStack.size();
        StringBuffer stringBuffer = new StringBuffer("ResourceDataImpl, name=" + this.name + "; className=" + this.className + "; jarFileName=" + this.jarFileName + "; jarFileUrl=" + this.jarFileUrl + "; xmlFileName=" + this.xmlFileName + "; xmlFileUrl=" + this.xmlFileUrl + "; isAutoLoading=" + this.autoLoading + "; numberInstances=" + n + "; isPrivate=" + this.priv + "; isTool=" + this.tool + "; validityMessage=" + this.validityMessage + "; interfaceName=" + this.interfaceName + "; guiType=" + this.guiType + "; mainViewer=" + this.isMainView + "; resourceDisplayed=" + this.resourceDisplayed + "; annotationTypeDisplayed=" + this.annotationTypeDisplayed + "; parameterList=" + this.parameterList + "; features=" + this.features);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        return this.name.equals(((ResourceData)object).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setIcon(String string) {
        this.icon = string;
    }

    public String getIcon() {
        if (this.icon == null) {
            this.icon = this.guessIcon();
        }
        return this.icon;
    }

    protected String guessIcon() {
        if (this.className == null) {
            return DEFAULT_OTHER_ICON;
        }
        if (this.resourceClass == null) {
            return DEFAULT_OTHER_ICON;
        }
        if (LanguageResource.class.isAssignableFrom(this.resourceClass)) {
            return DEFAULT_LR_ICON;
        }
        if (ProcessingResource.class.isAssignableFrom(this.resourceClass)) {
            return DEFAULT_PR_ICON;
        }
        return DEFAULT_OTHER_ICON;
    }

    public List<Resource> getInstantiations() {
        return this.unmodifiableInstantiationStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstantiation(Resource resource) {
        LinkedList<Resource> linkedList = this.instantiationStack;
        synchronized (linkedList) {
            this.instantiationStack.addFirst(resource);
        }
    }

    @Deprecated
    public void makeInstantiationPersistant(Resource resource) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInstantiation(Resource resource) {
        LinkedList<Resource> linkedList = this.instantiationStack;
        synchronized (linkedList) {
            return this.instantiationStack.remove(resource);
        }
    }

    @Deprecated
    public void bumpInstantiation(Resource resource) {
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }

    public void setInterfaceName(String string) {
        this.interfaceName = string;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setResourceClass(Class<? extends Resource> clazz) {
        this.resourceClass = clazz;
    }

    public Class<? extends Resource> getResourceClass() throws ClassNotFoundException {
        if (this.resourceClass == null) {
            GateClassLoader gateClassLoader = Gate.getClassLoader();
            this.resourceClass = gateClassLoader.loadClass(this.className).asSubclass(Resource.class);
        }
        return this.resourceClass;
    }

    public void setJarFileName(String string) {
        this.jarFileName = string;
    }

    public String getJarFileName() {
        return this.jarFileName;
    }

    public void setJarFileUrl(URL uRL) {
        this.jarFileUrl = uRL;
    }

    public URL getJarFileUrl() {
        return this.jarFileUrl;
    }

    public void setXmlFileUrl(URL uRL) {
        this.xmlFileUrl = uRL;
    }

    public URL getXmlFileUrl() {
        return this.xmlFileUrl;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public void setHelpURL(String string) {
        this.helpURL = string;
    }

    public void setParameterList(ParameterList parameterList) {
        this.parameterList = parameterList;
    }

    public ParameterList getParameterList() {
        return this.parameterList;
    }

    public void setAutoLoading(boolean bl) {
        this.autoLoading = bl;
    }

    public boolean isAutoLoading() {
        return this.autoLoading;
    }

    public void setPrivate(boolean bl) {
        this.priv = bl;
    }

    public boolean isPrivate() {
        return this.priv;
    }

    public void setTool(boolean bl) {
        this.tool = bl;
    }

    public boolean isTool() {
        return this.tool;
    }

    public boolean isValid() {
        boolean bl = true;
        this.validityMessage = "";
        if (this.getClassName() == null || this.getClassName().length() == 0) {
            this.validityMessage = this.validityMessage + "No class name provided for the resource!";
            bl = false;
        }
        if (this.getName() == null || this.getName().length() == 0) {
            this.setName(this.className.substring(this.className.lastIndexOf(46) + 1));
        }
        return bl;
    }

    public String getValidityMessage() {
        return this.validityMessage;
    }

    public void setGuiType(int n) {
        this.guiType = n;
    }

    public int getGuiType() {
        return this.guiType;
    }

    public void setIsMainView(boolean bl) {
        this.isMainView = bl;
    }

    public boolean isMainView() {
        return this.isMainView;
    }

    public void setResourceDisplayed(String string) {
        this.resourceDisplayed = string;
    }

    public String getResourceDisplayed() {
        return this.resourceDisplayed;
    }

    public void setAnnotationTypeDisplayed(String string) {
        this.annotationTypeDisplayed = string;
    }

    public String getAnnotationTypeDisplayed() {
        return this.annotationTypeDisplayed;
    }
}

