/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.CreoleRegister;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.creole.Parameter;
import gate.creole.ParameterList;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.util.GateRuntimeException;
import gate.util.GateSaxException;
import gate.util.Strings;
import gate.xml.SimpleErrorHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CreoleXmlHandler
extends DefaultHandler {
    private Stack contentStack = new Stack();
    private ResourceData resourceData;
    private ParameterList currentParamList = new ParameterList();
    private List currentParamDisjunction = new ArrayList();
    private Parameter currentParam;
    private Attributes currentAttributes;
    private static final boolean DEBUG = false;
    private URL sourceUrl;
    private URL creoleFileUrl;
    private SimpleErrorHandler _seh = new SimpleErrorHandler();
    private FeatureMap currentAutoinstanceParams = null;
    private List currentAutoinstances = null;
    private StringBuffer contentBuffer = new StringBuffer("");
    private boolean readCharacterStatus = false;
    private CreoleRegister register;

    public CreoleXmlHandler(CreoleRegister creoleRegister, URL uRL, URL uRL2) {
        this.register = creoleRegister;
        this.sourceUrl = uRL;
        this.creoleFileUrl = uRL2;
        this.currentParam = new Parameter(this.creoleFileUrl);
    }

    public void startDocument() throws GateSaxException {
    }

    public void endDocument() throws GateSaxException {
        if (!this.contentStack.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer("document ended but element stack not empty:");
            while (!this.contentStack.isEmpty()) {
                stringBuffer.append(Strings.getNl() + "  " + (String)this.contentStack.pop());
            }
            throw new GateSaxException(stringBuffer.toString());
        }
    }

    private String attributes2String(Attributes attributes) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (attributes == null) {
            return stringBuffer.toString();
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i);
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        String string4;
        if (this.readCharacterStatus) {
            this.readCharacterStatus = false;
            this.charactersAction(new String(this.contentBuffer).toCharArray(), 0, this.contentBuffer.length());
        }
        if (string3.toUpperCase().equals("RESOURCE")) {
            this.resourceData = new ResourceData();
            this.resourceData.setFeatures(Factory.newFeatureMap());
            this.currentAutoinstances = new ArrayList();
        }
        this.currentAttributes = attributes;
        if (string3.toUpperCase().equals("AUTOINSTANCE")) {
            this.currentAutoinstanceParams = Factory.newFeatureMap();
        }
        if (string3.toUpperCase().equals("HIDDEN-AUTOINSTANCE")) {
            this.currentAutoinstanceParams = Factory.newFeatureMap();
            Gate.setHiddenAttribute(this.currentAutoinstanceParams, true);
        }
        if (string3.toUpperCase().equals("PARAM")) {
            if (this.currentAutoinstanceParams == null) {
                this.currentAutoinstanceParams = Factory.newFeatureMap();
            }
            string4 = this.currentAttributes.getValue("NAME");
            object = this.currentAttributes.getValue("VALUE");
            if (string4 == null) {
                throw new GateRuntimeException("Found in creole.xml a PARAM element for resource " + this.resourceData.getClassName() + " without a NAME" + " attribute. Check the file and try again.");
            }
            if (object == null) {
                throw new GateRuntimeException("Found in creole.xml a PARAM element for resource " + this.resourceData.getClassName() + " without a VALUE" + " attribute. Check the file and try again.");
            }
            this.currentAutoinstanceParams.put(string4, object);
        }
        if (string3.toUpperCase().equals("PARAMETER")) {
            this.currentParam.comment = this.currentAttributes.getValue("COMMENT");
            this.currentParam.helpURL = this.currentAttributes.getValue("HELPURL");
            this.currentParam.defaultValueString = this.currentAttributes.getValue("DEFAULT");
            this.currentParam.optional = Boolean.valueOf(this.currentAttributes.getValue("OPTIONAL"));
            this.currentParam.name = this.currentAttributes.getValue("NAME");
            this.currentParam.runtime = Boolean.valueOf(this.currentAttributes.getValue("RUNTIME"));
            this.currentParam.itemClassName = this.currentAttributes.getValue("ITEM_CLASS_NAME");
            string4 = this.currentAttributes.getValue("SUFFIXES");
            object = null;
            if (string4 != null) {
                object = new HashSet();
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    object.add(stringTokenizer.nextToken());
                }
            }
            this.currentParam.suffixes = object;
        } else if (string3.toUpperCase().equals("GUI") && (string4 = this.currentAttributes.getValue("TYPE")) != null) {
            if (string4.toUpperCase().equals("LARGE")) {
                this.resourceData.setGuiType(1);
            }
            if (string4.toUpperCase().equals("SMALL")) {
                this.resourceData.setGuiType(2);
            }
        }
        if (string3.toUpperCase().equals("OR") && !this.currentParamDisjunction.isEmpty()) {
            this.currentParamList.addAll(this.currentParamDisjunction);
            this.currentParamDisjunction = new ArrayList();
        }
    }

    private void checkStack(String string, String string2) throws GateSaxException {
        if (this.contentStack.isEmpty()) {
            throw new GateSaxException(string + " called for element " + string2 + " with empty stack");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String string, String string2, String string3) throws GateSaxException, SAXException {
        if (this.readCharacterStatus) {
            this.readCharacterStatus = false;
            this.charactersAction(new String(this.contentBuffer).toCharArray(), 0, this.contentBuffer.length());
        }
        if (string3.toUpperCase().equals("RESOURCE")) {
            Object object;
            if (!this.resourceData.isValid()) {
                throw new GateSaxException("Invalid resource data: " + this.resourceData.getValidityMessage());
            }
            this.resourceData.setXmlFileUrl(this.creoleFileUrl);
            this.register.put(this.resourceData.getClassName(), this.resourceData);
            if (this.resourceData.isAutoLoading()) {
                try {
                    object = this.resourceData.getResourceClass();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new GateSaxException("Couldn't load autoloading resource: " + this.resourceData.getName() + "; problem was: " + classNotFoundException);
                }
            }
            if (!this.currentParamDisjunction.isEmpty()) {
                this.currentParamList.addAll(this.currentParamDisjunction);
                this.currentParamDisjunction = new ArrayList();
            }
            this.resourceData.setParameterList(this.currentParamList);
            this.currentParamList = new ParameterList();
            if (this.currentAutoinstances != null && !this.currentAutoinstances.isEmpty()) {
                object = this.currentAutoinstances.iterator();
                while (object.hasNext()) {
                    FeatureMap featureMap = (FeatureMap)object.next();
                    object.remove();
                    FeatureMap featureMap2 = null;
                    if (Gate.getHiddenAttribute(featureMap)) {
                        featureMap2 = Factory.newFeatureMap();
                        Gate.setHiddenAttribute(featureMap2, true);
                        featureMap.remove("gate.HIDDEN");
                    }
                    try {
                        Factory.createResource(this.resourceData.getClassName(), featureMap, featureMap2);
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        throw new GateSaxException("Couldn't auto-instantiate resource: " + this.resourceData.getName() + "; problem was: " + resourceInstantiationException);
                    }
                }
            }
            this.currentAutoinstances = null;
            return;
        }
        if (string3.toUpperCase().equals("AUTOINSTANCE") || string3.toUpperCase().equals("HIDDEN-AUTOINSTANCE")) {
            if (this.currentAutoinstanceParams == null) return;
            this.currentAutoinstances.add(this.currentAutoinstanceParams);
            return;
        } else {
            if (string3.toUpperCase().equals("PARAM")) return;
            if (string3.toUpperCase().equals("NAME")) {
                this.checkStack("endElement", "NAME");
                this.resourceData.setName((String)this.contentStack.pop());
                return;
            } else if (string3.toUpperCase().equals("JAR")) {
                String string4;
                this.checkStack("endElement", "JAR");
                String string5 = (String)this.contentStack.pop();
                if (this.resourceData != null) {
                    this.resourceData.setJarFileName(string5);
                }
                if (this.sourceUrl == null) return;
                String string6 = this.sourceUrl.toExternalForm();
                if (string6.endsWith(string4 = "/")) {
                    string4 = "";
                }
                URL uRL = null;
                try {
                    uRL = new URL(string6 + string4 + string5);
                    if (this.resourceData == null) return;
                    this.resourceData.setJarFileUrl(uRL);
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new GateSaxException("bad URL " + uRL + malformedURLException);
                }
            } else if (string3.toUpperCase().equals("CLASS")) {
                this.checkStack("endElement", "CLASS");
                this.resourceData.setClassName((String)this.contentStack.pop());
                return;
            } else if (string3.toUpperCase().equals("COMMENT")) {
                this.checkStack("endElement", "COMMENT");
                this.resourceData.setComment((String)this.contentStack.pop());
                return;
            } else if (string3.toUpperCase().equals("HELPURL")) {
                this.checkStack("endElement", "HELPURL");
                this.resourceData.setHelpURL((String)this.contentStack.pop());
                return;
            } else if (string3.toUpperCase().equals("INTERFACE")) {
                this.checkStack("endElement", "INTERFACE");
                this.resourceData.setInterfaceName((String)this.contentStack.pop());
                return;
            } else if (string3.toUpperCase().equals("ICON")) {
                this.checkStack("endElement", "ICON");
                this.resourceData.setIcon((String)this.contentStack.pop());
                return;
            } else if (string3.toUpperCase().equals("OR")) {
                this.currentParamList.add(this.currentParamDisjunction);
                this.currentParamDisjunction = new ArrayList();
                return;
            } else if (string3.toUpperCase().equals("PARAMETER")) {
                this.checkStack("endElement", "PARAMETER");
                this.currentParam.typeName = (String)this.contentStack.pop();
                this.currentParamDisjunction.add(this.currentParam);
                this.currentParam = new Parameter(this.creoleFileUrl);
                return;
            } else if (string3.toUpperCase().equals("AUTOLOAD")) {
                this.resourceData.setAutoLoading(true);
                return;
            } else if (string3.toUpperCase().equals("PRIVATE")) {
                this.resourceData.setPrivate(true);
                return;
            } else if (string3.toUpperCase().equals("TOOL")) {
                this.resourceData.setTool(true);
                return;
            } else if (string3.toUpperCase().equals("MAIN_VIEWER")) {
                this.resourceData.setIsMainView(true);
                return;
            } else if (string3.toUpperCase().equals("RESOURCE_DISPLAYED")) {
                this.checkStack("endElement", "RESOURCE_DISPLAYED");
                String string7 = (String)this.contentStack.pop();
                this.resourceData.setResourceDisplayed(string7);
                Class<?> clazz = null;
                try {
                    clazz = Gate.getClassLoader().loadClass(string7);
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new GateRuntimeException("Couldn't get resource class from the resource name :" + string7 + " " + classNotFoundException);
                }
            } else if (string3.toUpperCase().equals("ANNOTATION_TYPE_DISPLAYED")) {
                this.checkStack("endElement", "ANNOTATION_TYPE_DISPLAYED");
                this.resourceData.setAnnotationTypeDisplayed((String)this.contentStack.pop());
                return;
            } else {
                if (string3.toUpperCase().equals("GUI") || string3.toUpperCase().equals("CREOLE") || string3.toUpperCase().equals("CREOLE-DIRECTORY") || this.resourceData == null) return;
                this.resourceData.getFeatures().put(string3.toUpperCase(), this.contentStack.isEmpty() ? null : (String)this.contentStack.pop());
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.readCharacterStatus) {
            this.contentBuffer = new StringBuffer(new String(cArray, n, n2));
        } else {
            this.contentBuffer.append(new String(cArray, n, n2));
        }
        this.readCharacterStatus = true;
    }

    public void charactersAction(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2).trim();
        if (string.length() == 0) {
            return;
        }
        this.contentStack.push(string);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this._seh.error(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this._seh.fatalError(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this._seh.warning(sAXParseException);
    }
}

