/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.corpora.DocumentStaxUtils;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDocumentStaxUtils
extends TestCase {
    public TestDocumentStaxUtils(String string) {
        super(string);
    }

    public void setUp() {
    }

    public void testIllegalXMLCharacters() throws Exception {
        char[] cArray = new char[]{'\u0000', '\n', '\ud801', '\udc01', ' ', '\udc03'};
        DocumentStaxUtils.replaceXMLIllegalCharacters(cArray);
        TestDocumentStaxUtils.assertEquals((String)"Null character should have been replaced by space", (char)' ', (char)cArray[0]);
        TestDocumentStaxUtils.assertEquals((String)"Line feed character should not have been replaced", (char)'\n', (char)cArray[1]);
        TestDocumentStaxUtils.assertEquals((String)"High surrogate of a valid pair should not have been replaced", (char)'\ud801', (char)cArray[2]);
        TestDocumentStaxUtils.assertEquals((String)"Low surrogate of a valid pair should not have been replaced", (char)'\udc01', (char)cArray[3]);
        TestDocumentStaxUtils.assertEquals((String)"Space character should not have been replaced", (char)' ', (char)cArray[4]);
        TestDocumentStaxUtils.assertEquals((String)"Unpaired low surrogate should have been replaced", (char)' ', (char)cArray[5]);
    }

    public static Test suite() {
        return new TestSuite(TestDocumentStaxUtils.class);
    }
}

