/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.corpora.DocumentImpl;
import gate.util.Err;
import gate.util.GateException;
import gate.util.SimpleFeatureMapImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDocument
extends TestCase {
    private static final boolean DEBUG = false;
    protected static String testServer = null;
    protected String testDocument1;

    public TestDocument(String string) {
        super(string);
        this.setUp();
    }

    public void setUp() {
        try {
            testServer = Gate.getUrl().toExternalForm();
        }
        catch (GateException gateException) {
            gateException.printStackTrace(Err.getPrintWriter());
        }
        this.testDocument1 = "tests/html/test2.htm";
    }

    public static String getTestServerName() {
        if (testServer != null) {
            return testServer;
        }
        try {
            testServer = Gate.getUrl().toExternalForm();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return testServer;
    }

    public void testCompareTo() throws Exception {
        Document document = null;
        Document document2 = null;
        Document document3 = null;
        document = Factory.newDocument(new URL(testServer + "tests/def"));
        document2 = Factory.newDocument(new URL(testServer + "tests/defg"));
        document3 = Factory.newDocument(new URL(testServer + "tests/abc"));
        TestDocument.assertTrue((document.compareTo(document2) < 0 ? 1 : 0) != 0);
        TestDocument.assertTrue((document.compareTo(document) == 0 ? 1 : 0) != 0);
        TestDocument.assertTrue((document.compareTo(document3) > 0 ? 1 : 0) != 0);
    }

    public void testOriginalContentPreserving() throws Exception {
        Document document = null;
        String string = "UTF-8";
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", new URL(testServer + this.testDocument1));
        featureMap.put("encoding", string);
        document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        String string2 = (String)document.getFeatures().get("Original_document_content_on_load");
        TestDocument.assertNull((String)"The original content should not be preserved without demand.", (Object)string2);
        featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", new URL(testServer + this.testDocument1));
        featureMap.put("encoding", string);
        featureMap.put("preserveOriginalContent", new Boolean(true));
        document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        string2 = (String)document.getFeatures().get("Original_document_content_on_load");
        TestDocument.assertNotNull((String)"The original content is not preserved on demand.", (Object)string2);
        TestDocument.assertTrue((String)"The original content size is zerro.", (string2.length() > 0 ? 1 : 0) != 0);
    }

    public void testLotsOfThings() {
        URL uRL = null;
        try {
            uRL = new URL(testServer + this.testDocument1);
        }
        catch (Exception exception) {
            exception.printStackTrace(Err.getPrintWriter());
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            TestDocument.assertEquals((String)bufferedReader.readLine(), (String)"<HTML>");
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        catch (IOException iOException) {
            TestDocument.fail((String)iOException.toString());
        }
    }

    public void testDocRender() throws Exception {
        Document document = Factory.newDocument("Hi Mom");
        document.getAnnotations().add(new Long(0L), new Long(2L), "Foo", (FeatureMap)new SimpleFeatureMapImpl());
        String string = document.toXml(document.getAnnotations(), false);
        TestDocument.assertEquals((String)"<Foo>Hi</Foo> Mom", (String)string);
    }

    public static void verifyNodeIdConsistency(Document document) throws Exception {
        if (document == null) {
            return;
        }
        HashMap hashMap = new HashMap();
        AnnotationSet annotationSet = document.getAnnotations();
        TestDocument.verifyNodeIdConsistency(annotationSet, hashMap, document);
        if (document.getNamedAnnotationSets() != null) {
            Iterator<AnnotationSet> iterator = document.getNamedAnnotationSets().values().iterator();
            while (iterator.hasNext()) {
                TestDocument.verifyNodeIdConsistency(iterator.next(), hashMap, document);
            }
        }
        hashMap = null;
    }

    public static void verifyNodeIdConsistency(AnnotationSet annotationSet, Map map, Document document) throws Exception {
        if (annotationSet == null || map == null) {
            return;
        }
        for (Annotation annotation : annotationSet) {
            String string;
            String string2 = string = annotationSet.getName() == null ? "Default" : annotationSet.getName();
            if (map.containsKey(annotation.getStartNode().getOffset())) {
                TestDocument.assertEquals((String)("Found two different node IDs for the same offset( " + annotation.getStartNode().getOffset() + " ).\n" + "START NODE is buggy for annotation(" + annotation + ") from annotation set " + string + " of GATE document :" + document.getSourceUrl()), (Object)annotation.getStartNode().getId(), (Object)((Integer)map.get(annotation.getStartNode().getOffset())));
            }
            if (map.containsKey(annotation.getEndNode().getOffset())) {
                TestDocument.assertEquals((String)("Found two different node IDs for the same offset(" + annotation.getEndNode().getOffset() + ").\n" + "END NODE is buggy for annotation(" + annotation + ") from annotation" + " set " + string + " of GATE document :" + document.getSourceUrl()), (Object)annotation.getEndNode().getId(), (Object)((Integer)map.get(annotation.getEndNode().getOffset())));
            }
            map.put(annotation.getStartNode().getOffset(), annotation.getStartNode().getId());
            map.put(annotation.getEndNode().getOffset(), annotation.getEndNode().getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExplicitMimeType() throws Exception {
        Object v = Gate.getUserConfig().get("Document_add_space_on_unpack");
        Gate.getUserConfig().put("Document_add_space_on_unpack", "false");
        try {
            String string = "<p>This is a <strong>TEST</strong>.</p>";
            String string2 = "This is a TEST.";
            String string3 = "This is a TEST.\n";
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("stringContent", string);
            featureMap.put("markupAware", Boolean.TRUE);
            Document document = (Document)Factory.createResource(DocumentImpl.class.getName(), featureMap);
            TestDocument.assertEquals((String)"Document created with no explicit mime type should have unparsed XML as content.", (String)string, (String)document.getContent().toString());
            TestDocument.assertEquals((String)"Document created with no explicit mime type should not have any Original markups annotations.", (int)0, (int)document.getAnnotations("Original markups").size());
            Factory.deleteResource(document);
            document = null;
            featureMap.put("mimeType", "text/xml");
            Document document2 = (Document)Factory.createResource(DocumentImpl.class.getName(), featureMap);
            TestDocument.assertEquals((String)"Document created with explicit mime type should have been parsed as XML.", (String)string2, (String)document2.getContent().toString());
            TestDocument.assertEquals((String)"Document created with explicit mime type has wrong number of Original markups annotations.", (int)2, (int)document2.getAnnotations("Original markups").size());
            Factory.deleteResource(document2);
            document2 = null;
            featureMap.put("mimeType", "text/html");
            Document document3 = (Document)Factory.createResource(DocumentImpl.class.getName(), featureMap);
            TestDocument.assertEquals((String)"Document created with explicit mime type should have been parsed as HTML.", (String)string3, (String)document3.getContent().toString());
            TestDocument.assertEquals((String)"Document created with explicit mime type has wrong number of Original markups annotations.", (int)4, (int)document3.getAnnotations("Original markups").size());
            Factory.deleteResource(document3);
            document3 = null;
        }
        finally {
            if (v == null) {
                Gate.getUserConfig().remove("Document_add_space_on_unpack");
            } else {
                Gate.getUserConfig().put("Document_add_space_on_unpack", v);
            }
        }
    }

    public static Test suite() {
        return new TestSuite(TestDocument.class);
    }
}

