/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.util.SimpleFeatureMapImpl;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCorpus
extends TestCase {
    private static final boolean DEBUG = false;

    public TestCorpus(String string) {
        super(string);
    }

    public void setUp() {
    }

    public void testCreation() throws Exception {
        Corpus corpus = Factory.newCorpus("test corpus");
        TestCorpus.assertTrue((boolean)corpus.isEmpty());
        TestCorpus.assertTrue((boolean)corpus.getName().equals("test corpus"));
        corpus.setFeatures(new SimpleFeatureMapImpl());
        corpus.getFeatures().put("author", "hamish");
        corpus.getFeatures().put("date", new Integer(180200));
        TestCorpus.assertTrue((corpus.getFeatures().size() == 2 ? 1 : 0) != 0);
        Corpus corpus2 = Factory.newCorpus("test corpus2");
        corpus2.getFeatures().put("author", "hamish");
        corpus2.getFeatures().put("author", "valy");
        TestCorpus.assertTrue((String)("corpus feature set wrong, size = " + corpus2.getFeatures().size()), (corpus2.getFeatures().size() == 1 ? 1 : 0) != 0);
        TestCorpus.assertTrue((boolean)corpus2.getFeatures().get("author").equals("valy"));
    }

    public void testDocumentAddition() throws Exception {
        Corpus corpus = Factory.newCorpus("test corpus");
        Document document = Factory.newDocument("a document");
        Document document2 = Factory.newDocument("another document");
        document2.setSourceUrl(new URL("http://localhost/1"));
        document2.setSourceUrl(new URL("http://localhost/2"));
        TestCorpus.assertTrue((boolean)corpus.add(document));
        TestCorpus.assertTrue((boolean)corpus.add(document2));
        TestCorpus.assertEquals((int)2, (int)corpus.size());
    }

    public static Test suite() {
        return new TestSuite(TestCorpus.class);
    }
}

