/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Document;
import gate.DocumentFormat;
import gate.Resource;
import gate.corpora.DocumentContentImpl;
import gate.corpora.MimeType;
import gate.corpora.RepositioningInfo;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleResource;
import gate.util.DocumentFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

@CreoleResource(name="GATE PDF Document Format", isPrivate=true, autoinstances={@AutoInstance(hidden=true)})
public class PdfDocumentFormat
extends DocumentFormat {
    public Resource init() throws ResourceInstantiationException {
        MimeType mimeType = new MimeType("application", "pdf");
        mimeString2ClassHandlerMap.put(mimeType.getType() + "/" + mimeType.getSubtype(), this);
        mimeString2mimeTypeMap.put(mimeType.getType() + "/" + mimeType.getSubtype(), mimeType);
        suffixes2mimeTypeMap.put("pdf", mimeType);
        this.setMimeType(mimeType);
        return this;
    }

    public Boolean supportsRepositioning() {
        return new Boolean(false);
    }

    public void unpackMarkup(Document document) throws DocumentFormatException {
        URL uRL = document.getSourceUrl();
        if (uRL == null) {
            throw new DocumentFormatException("Unpacking PDF files requires an URL to the original content!");
        }
        InputStream inputStream = null;
        PDDocument pDDocument = null;
        try {
            inputStream = uRL.openStream();
            PDFTextStripper pDFTextStripper = new PDFTextStripper();
            pDDocument = PDDocument.load((InputStream)inputStream);
            String string = pDFTextStripper.getText(pDDocument);
            document.setContent(new DocumentContentImpl(string));
        }
        catch (IOException iOException) {
            throw new DocumentFormatException("I/O exception for " + document.getSourceUrl().toExternalForm(), iOException);
        }
        finally {
            try {
                if (pDDocument != null) {
                    pDDocument.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void unpackMarkup(Document document, RepositioningInfo repositioningInfo, RepositioningInfo repositioningInfo2) throws DocumentFormatException {
        this.unpackMarkup(document);
    }
}

