/*
 * Decompiled with CFR 0.152.
 */
package gate.util.compilers.eclipse.jdt.internal.compiler.lookup;

import gate.util.compilers.eclipse.jdt.core.compiler.CharOperation;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.Binding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.Scope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.Substitution;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import java.util.Map;

public class TypeVariableBinding
extends ReferenceBinding {
    public Binding declaringElement;
    public int rank;
    public TypeBinding firstBound;
    public ReferenceBinding superclass;
    public ReferenceBinding[] superInterfaces;
    public char[] genericTypeSignature;

    public TypeVariableBinding(char[] sourceName, Binding declaringElement, int rank) {
        this.sourceName = sourceName;
        this.declaringElement = declaringElement;
        this.rank = rank;
        this.modifiers = 0x40000001;
        this.tagBits |= 0x20000000L;
    }

    public int kind() {
        return 4100;
    }

    public int boundCheck(Substitution substitution, TypeBinding argumentType) {
        ReferenceBinding superType;
        boolean hasSubstitution;
        if (argumentType == TypeBinding.NULL || argumentType == this) {
            return 0;
        }
        boolean bl = hasSubstitution = substitution != null;
        if (!(argumentType instanceof ReferenceBinding) && !argumentType.isArrayType()) {
            return 2;
        }
        if (this.superclass == null) {
            return 0;
        }
        if (argumentType.isWildcard() && !argumentType.isIntersectionType()) {
            WildcardBinding wildcard = (WildcardBinding)argumentType;
            switch (wildcard.boundKind) {
                case 1: {
                    TypeBinding wildcardBound = wildcard.bound;
                    if (wildcardBound == this) {
                        return 0;
                    }
                    ReferenceBinding superclassBound = hasSubstitution ? (ReferenceBinding)Scope.substitute(substitution, this.superclass) : this.superclass;
                    boolean isArrayBound = wildcardBound.isArrayType();
                    if (!wildcardBound.isInterface() && superclassBound.id != 1) {
                        if (isArrayBound) {
                            if (!wildcardBound.isCompatibleWith(superclassBound)) {
                                return 2;
                            }
                        } else {
                            TypeBinding match = ((ReferenceBinding)wildcardBound).findSuperTypeWithSameErasure(superclassBound);
                            if (match != null) {
                                if (!match.isIntersectingWith(superclassBound)) {
                                    return 2;
                                }
                            } else {
                                return 2;
                            }
                        }
                    }
                    ReferenceBinding[] superInterfaceBounds = hasSubstitution ? Scope.substitute(substitution, this.superInterfaces) : this.superInterfaces;
                    int length = superInterfaceBounds.length;
                    boolean mustImplement = isArrayBound || ((ReferenceBinding)wildcardBound).isFinal();
                    int i = 0;
                    while (i < length) {
                        TypeBinding match;
                        ReferenceBinding superInterfaceBound = superInterfaceBounds[i];
                        if (isArrayBound ? !wildcardBound.isCompatibleWith(superInterfaceBound) : ((match = wildcardBound.findSuperTypeWithSameErasure(superInterfaceBound)) != null ? !match.isIntersectingWith(superInterfaceBound) : mustImplement)) {
                            return 2;
                        }
                        ++i;
                    }
                    break;
                }
                case 2: {
                    return this.boundCheck(substitution, wildcard.bound);
                }
            }
            return 0;
        }
        boolean unchecked = false;
        if (this.superclass.id != 1 && (superType = this.superclass) != argumentType) {
            ReferenceBinding substitutedSuperType;
            TypeBinding typeBinding = substitutedSuperType = hasSubstitution ? Scope.substitute(substitution, superType) : superType;
            if (!argumentType.isCompatibleWith(substitutedSuperType)) {
                return 2;
            }
            TypeBinding match = argumentType.findSuperTypeWithSameErasure(substitutedSuperType);
            if (match != null && match.isRawType() && substitutedSuperType.isBoundParameterizedType()) {
                unchecked = true;
            }
        }
        int i = 0;
        int length = this.superInterfaces.length;
        while (i < length) {
            ReferenceBinding superType2 = this.superInterfaces[i];
            if (superType2 != argumentType) {
                ReferenceBinding substitutedSuperType;
                TypeBinding typeBinding = substitutedSuperType = hasSubstitution ? Scope.substitute(substitution, superType2) : superType2;
                if (!argumentType.isCompatibleWith(substitutedSuperType)) {
                    return 2;
                }
                TypeBinding match = argumentType.findSuperTypeWithSameErasure(substitutedSuperType);
                if (match != null && match.isRawType() && substitutedSuperType.isBoundParameterizedType()) {
                    unchecked = true;
                }
            }
            ++i;
        }
        return unchecked ? 1 : 0;
    }

    public boolean canBeInstantiated() {
        return false;
    }

    public void collectSubstitutes(Scope scope, TypeBinding actualType, Map substitutes, int constraint) {
        block16: {
            int variableConstraint;
            switch (actualType.kind()) {
                case 132: {
                    if (actualType == TypeBinding.NULL) {
                        return;
                    }
                    TypeBinding boxedType = scope.environment().computeBoxingType(actualType);
                    if (boxedType == actualType) {
                        return;
                    }
                    actualType = boxedType;
                    break;
                }
                case 516: {
                    WildcardBinding actualWildcard = (WildcardBinding)actualType;
                    if (actualWildcard.otherBounds != null) break;
                    return;
                }
            }
            switch (constraint) {
                case 0: {
                    variableConstraint = 0;
                    break;
                }
                case 1: {
                    variableConstraint = 2;
                    break;
                }
                default: {
                    variableConstraint = 1;
                }
            }
            TypeBinding[][] variableSubstitutes = (TypeBinding[][])substitutes.get(this);
            if (variableSubstitutes != null) {
                int length;
                TypeBinding[] constraintSubstitutes = variableSubstitutes[variableConstraint];
                if (constraintSubstitutes == null) {
                    length = 0;
                    constraintSubstitutes = new TypeBinding[1];
                } else {
                    length = constraintSubstitutes.length;
                    int i = 0;
                    while (i < length) {
                        TypeBinding substitute = constraintSubstitutes[i];
                        if (substitute == actualType) {
                            return;
                        }
                        if (substitute == null) {
                            constraintSubstitutes[i] = actualType;
                            break block16;
                        }
                        ++i;
                    }
                    TypeBinding[] typeBindingArray = constraintSubstitutes;
                    constraintSubstitutes = new TypeBinding[length + 1];
                    System.arraycopy(typeBindingArray, 0, constraintSubstitutes, 0, length);
                }
                constraintSubstitutes[length] = actualType;
                variableSubstitutes[variableConstraint] = constraintSubstitutes;
            }
        }
    }

    public char[] constantPoolName() {
        if (this.firstBound != null) {
            return this.firstBound.constantPoolName();
        }
        return this.superclass.constantPoolName();
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        StringBuffer buffer = new StringBuffer();
        Binding declaring = this.declaringElement;
        if (!isLeaf && declaring.kind() == 8) {
            MethodBinding methodBinding = (MethodBinding)declaring;
            ReferenceBinding declaringClass = methodBinding.declaringClass;
            buffer.append(declaringClass.computeUniqueKey(false));
            buffer.append(':');
            MethodBinding[] methods = declaringClass.methods();
            if (methods != null) {
                int i = 0;
                int length = methods.length;
                while (i < length) {
                    MethodBinding binding = methods[i];
                    if (binding == methodBinding) {
                        buffer.append(i);
                        break;
                    }
                    ++i;
                }
            }
        } else {
            buffer.append(declaring.computeUniqueKey(false));
            buffer.append(':');
        }
        buffer.append(this.genericTypeSignature());
        int length = buffer.length();
        char[] uniqueKey = new char[length];
        buffer.getChars(0, length, uniqueKey, 0);
        return uniqueKey;
    }

    public String debugName() {
        return new String(this.sourceName);
    }

    public TypeBinding erasure() {
        if (this.firstBound != null) {
            return this.firstBound.erasure();
        }
        return this.superclass;
    }

    public char[] genericSignature() {
        int interfaceLength;
        StringBuffer sig = new StringBuffer(10);
        sig.append(this.sourceName).append(':');
        int n = interfaceLength = this.superInterfaces == null ? 0 : this.superInterfaces.length;
        if ((interfaceLength == 0 || this.firstBound == this.superclass) && this.superclass != null) {
            sig.append(this.superclass.genericTypeSignature());
        }
        int i = 0;
        while (i < interfaceLength) {
            sig.append(':').append(this.superInterfaces[i].genericTypeSignature());
            ++i;
        }
        int sigLength = sig.length();
        char[] genericSignature = new char[sigLength];
        sig.getChars(0, sigLength, genericSignature, 0);
        return genericSignature;
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature != null) {
            return this.genericTypeSignature;
        }
        this.genericTypeSignature = CharOperation.concat('T', this.sourceName, ';');
        return this.genericTypeSignature;
    }

    public boolean isErasureBoundTo(TypeBinding type) {
        if (this.superclass.erasure() == type) {
            return true;
        }
        int i = 0;
        int length = this.superInterfaces.length;
        while (i < length) {
            if (this.superInterfaces[i].erasure() == type) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isInterchangeableWith(final LookupEnvironment environment, final TypeVariableBinding otherVariable) {
        Substitution subst;
        int length;
        block11: {
            if (this == otherVariable) {
                return true;
            }
            length = this.superInterfaces.length;
            if (length != otherVariable.superInterfaces.length) {
                return false;
            }
            if (this.superclass != otherVariable.superclass) {
                if (this.superclass.erasure() != otherVariable.superclass.erasure()) {
                    return false;
                }
            } else {
                int i = 0;
                while (i < length) {
                    if (this.superInterfaces[i] != otherVariable.superInterfaces[i]) {
                        if (this.superInterfaces[i].erasure() != otherVariable.superInterfaces[i].erasure()) {
                            return false;
                        }
                        break block11;
                    }
                    ++i;
                }
                return true;
            }
        }
        if (this.superclass != Scope.substitute(subst = new Substitution(){

            public LookupEnvironment environment() {
                return environment;
            }

            public boolean isRawSubstitution() {
                return false;
            }

            public TypeBinding substitute(TypeVariableBinding typeVariable) {
                return typeVariable == otherVariable ? TypeVariableBinding.this : typeVariable;
            }
        }, otherVariable.superclass)) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (this.superInterfaces[i] != Scope.substitute(subst, otherVariable.superInterfaces[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isTypeVariable() {
        return true;
    }

    public TypeVariableBinding original() {
        if (this.declaringElement.kind() == 8) {
            MethodBinding originalMethod = ((MethodBinding)this.declaringElement).original();
            if (originalMethod != this.declaringElement) {
                return originalMethod.typeVariables[this.rank];
            }
        } else {
            ReferenceBinding originalType = (ReferenceBinding)((ReferenceBinding)this.declaringElement).erasure();
            if (originalType != this.declaringElement) {
                return originalType.typeVariables()[this.rank];
            }
        }
        return this;
    }

    public char[] readableName() {
        return this.sourceName;
    }

    ReferenceBinding resolve(LookupEnvironment environment) {
        int i;
        ReferenceBinding[] interfaces;
        int length;
        if ((this.modifiers & 0x2000000) == 0) {
            return this;
        }
        ReferenceBinding oldSuperclass = this.superclass;
        ReferenceBinding oldFirstInterface = null;
        if (this.superclass != null) {
            this.superclass = BinaryTypeBinding.resolveUnresolvedType(this.superclass, environment, true);
        }
        if ((length = (interfaces = this.superInterfaces).length) != 0) {
            oldFirstInterface = interfaces[0];
            i = length;
            while (--i >= 0) {
                interfaces[i] = BinaryTypeBinding.resolveUnresolvedType(interfaces[i], environment, true);
            }
        }
        this.modifiers &= 0xFDFFFFFF;
        if (this.superclass != null) {
            this.superclass = BinaryTypeBinding.resolveType(this.superclass, environment, true);
        }
        i = interfaces.length;
        while (--i >= 0) {
            interfaces[i] = BinaryTypeBinding.resolveType(interfaces[i], environment, true);
        }
        if (this.firstBound != null) {
            if (this.firstBound == oldSuperclass) {
                this.firstBound = this.superclass;
            } else if (this.firstBound == oldFirstInterface) {
                this.firstBound = interfaces[0];
            }
        }
        return this;
    }

    public char[] shortReadableName() {
        return this.readableName();
    }

    public ReferenceBinding superclass() {
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        return this.superInterfaces;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append('<').append(this.sourceName);
        if (this.superclass != null && this.firstBound == this.superclass) {
            buffer.append(" extends ").append(this.superclass.debugName());
        }
        if (this.superInterfaces != null && this.superInterfaces != Binding.NO_SUPERINTERFACES) {
            if (this.firstBound != this.superclass) {
                buffer.append(" extends ");
            }
            int i = 0;
            int length = this.superInterfaces.length;
            while (i < length) {
                if (i > 0 || this.firstBound == this.superclass) {
                    buffer.append(" & ");
                }
                buffer.append(this.superInterfaces[i].debugName());
                ++i;
            }
        }
        buffer.append('>');
        return buffer.toString();
    }

    public TypeBinding upperBound() {
        if (this.firstBound != null) {
            return this.firstBound;
        }
        return this.superclass;
    }
}

