/*
 * Decompiled with CFR 0.152.
 */
package gate.util.compilers.eclipse.jdt.internal.compiler.flow;

import gate.util.compilers.eclipse.jdt.internal.compiler.ast.ASTNode;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.Expression;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.Reference;
import gate.util.compilers.eclipse.jdt.internal.compiler.flow.FlowContext;
import gate.util.compilers.eclipse.jdt.internal.compiler.flow.FlowInfo;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.BlockScope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.Scope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FinallyFlowContext
extends FlowContext {
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount;
    LocalVariableBinding[] nullLocals;
    Expression[] nullReferences;
    int[] nullCheckTypes;
    int nullCount;

    public FinallyFlowContext(FlowContext parent, ASTNode associatedNode) {
        super(parent, associatedNode);
    }

    public void complainOnDeferredChecks(FlowInfo flowInfo, BlockScope scope) {
        Expression expression;
        int i = 0;
        while (i < this.assignCount) {
            VariableBinding variable = this.finalVariables[i];
            if (variable != null) {
                boolean complained = false;
                if (variable instanceof FieldBinding) {
                    if (flowInfo.isPotentiallyAssigned((FieldBinding)variable)) {
                        complained = true;
                        scope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)variable, this.finalAssignments[i]);
                    }
                } else if (flowInfo.isPotentiallyAssigned((LocalVariableBinding)variable)) {
                    complained = true;
                    scope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)variable, this.finalAssignments[i]);
                }
                if (complained) {
                    FlowContext currentContext = this.parent;
                    while (currentContext != null) {
                        currentContext.removeFinalAssignmentIfAny(this.finalAssignments[i]);
                        currentContext = currentContext.parent;
                    }
                }
            }
            ++i;
        }
        if (this.deferNullDiagnostic) {
            i = 0;
            while (i < this.nullCount) {
                expression = this.nullReferences[i];
                LocalVariableBinding local = this.nullLocals[i];
                switch (this.nullCheckTypes[i]) {
                    case 20: 
                    case 21: {
                        if (flowInfo.isProtectedNonNull(local)) {
                            if (this.nullCheckTypes[i] == 20) {
                                scope.problemReporter().localVariableCannotBeNull(local, expression);
                            }
                            return;
                        }
                        if (!flowInfo.isProtectedNull(local)) break;
                        scope.problemReporter().localVariableCanOnlyBeNull(local, expression);
                        return;
                    }
                    case 22: {
                        if (flowInfo.isProtectedNonNull(local)) {
                            return;
                        }
                        if (!flowInfo.isProtectedNull(local)) break;
                        scope.problemReporter().localVariableCanOnlyBeNull(local, expression);
                        return;
                    }
                }
                this.parent.recordUsingNullReference(scope, local, expression, this.nullCheckTypes[i], flowInfo);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.nullCount) {
                expression = this.nullReferences[i];
                LocalVariableBinding local = this.nullLocals[i];
                switch (this.nullCheckTypes[i]) {
                    case 20: {
                        if (flowInfo.isDefinitelyNonNull(local)) {
                            scope.problemReporter().localVariableCannotBeNull(local, expression);
                            return;
                        }
                    }
                    case 21: {
                        if (!flowInfo.isDefinitelyNull(local)) break;
                        scope.problemReporter().localVariableCanOnlyBeNull(local, expression);
                        return;
                    }
                    case 22: {
                        if (flowInfo.isDefinitelyNull(local)) {
                            scope.problemReporter().localVariableCanOnlyBeNull(local, expression);
                            return;
                        }
                        if (!flowInfo.isPotentiallyNull(local)) break;
                        scope.problemReporter().localVariableMayBeNull(local, expression);
                        return;
                    }
                }
                ++i;
            }
        }
    }

    public String individualToString() {
        StringBuffer buffer = new StringBuffer("Finally flow context");
        buffer.append("[finalAssignments count - ").append(this.assignCount).append(']');
        buffer.append("[nullReferences count - ").append(this.nullCount).append(']');
        return buffer.toString();
    }

    public boolean isSubRoutine() {
        return true;
    }

    protected boolean recordFinalAssignment(VariableBinding binding, Reference finalAssignment) {
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = finalAssignment;
        this.finalVariables[this.assignCount++] = binding;
        return true;
    }

    public void recordUsingNullReference(Scope scope, LocalVariableBinding local, Expression reference, int checkType, FlowInfo flowInfo) {
        block17: {
            block19: {
                block18: {
                    if ((flowInfo.tagBits & 1) != 0) break block17;
                    if (!this.deferNullDiagnostic) break block18;
                    switch (checkType) {
                        case 20: 
                        case 21: {
                            if (flowInfo.isProtectedNonNull(local)) {
                                if (checkType == 20) {
                                    scope.problemReporter().localVariableCannotBeNull(local, reference);
                                }
                                return;
                            }
                            if (flowInfo.isProtectedNull(local)) {
                                scope.problemReporter().localVariableCanOnlyBeNull(local, reference);
                                return;
                            }
                            break block19;
                        }
                        case 22: {
                            if (flowInfo.isProtectedNonNull(local)) {
                                return;
                            }
                            if (flowInfo.isProtectedNull(local)) {
                                scope.problemReporter().localVariableCanOnlyBeNull(local, reference);
                                return;
                            }
                            break block19;
                        }
                    }
                    break block19;
                }
                switch (checkType) {
                    case 20: {
                        if (flowInfo.isDefinitelyNonNull(local)) {
                            scope.problemReporter().localVariableCannotBeNull(local, reference);
                            return;
                        }
                    }
                    case 21: {
                        if (!flowInfo.isDefinitelyNull(local)) break;
                        scope.problemReporter().localVariableCanOnlyBeNull(local, reference);
                        return;
                    }
                    case 22: {
                        if (flowInfo.isDefinitelyNull(local)) {
                            scope.problemReporter().localVariableCanOnlyBeNull(local, reference);
                            return;
                        }
                        if (flowInfo.isPotentiallyNull(local)) {
                            scope.problemReporter().localVariableMayBeNull(local, reference);
                            return;
                        }
                        if (!flowInfo.isDefinitelyNonNull(local)) break;
                        return;
                    }
                }
            }
            this.recordNullReference(local, reference, checkType);
        }
    }

    void removeFinalAssignmentIfAny(Reference reference) {
        int i = 0;
        while (i < this.assignCount) {
            if (this.finalAssignments[i] == reference) {
                this.finalAssignments[i] = null;
                this.finalVariables[i] = null;
                return;
            }
            ++i;
        }
    }

    protected void recordNullReference(LocalVariableBinding local, Expression expression, int status) {
        if (this.nullCount == 0) {
            this.nullLocals = new LocalVariableBinding[5];
            this.nullReferences = new Expression[5];
            this.nullCheckTypes = new int[5];
        } else if (this.nullCount == this.nullLocals.length) {
            int newLength = this.nullCount * 2;
            this.nullLocals = new LocalVariableBinding[newLength];
            System.arraycopy(this.nullLocals, 0, this.nullLocals, 0, this.nullCount);
            this.nullReferences = new Expression[newLength];
            System.arraycopy(this.nullReferences, 0, this.nullReferences, 0, this.nullCount);
            this.nullCheckTypes = new int[newLength];
            System.arraycopy(this.nullCheckTypes, 0, this.nullCheckTypes, 0, this.nullCount);
        }
        this.nullLocals[this.nullCount] = local;
        this.nullReferences[this.nullCount] = expression;
        this.nullCheckTypes[this.nullCount++] = status;
    }
}

