/*
 * Decompiled with CFR 0.152.
 */
package gate.util.compilers.eclipse.jdt.internal.compiler.ast;

import gate.util.compilers.eclipse.jdt.internal.compiler.ASTVisitor;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.Argument;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.Expression;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.TypeReference;
import gate.util.compilers.eclipse.jdt.internal.compiler.impl.Constant;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.BlockScope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.ClassScope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.Scope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JavadocArgumentExpression
extends Expression {
    public char[] token;
    public Argument argument;

    public JavadocArgumentExpression(char[] name, int startPos, int endPos, TypeReference typeRef) {
        this.token = name;
        this.sourceStart = startPos;
        this.sourceEnd = endPos;
        long pos = ((long)startPos << 32) + (long)endPos;
        this.argument = new Argument(name, pos, typeRef, 0);
        this.bits |= 0x8000;
    }

    private TypeBinding internalResolveType(Scope scope) {
        TypeReference typeRef;
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : null;
        }
        if (this.argument != null && (typeRef = this.argument.type) != null) {
            typeRef.resolvedType = this.resolvedType = typeRef.getTypeBinding(scope);
            if (!this.resolvedType.isValidBinding()) {
                scope.problemReporter().javadocInvalidType(typeRef, this.resolvedType, scope.getDeclarationModifiers());
                return null;
            }
            if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
                scope.problemReporter().javadocDeprecatedType(this.resolvedType, typeRef, scope.getDeclarationModifiers());
                return null;
            }
            this.resolvedType = scope.environment().convertToRawType(this.resolvedType);
            return this.resolvedType;
        }
        return null;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.argument == null) {
            if (this.token != null) {
                output.append(this.token);
            }
        } else {
            this.argument.print(indent, output);
        }
        return output;
    }

    public void resolve(BlockScope scope) {
        if (this.argument != null) {
            this.argument.resolve(scope);
        }
    }

    public TypeBinding resolveType(BlockScope scope) {
        return this.internalResolveType(scope);
    }

    public TypeBinding resolveType(ClassScope scope) {
        return this.internalResolveType(scope);
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope) && this.argument != null) {
            this.argument.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }
}

