/*
 * Decompiled with CFR 0.152.
 */
package gate.util.compilers.eclipse.jdt.internal.compiler.ast;

import gate.util.compilers.eclipse.jdt.internal.compiler.ASTVisitor;
import gate.util.compilers.eclipse.jdt.internal.compiler.ClassFile;
import gate.util.compilers.eclipse.jdt.internal.compiler.CompilationResult;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.Initializer;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import gate.util.compilers.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import gate.util.compilers.eclipse.jdt.internal.compiler.codegen.CodeStream;
import gate.util.compilers.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import gate.util.compilers.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import gate.util.compilers.eclipse.jdt.internal.compiler.flow.FlowInfo;
import gate.util.compilers.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.Binding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.BlockScope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.ClassScope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.MethodScope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import gate.util.compilers.eclipse.jdt.internal.compiler.parser.Parser;
import gate.util.compilers.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class Clinit
extends AbstractMethodDeclaration {
    private FieldBinding assertionSyntheticFieldBinding = null;
    private FieldBinding classLiteralSyntheticField = null;

    public Clinit(CompilationResult compilationResult) {
        super(compilationResult);
        this.modifiers = 0;
        this.selector = TypeConstants.CLINIT;
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext staticInitializerFlowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            ExceptionHandlingFlowContext clinitContext = new ExceptionHandlingFlowContext(staticInitializerFlowContext.parent, this, Binding.NO_EXCEPTIONS, this.scope, FlowInfo.DEAD_END);
            this.needFreeReturn = (flowInfo.tagBits & 1) == 0;
            flowInfo = flowInfo.mergedWith(staticInitializerFlowContext.initsOnReturn);
            FieldBinding[] fields = this.scope.enclosingSourceType().fields();
            int i = 0;
            int count = fields.length;
            while (i < count) {
                FieldBinding field = fields[i];
                if (field.isStatic() && field.isFinal() && !flowInfo.isDefinitelyAssigned(fields[i])) {
                    this.scope.problemReporter().uninitializedBlankFinalField(field, this.scope.referenceType().declarationOf(field.original()));
                }
                ++i;
            }
            staticInitializerFlowContext.checkInitializerExceptions(this.scope, clinitContext, flowInfo);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int clinitOffset = 0;
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            clinitOffset = classFile.contentsOffset;
            this.generateCode(classScope, classFile, clinitOffset);
        }
        catch (AbortMethod e) {
            if (e.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                try {
                    classFile.contentsOffset = clinitOffset;
                    --classFile.methodCount;
                    classFile.codeStream.wideMode = true;
                    this.generateCode(classScope, classFile, clinitOffset);
                }
                catch (AbortMethod abortMethod) {
                    classFile.contentsOffset = clinitOffset;
                    --classFile.methodCount;
                }
            }
            classFile.contentsOffset = clinitOffset;
            --classFile.methodCount;
        }
    }

    private void generateCode(ClassScope classScope, ClassFile classFile, int clinitOffset) {
        ConstantPool constantPool = classFile.constantPool;
        int constantPoolOffset = constantPool.currentOffset;
        int constantPoolIndex = constantPool.currentIndex;
        classFile.generateMethodInfoHeaderForClinit();
        int codeAttributeOffset = classFile.contentsOffset;
        classFile.generateCodeAttributeHeader();
        CodeStream codeStream = classFile.codeStream;
        this.resolve(classScope);
        codeStream.reset(this, classFile);
        TypeDeclaration declaringType = classScope.referenceContext;
        MethodScope staticInitializerScope = declaringType.staticInitializerScope;
        staticInitializerScope.computeLocalVariablePositions(0, codeStream);
        if (this.assertionSyntheticFieldBinding != null) {
            codeStream.generateClassLiteralAccessForType(classScope.enclosingSourceType(), this.classLiteralSyntheticField);
            codeStream.invokeJavaLangClassDesiredAssertionStatus();
            BranchLabel falseLabel = new BranchLabel(codeStream);
            codeStream.ifne(falseLabel);
            codeStream.iconst_1();
            BranchLabel jumpLabel = new BranchLabel(codeStream);
            codeStream.goto_(jumpLabel);
            falseLabel.place();
            codeStream.iconst_0();
            jumpLabel.place();
            codeStream.putstatic(this.assertionSyntheticFieldBinding);
        }
        FieldDeclaration[] fieldDeclarations = declaringType.fields;
        BlockScope lastInitializerScope = null;
        if (TypeDeclaration.kind(declaringType.modifiers) == 3) {
            FieldDeclaration fieldDecl;
            int max;
            int i;
            int enumCount = 0;
            int remainingFieldCount = 0;
            if (fieldDeclarations != null) {
                i = 0;
                max = fieldDeclarations.length;
                while (i < max) {
                    fieldDecl = fieldDeclarations[i];
                    if (fieldDecl.isStatic()) {
                        if (fieldDecl.getKind() == 3) {
                            fieldDecl.generateCode(staticInitializerScope, codeStream);
                            ++enumCount;
                        } else {
                            ++remainingFieldCount;
                        }
                    }
                    ++i;
                }
            }
            codeStream.generateInlinedValue(enumCount);
            codeStream.anewarray(declaringType.binding);
            if (enumCount > 0 && fieldDeclarations != null) {
                i = 0;
                max = fieldDeclarations.length;
                while (i < max) {
                    fieldDecl = fieldDeclarations[i];
                    if (fieldDecl.getKind() == 3) {
                        codeStream.dup();
                        codeStream.generateInlinedValue(fieldDecl.binding.id);
                        codeStream.getstatic(fieldDecl.binding);
                        codeStream.aastore();
                    }
                    ++i;
                }
            }
            codeStream.putstatic(declaringType.enumValuesSyntheticfield);
            if (remainingFieldCount != 0) {
                i = 0;
                max = fieldDeclarations.length;
                while (i < max) {
                    fieldDecl = fieldDeclarations[i];
                    switch (fieldDecl.getKind()) {
                        case 3: {
                            break;
                        }
                        case 2: {
                            if (!fieldDecl.isStatic()) break;
                            lastInitializerScope = ((Initializer)fieldDecl).block.scope;
                            fieldDecl.generateCode(staticInitializerScope, codeStream);
                            break;
                        }
                        case 1: {
                            if (!fieldDecl.binding.isStatic()) break;
                            lastInitializerScope = null;
                            fieldDecl.generateCode(staticInitializerScope, codeStream);
                        }
                    }
                    ++i;
                }
            }
        } else if (fieldDeclarations != null) {
            int i = 0;
            int max = fieldDeclarations.length;
            while (i < max) {
                FieldDeclaration fieldDecl = fieldDeclarations[i];
                switch (fieldDecl.getKind()) {
                    case 2: {
                        if (!fieldDecl.isStatic()) break;
                        lastInitializerScope = ((Initializer)fieldDecl).block.scope;
                        fieldDecl.generateCode(staticInitializerScope, codeStream);
                        break;
                    }
                    case 1: {
                        if (!fieldDecl.binding.isStatic()) break;
                        lastInitializerScope = null;
                        fieldDecl.generateCode(staticInitializerScope, codeStream);
                    }
                }
                ++i;
            }
        }
        if (codeStream.position == 0) {
            classFile.contentsOffset = clinitOffset;
            --classFile.methodCount;
            constantPool.resetForClinit(constantPoolIndex, constantPoolOffset);
        } else {
            if (this.needFreeReturn) {
                int before = codeStream.position;
                codeStream.return_();
                if (lastInitializerScope != null) {
                    codeStream.updateLastRecordedEndPC(lastInitializerScope, before);
                }
            }
            codeStream.recordPositionsFrom(0, declaringType.sourceStart);
            classFile.completeCodeAttributeForClinit(codeAttributeOffset);
        }
    }

    public boolean isClinit() {
        return true;
    }

    public boolean isInitializationMethod() {
        return true;
    }

    public boolean isStatic() {
        return true;
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
    }

    public StringBuffer print(int tab, StringBuffer output) {
        Clinit.printIndent(tab, output).append("<clinit>()");
        this.printBody(tab + 1, output);
        return output;
    }

    public void resolve(ClassScope classScope) {
        this.scope = new MethodScope(classScope, classScope.referenceContext, true);
    }

    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        visitor.visit(this, classScope);
        visitor.endVisit(this, classScope);
    }

    public void setAssertionSupport(FieldBinding assertionSyntheticFieldBinding, boolean needClassLiteralField) {
        this.assertionSyntheticFieldBinding = assertionSyntheticFieldBinding;
        SourceTypeBinding sourceType = this.scope.outerMostMethodScope().enclosingSourceType();
        if (needClassLiteralField) {
            this.classLiteralSyntheticField = sourceType.addSyntheticFieldForClassLiteral(sourceType, this.scope);
        }
    }
}

