/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.tsc.aap.client.test.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import uk.ac.ebi.tsc.aap.client.model.Domain;
import uk.ac.ebi.tsc.aap.client.model.Profile;
import uk.ac.ebi.tsc.aap.client.model.User;
import uk.ac.ebi.tsc.aap.client.test.util.ClientJsonUtil;
import uk.ac.ebi.tsc.aap.client.test.value.AapClientVersion;

public class ClientTestUtil {
    public static final String AAP_ADMIN_AUTHORITY = "aap.admin";

    public static String createClientUserProfileJson(AapClientVersion version, String profileReference, String userName, String email, String userReference, String fullName, Set<Domain> domains, Object organization, boolean accountNonLocked, Map<String, String> attributes) throws JsonProcessingException {
        if (version == null) {
            throw new IllegalArgumentException("Specify a version!");
        }
        Profile profile = null;
        switch (version) {
            case V1_0_6_SNAPSHOT: 
            case V1_0_7_SNAPSHOT: {
                User user = User.builder().withUsername(userName).withEmail(email).withReference(userReference).withFullName(fullName).withDomains(domains).withAccountNonLocked(accountNonLocked).build();
                profile = new Profile(profileReference, user, null, attributes);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Sorry, version " + (Object)((Object)version) + " not handled yet!");
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)profile);
    }

    public static String createClientUserJson(AapClientVersion version, Object userName, Object email, Object userReference, Object fullName, Set<Domain> domains, Object organization, Object accountNonLocked) {
        if (version == null) {
            throw new IllegalArgumentException("Specify a version!");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        switch (version) {
            case V1_0_6_SNAPSHOT: {
                if (accountNonLocked != null) {
                    throw new IllegalArgumentException("accountNonLocked not available in " + (Object)((Object)version));
                }
                data.put("userName", userName);
                data.put("email", email);
                data.put("userReference", userReference);
                data.put("fullName", fullName);
                data.put("organization", organization);
                break;
            }
            case V1_0_7_SNAPSHOT: {
                data.put("userName", userName);
                data.put("email", email);
                data.put("userReference", userReference);
                data.put("fullName", fullName);
                data.put("organization", organization);
                data.put("accountNonLocked", accountNonLocked);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Sorry, version " + (Object)((Object)version) + " not handled yet!");
            }
        }
        return ClientJsonUtil.toJson(data);
    }

    public static String retrieveErrorResponseProp(String errorResponse, ErrorResponseProperty property) {
        try {
            JSONObject jsonObject = new JSONObject(errorResponse);
            return jsonObject.getString(property.toString().toLowerCase());
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static enum ErrorResponseProperty {
        TIMESTAMP,
        STATUS,
        ERROR,
        MESSAGE,
        PATH,
        EXCEPTION;

    }
}

