/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.tsc.aap.client.test.security.context.support;

import java.util.HashSet;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.test.context.support.WithSecurityContextFactory;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.util.StringUtils;
import uk.ac.ebi.tsc.aap.client.model.Domain;
import uk.ac.ebi.tsc.aap.client.model.User;
import uk.ac.ebi.tsc.aap.client.security.UserAuthentication;
import uk.ac.ebi.tsc.aap.client.test.security.context.support.WithMockAapUser;

final class WithMockAapUserSecurityContextFactory
implements WithSecurityContextFactory<WithMockAapUser> {
    WithMockAapUserSecurityContextFactory() {
    }

    public SecurityContext createSecurityContext(WithMockAapUser withUser) {
        String username = withUser.username();
        if (username == null || StringUtils.isEmpty((Object)username)) {
            throw new IllegalArgumentException(withUser + " cannot have null or empty username");
        }
        HashSet<Domain> domains = new HashSet<Domain>();
        for (String authority : withUser.authorities()) {
            domains.add(new Domain(authority, null, null));
        }
        User user = new User(null, null, username, null, domains);
        UserAuthentication authentication = new UserAuthentication();
        ReflectionTestUtils.setField((Object)authentication, (String)"user", (Object)user);
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication((Authentication)authentication);
        return context;
    }
}

