/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.tsc.aap.client.security;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import uk.ac.ebi.tsc.aap.client.exception.InvalidJWTTokenException;
import uk.ac.ebi.tsc.aap.client.exception.TokenExpiredException;
import uk.ac.ebi.tsc.aap.client.model.User;
import uk.ac.ebi.tsc.aap.client.security.TokenHandler;
import uk.ac.ebi.tsc.aap.client.security.UserAuthentication;

@Component
public class TokenAuthenticationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenAuthenticationService.class);
    private static final String TOKEN_HEADER_KEY = "Authorization";
    private static final String TOKEN_HEADER_VALUE_PREFIX = "Bearer";
    private final TokenHandler tokenHandler;

    @Autowired
    public TokenAuthenticationService(TokenHandler tokenHandler) {
        this.tokenHandler = tokenHandler;
    }

    public Authentication getAuthentication(HttpServletRequest request) throws InvalidJWTTokenException, TokenExpiredException {
        LOGGER.trace("getAuthentication");
        String token = this.extractToken(request);
        if (token == null) {
            return null;
        }
        User user = this.tokenHandler.parseUserFromToken(token);
        return new UserAuthentication(user);
    }

    public String extractToken(HttpServletRequest request) {
        try {
            String header = request.getHeader(TOKEN_HEADER_KEY);
            if (header == null || !header.trim().startsWith(TOKEN_HEADER_VALUE_PREFIX.trim())) {
                LOGGER.trace("No {} header", (Object)TOKEN_HEADER_KEY);
                return null;
            }
            if (!header.trim().startsWith(TOKEN_HEADER_VALUE_PREFIX.trim())) {
                LOGGER.trace("No {} prefix", (Object)TOKEN_HEADER_VALUE_PREFIX);
                return null;
            }
            String token = header.substring(TOKEN_HEADER_VALUE_PREFIX.trim().length());
            if (StringUtils.isEmpty((Object)token)) {
                LOGGER.trace("Missing jwt token");
                return null;
            }
            return token;
        }
        catch (Exception e) {
            return null;
        }
    }
}

