/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.tsc.aap.client.security;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;
import uk.ac.ebi.tsc.aap.client.model.ErrorResponse;

@Component
public class StatelessAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatelessAuthenticationEntryPoint.class);
    ObjectMapper mapper = new ObjectMapper();

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        if (request.getAttribute("ERROR_RESPONSE") != null) {
            ErrorResponse errorResponse = (ErrorResponse)request.getAttribute("ERROR_RESPONSE");
            errorResponse.setPath(request.getRequestURI());
            errorResponse.setStatus(HttpStatus.UNAUTHORIZED.name());
            response.setStatus(401);
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(this.convertObjectToJson(errorResponse));
        } else {
            response.sendError(401, "Unauthorized");
        }
    }

    public String convertObjectToJson(Object object) throws JsonProcessingException {
        if (object == null) {
            return null;
        }
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
    }
}

