/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.tsc.aap.client.security;

import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfiguration;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import uk.ac.ebi.tsc.aap.client.security.CorsFilterProperties;
import uk.ac.ebi.tsc.aap.client.security.StatelessAuthenticationEntryPoint;
import uk.ac.ebi.tsc.aap.client.security.StatelessAuthenticationFilter;
import uk.ac.ebi.tsc.aap.client.security.TokenAuthenticationService;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={EnableWebSecurity.class, AuthenticationEntryPoint.class})
@ConditionalOnMissingBean(value={WebSecurityConfiguration.class})
@ConditionalOnWebApplication
@EnableWebSecurity
@ComponentScan(value={"uk.ac.ebi.tsc.aap.client.security"})
@PropertySource(value={"classpath:/application-security.properties"})
public class AAPWebSecurityAutoConfiguration {

    @Configuration
    @Order(value=0x7FFFFFF0)
    public static class AAPWebSecurityConfig
    extends WebSecurityConfigurerAdapter {
        private static final Logger LOGGER = LoggerFactory.getLogger(AAPWebSecurityConfig.class);
        @Autowired
        private CorsFilterProperties corsFilterProperties;
        @Autowired
        private StatelessAuthenticationEntryPoint unauthorizedHandler;
        @Autowired
        private TokenAuthenticationService tokenAuthenticationService;

        private StatelessAuthenticationFilter statelessAuthenticationFilterBean() throws Exception {
            LOGGER.trace("TokenAuthenticationService: {}", (Object)this.tokenAuthenticationService);
            return new StatelessAuthenticationFilter(this.tokenAuthenticationService);
        }

        protected void configure(HttpSecurity httpSecurity) throws Exception {
            LOGGER.trace("StatelessAuthenticationEntryPoint: {}", (Object)this.unauthorizedHandler);
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)httpSecurity.csrf().disable()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.unauthorizedHandler).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().anyRequest()).authenticated();
            httpSecurity.addFilterBefore((Filter)this.statelessAuthenticationFilterBean(), UsernamePasswordAuthenticationFilter.class);
            httpSecurity.headers().cacheControl();
            if (this.corsFilterProperties.isEnabled()) {
                LOGGER.trace("Adding CORS Filter");
                httpSecurity.cors();
            }
        }

        @Autowired
        public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
            auth.userDetailsService(this.userDetailsService());
        }
    }
}

