/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.tsc.aap.client.security.util;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import uk.ac.ebi.tsc.aap.client.model.Domain;

public class SecurityUtil {
    public static final String AAP_ADMIN_ROLE = "ROLE_aap.admin";

    private SecurityUtil() {
    }

    public static boolean hasAdminRole() {
        Authentication authentication = SecurityUtil.retrieveAuthentication();
        if (authentication == null) {
            return false;
        }
        return authentication.getAuthorities().stream().map(r -> (Domain)r).anyMatch(r -> r.getAuthority().equals(AAP_ADMIN_ROLE));
    }

    public static void nullifyAuthentication() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public static String retrieveAuthenticatedName() {
        Authentication authentication = SecurityUtil.retrieveAuthentication();
        if (authentication == null) {
            return null;
        }
        return authentication.getName();
    }

    public static Authentication retrieveAuthentication() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null) {
            return null;
        }
        return context.getAuthentication();
    }
}

