/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.tsc.aap.client.security;

import java.io.InputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.InvalidJwtSignatureException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.stereotype.Component;
import uk.ac.ebi.tsc.aap.client.exception.InvalidJWTTokenException;
import uk.ac.ebi.tsc.aap.client.exception.TokenExpiredException;
import uk.ac.ebi.tsc.aap.client.model.Domain;
import uk.ac.ebi.tsc.aap.client.model.User;

@Component
public class TokenHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenHandler.class);
    public JwtConsumer jwtConsumer;
    @Value(value="${jwt.certificate}")
    private String certificatePath;

    @PostConstruct
    public void initPropertyDependentFields() throws Exception {
        LOGGER.trace("initPropertyDependentFields- certificatePath***** {}", (Object)this.certificatePath);
        this.setJwtConsumer(this.certificatePath);
    }

    void setJwtConsumer(String path) throws Exception {
        InputStream inputStream = new DefaultResourceLoader().getResource(path).getInputStream();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
        PublicKey verifyingKey = certificate.getPublicKey();
        this.setJwtConsumer(verifyingKey);
    }

    void setJwtConsumer(PublicKey verifyingKey) {
        this.jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(30).setRequireSubject().setVerificationKey((Key)verifyingKey).setRelaxVerificationKeyValidation().build();
    }

    public User parseUserFromToken(String token) throws InvalidJWTTokenException, TokenExpiredException {
        try {
            HashSet domainsSet = new HashSet();
            JwtClaims jwtClaims = this.jwtConsumer.processToClaims(token);
            String userReference = jwtClaims.getSubject();
            String nickname = jwtClaims.getStringClaimValue("nickname");
            String email = jwtClaims.getStringClaimValue("email");
            String fullName = jwtClaims.getStringClaimValue("name");
            List domains = jwtClaims.getStringListClaimValue("domains");
            domains.forEach(name -> domainsSet.add(new Domain(name, null, null)));
            User user = new User(nickname, email, userReference, fullName, domainsSet);
            user.setAccountNonLocked(true);
            return user;
        }
        catch (InvalidJwtSignatureException e) {
            this.logJwtError(e.getMessage(), token);
            throw new InvalidJWTTokenException("Supplied Token is not valid for this server");
        }
        catch (MalformedClaimException e) {
            this.logJwtError(e.getMessage(), token);
            throw new InvalidJWTTokenException(e.getMessage());
        }
        catch (InvalidJwtException e) {
            this.logJwtError(e.getMessage(), token);
            if (e.getMessage().contains("Unable to process JOSE object")) {
                throw new InvalidJWTTokenException("Supplied Token is not a valid JWT token");
            }
            if (e.getMessage().contains("JWT is no longer valid")) {
                throw new TokenExpiredException("Supplied Token has been expired");
            }
            throw new InvalidJWTTokenException(e.getMessage());
        }
    }

    private void logJwtError(String message, String token) {
        LOGGER.error("JWT Error : Incoming Token '" + token + "' : Error Message '" + message + "'");
    }
}

