/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.tsc.aap.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import uk.ac.ebi.tsc.aap.client.model.Domain;

public class User
implements Serializable,
UserDetails {
    private static final long serialVersionUID = 1L;
    private String userName;
    private String email;
    private String userReference;
    private String fullName;
    private Set<Domain> domains;
    private String organization;
    private boolean accountNonLocked;

    @Deprecated
    public User() {
    }

    public User(String userName, String email, String userReference, String fullName, Set<Domain> domains) {
        this.userName = userName;
        this.email = email;
        this.userReference = userReference;
        this.fullName = fullName;
        this.domains = domains;
    }

    public String getUserName() {
        return this.userName;
    }

    void setUserName(String userName) {
        this.userName = userName;
    }

    public String getEmail() {
        return this.email;
    }

    void setEmail(String email) {
        this.email = email;
    }

    public String getUserReference() {
        return this.userReference;
    }

    void setUserReference(String userReference) {
        this.userReference = userReference;
    }

    public String getFullName() {
        return this.fullName;
    }

    void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setDomains(Set<Domain> domains) {
        this.domains = domains;
    }

    public Set<Domain> getDomains() {
        return this.domains;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public void setAccountNonLocked(boolean accountNonLocked) {
        this.accountNonLocked = accountNonLocked;
    }

    public String toString() {
        return "User [userName=" + this.userName + ", email=" + this.email + ", userReference=" + this.userReference + ", fullName=" + this.fullName + ", domains=" + this.domains + ", organization=" + this.organization + ", accountNonLocked=" + this.accountNonLocked + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        if (this.userName != null ? !this.userName.equals(user.userName) : user.userName != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(user.email) : user.email != null) {
            return false;
        }
        return this.userReference != null ? this.userReference.equals(user.userReference) : user.userReference == null;
    }

    public int hashCode() {
        int result = this.userName != null ? this.userName.hashCode() : 0;
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.userReference != null ? this.userReference.hashCode() : 0);
        return result;
    }

    @JsonIgnore
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.domains;
    }

    @JsonIgnore
    public String getPassword() {
        return null;
    }

    @JsonIgnore
    public String getUsername() {
        return this.userReference;
    }

    @JsonIgnore
    public String getOrganization() {
        return this.organization;
    }

    @JsonIgnore
    public boolean isAccountNonExpired() {
        return true;
    }

    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @JsonIgnore
    public boolean isEnabled() {
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private User user = new User();

        @Deprecated
        public Builder() {
        }

        @Deprecated
        public Builder(String reference) {
            this();
            this.withReference(reference);
        }

        public Builder withReference(String reference) {
            this.user.setUserReference(reference);
            return this;
        }

        public Builder withUsername(String username) {
            this.user.setUserName(username);
            return this;
        }

        public Builder withEmail(String email) {
            this.user.setEmail(email);
            return this;
        }

        public Builder withFullName(String name) {
            this.user.setFullName(name);
            return this;
        }

        public Builder withDomains(Set<Domain> domains) {
            this.user.setDomains(domains);
            return this;
        }

        public Builder withDomains(String ... domainNames) {
            HashSet<Domain> domains = new HashSet<Domain>();
            Arrays.asList(domainNames).forEach(name -> domains.add(Domain.builder().withName((String)name).build()));
            this.user.setDomains(domains);
            return this;
        }

        public Builder withAccountNonLocked(boolean accountNonLocked) {
            this.user.setAccountNonLocked(accountNonLocked);
            return this;
        }

        public User build() {
            return this.user;
        }
    }
}

