/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.tsc.aap.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import uk.ac.ebi.tsc.aap.client.model.Domain;
import uk.ac.ebi.tsc.aap.client.model.User;

public class Profile {
    private String reference;
    private User user;
    private Domain domain;
    private String schema;
    private Map<String, String> attributes = new HashMap<String, String>();

    private Profile() {
    }

    public Profile(String reference, User user, Domain domain, Map<String, String> attributes) {
        this(reference, user, domain, null, attributes);
    }

    public Profile(String reference, User user, Domain domain, String schema, Map<String, String> attributes) {
        this.reference = reference;
        this.user = user;
        this.domain = domain;
        this.schema = schema;
        this.attributes = attributes;
    }

    public String getReference() {
        return this.reference;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public User getUser() {
        return this.user;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Domain getDomain() {
        return this.domain;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSchema() {
        return this.schema;
    }

    public boolean hasSchema() {
        return this.schema != null && !"".equals(this.schema.trim());
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    @JsonIgnore
    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @JsonIgnore
    public String getDomainName() {
        return this.domain != null ? this.domain.getDomainName() : null;
    }

    @JsonIgnore
    public String getDomainReference() {
        return this.domain != null ? this.domain.getDomainReference() : null;
    }

    @JsonIgnore
    public String getUserReference() {
        return this.user != null ? this.user.getUserReference() : null;
    }

    @JsonIgnore
    public boolean retrieveUserAccountNonLocked() throws IllegalStateException {
        if (!this.isUserProfile()) {
            throw new IllegalStateException("Inappropriate internal system call made on a Domain Profile object");
        }
        return this.getUser().isAccountNonLocked();
    }

    @JsonIgnore
    public boolean isUserProfile() {
        return this.getUser() != null && this.getUser().getUserReference() != null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        Profile profile = new Profile();

        @Deprecated
        public Builder() {
        }

        @Deprecated
        public Builder(String reference) {
            this.profile.reference = reference;
        }

        public Builder withReference(String reference) {
            this.profile.reference = reference;
            return this;
        }

        public Builder withUser(User user) {
            this.profile.user = user;
            return this;
        }

        public Builder withUser(String userReference) {
            if (userReference != null) {
                this.profile.user = User.builder().withReference(userReference).build();
            }
            return this;
        }

        public Builder withDomain(String domainReference) {
            if (domainReference != null) {
                this.profile.domain = Domain.builder().withReference(domainReference).build();
            }
            return this;
        }

        public Builder withSchema(String schema) {
            this.profile.schema = schema;
            return this;
        }

        public Builder withAttributes(Map<String, String> attributes) {
            this.profile.attributes = attributes;
            return this;
        }

        public Builder withAttribute(String name, String value) {
            this.profile.attributes.put(name, value);
            return this;
        }

        public Profile build() {
            return this.profile;
        }
    }
}

